/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs;

import com.atlassian.fisheye.SpringIntegrationTestBase;
import com.atlassian.fisheye.dvcs.DvcsCache;
import com.atlassian.fisheye.dvcs.DvcsRepoValidation;
import com.atlassian.fisheye.dvcs.DvcsScanner;
import com.atlassian.fisheye.dvcs.DvcsTestHarness;
import com.atlassian.fisheye.dvcs.db.DvcsRevInfo;
import com.atlassian.fisheye.rep.BaseTestHarness;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.rep.BaseRepositoryEngine;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.util.FileSystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;

public abstract class DvcsTestBase<H extends DvcsTestHarness<E, S>, F extends DvcsRevInfo, CS extends ChangeSetImpl<F>, C extends DvcsCache<F, CS, T>, S extends DvcsScanner<F, CS, C, T>, E extends BaseRepositoryEngine<S, C>, T extends CommonStringTables>
extends SpringIntegrationTestBase {
    public static final List<String> NO_PARENTS = Collections.emptyList();
    protected FileSystemUtils fileSystemUtils = new FileSystemUtils();
    protected H testHarness;
    private String executable = null;
    private File dumpDir = null;

    protected abstract H createTestHarness() throws IOException;

    protected abstract String findExecutable() throws IOException;

    public DvcsTestBase(String dumpDirName) {
        this.dumpDir = new File(FisheyeTestEnv.WORKSPACE_DIR, dumpDirName);
        if (!this.dumpDir.exists()) {
            throw new IllegalArgumentException("The directory " + this.dumpDir.getAbsolutePath() + " does not exist");
        }
        if (!this.dumpDir.isDirectory()) {
            throw new IllegalArgumentException(this.dumpDir.getAbsolutePath() + " is not a directory");
        }
    }

    @Override
    protected List<String> getApplicationContexts() {
        ArrayList<String> ctxs = new ArrayList<String>();
        ctxs.add("com/atlassian/fisheye/util/testApplicationContext.xml");
        ctxs.add("com/atlassian/fisheye/dvcs/DvcsTest-ApplicationConfig.xml");
        return ctxs;
    }

    @Before
    public void initialiseTestHarness() throws IOException {
        AppConfig.setTestMode();
        this.testHarness = this.createTestHarness();
    }

    protected C getCache() {
        return (C)((DvcsCache)((BaseRepositoryEngine)((BaseTestHarness)this.testHarness).getEngine()).getInternalRevisionCache());
    }

    protected String getExecutable() throws IOException {
        if (this.executable == null) {
            this.executable = this.findExecutable();
        }
        return this.executable;
    }

    protected int getMaxCommitters() {
        return -1;
    }

    protected File getDumpZipFile(String dumpName) {
        return new File(this.dumpDir, dumpName + ".zip");
    }

    protected int getBlockSize() {
        return -1;
    }

    protected AllowType getAllowRules() {
        return null;
    }

    protected String getSubPath() {
        return null;
    }

    protected boolean getStoreDiffs() {
        return true;
    }

    protected String getPrivateKeyContents() {
        return null;
    }

    public void slurpDump(String dumpName) throws Exception {
        ((BaseTestHarness)this.testHarness).setAllow(this.getAllowRules());
        ((BaseTestHarness)this.testHarness).setStoreDiffs(this.getStoreDiffs());
        ((BaseTestHarness)this.testHarness).setBlockSize(this.getBlockSize());
        ((DvcsTestHarness)this.testHarness).setMaxCommitters(this.getMaxCommitters());
        ((DvcsTestHarness)this.testHarness).setScmExecutable(this.getExecutable());
        ((DvcsTestHarness)this.testHarness).setPrivateKeyContents(this.getPrivateKeyContents());
        ((BaseTestHarness)this.testHarness).setFlagWarnings(this.isFlagWarnings());
        ((BaseTestHarness)this.testHarness).slurpDump(this.getDumpZipFile(dumpName));
    }

    protected void slurpIncremental(String dumpName) throws Exception {
        ((BaseTestHarness)this.testHarness).doIncSlurp(this.getDumpZipFile(dumpName));
    }

    protected void slurpRemote(String location) throws Exception {
        ((DvcsTestHarness)this.testHarness).setLocation(location);
        ((BaseTestHarness)this.testHarness).setRepoName("test");
        ((BaseTestHarness)this.testHarness).setAllow(this.getAllowRules());
        ((BaseTestHarness)this.testHarness).setStoreDiffs(this.getStoreDiffs());
        ((BaseTestHarness)this.testHarness).setBlockSize(this.getBlockSize());
        ((DvcsTestHarness)this.testHarness).setMaxCommitters(this.getMaxCommitters());
        ((DvcsTestHarness)this.testHarness).setScmExecutable(this.getExecutable());
        ((DvcsTestHarness)this.testHarness).setPrivateKeyContents(this.getPrivateKeyContents());
        ((BaseTestHarness)this.testHarness).createEngineAndSlurp();
    }

    public static void assertCommitEquals(String message, DvcsRepoValidation.Commit expectedCommit, ChangeSetImpl changeSet) throws DbException {
        Assert.assertEquals((String)(message + ", hash"), (Object)expectedCommit.hash, (Object)changeSet.getId());
        Assert.assertEquals((String)(message + ", author"), (Object)expectedCommit.author, (Object)changeSet.getAuthor());
        Assert.assertEquals((String)(message + ", comment"), (Object)expectedCommit.desc, (Object)changeSet.getComment());
        Assert.assertEquals((String)(message + ", branches"), expectedCommit.branches, (Object)changeSet.getBranches());
        Assert.assertEquals((String)(message + ", date"), (long)expectedCommit.date, (long)changeSet.getDate());
        Assert.assertEquals((String)(message + ", number of revisions"), (long)expectedCommit.fileRevs, (long)changeSet.getRevisionInfosCount());
        if (expectedCommit.nextCrossBranchCommits != null) {
            Assert.assertEquals((String)(message + ", nextCrossBranchCommits"), expectedCommit.nextCrossBranchCommits, (Object)changeSet.getNextCrossBranchCommits());
        }
        Assert.assertEquals((String)(message + ", parents"), new LinkedHashSet<String>(expectedCommit.parents), new LinkedHashSet(changeSet.getParents()));
    }

    public static void doAssertCommitData(DvcsCache cache, List<DvcsRepoValidation.Commit> commitData) {
        List commitList = cache.getCommitList();
        Assert.assertEquals((long)commitData.size(), (long)commitList.size());
        for (DvcsRepoValidation.Commit commit : commitData) {
            DvcsTestBase.assertCommitEquals("Rev:" + commit.hash, commit, cache.getChangeSet(commit.hash));
        }
    }

    public void assertCommitData(List<DvcsRepoValidation.Commit> commitData) throws DbException {
        List commitList = this.getCache().getCommitList();
        Assert.assertEquals((long)commitData.size(), (long)commitList.size());
        for (DvcsRepoValidation.Commit commit : commitData) {
            DvcsTestBase.assertCommitEquals("Rev:" + commit.hash, commit, this.getCache().getChangeSet(commit.hash));
        }
    }

    public void assertRevisionParents(DvcsRepoValidation.Revision expectedRev, F actualRev) {
        LinkedHashSet<DvcsRepoValidation.RevisionParent> actualParentRevs = new LinkedHashSet<DvcsRepoValidation.RevisionParent>();
        LinkedHashSet<DvcsRepoValidation.RevisionParent> expectedParentRevs = new LinkedHashSet<DvcsRepoValidation.RevisionParent>(expectedRev.parents);
        for (RevInfoKey actualAncKey : actualRev.getAncestors()) {
            actualParentRevs.add(new DvcsRepoValidation.RevisionParent(actualAncKey.getPath().getPath(), actualAncKey.getRev()));
        }
        Assert.assertEquals((String)(expectedRev.name + ":" + expectedRev.rev + " parents don't match"), expectedParentRevs, actualParentRevs);
    }

    public void assertRevisionEquals(DvcsRepoValidation.Revision expectedRev, F actualRev) throws DbException {
        String id = expectedRev.name + ":" + expectedRev.rev;
        Assert.assertNotNull((String)(id + " not found"), actualRev);
        Assert.assertTrue((String)id, (boolean)actualRev.isFile());
        Assert.assertFalse((String)id, (boolean)actualRev.isDir());
        Assert.assertEquals((String)id, (Object)expectedRev.rev, (Object)actualRev.getChangeSetId());
        Assert.assertEquals((String)id, (Object)expectedRev.author, (Object)actualRev.getAuthor());
        Assert.assertEquals((String)id, (Object)expectedRev.msg, (Object)actualRev.getComment());
        Assert.assertEquals((String)id, (long)expectedRev.date, (long)actualRev.getDate());
        Assert.assertEquals((String)id, expectedRev.branches, (Object)actualRev.getBranches());
        Assert.assertEquals((String)(id + " added"), (Object)(expectedRev.state == DvcsRepoValidation.RevState.Added ? 1 : 0), (Object)actualRev.isAdded());
        Assert.assertEquals((String)(id + " deleted"), (Object)(expectedRev.state == DvcsRepoValidation.RevState.Deleted ? 1 : 0), (Object)actualRev.isDead());
        Assert.assertEquals((String)(id + " renamed"), (Object)(expectedRev.state == DvcsRepoValidation.RevState.Renamed ? 1 : 0), (Object)actualRev.isMove());
        Assert.assertEquals((String)(id + " copied"), (Object)(expectedRev.state == DvcsRepoValidation.RevState.Copied ? 1 : 0), (Object)actualRev.isCopy());
        this.assertRevisionParents(expectedRev, actualRev);
        Assert.assertEquals((String)id, (Object)(expectedRev.state == DvcsRepoValidation.RevState.Modified || expectedRev.state == DvcsRepoValidation.RevState.MetaChange ? 1 : 0), (Object)actualRev.isModify());
        Assert.assertEquals((String)id, (Object)(expectedRev.state != DvcsRepoValidation.RevState.Added ? 1 : 0), (Object)(actualRev.getAncestorLink() != null ? 1 : 0));
        if (expectedRev.state != DvcsRepoValidation.RevState.Added) {
            switch (expectedRev.state) {
                case Copied: {
                    Assert.assertNull((String)(id + " shouldn't have moveSource"), (Object)actualRev.getMoveSource());
                    RevInfoKey copyFrom = actualRev.getCopySource();
                    Assert.assertTrue((String)id, (boolean)expectedRev.parents.contains(new DvcsRepoValidation.RevisionParent(copyFrom.getPath().getPath(), copyFrom.getRev())));
                    Assert.assertEquals((String)id, (Object)expectedRev.fromPath, (Object)copyFrom.getPath().getPath());
                    DvcsRevInfo copyParent = this.getCache().getFileRevision(copyFrom);
                    Assert.assertTrue((String)id, (boolean)copyParent.getCopyDestinations().contains(actualRev.getRevInfoKey()));
                    Assert.assertEquals((String)id, (Object)expectedRev.fromPath, (Object)copyParent.getPath().getPath());
                    break;
                }
                case Renamed: {
                    Assert.assertNull((String)id, (Object)actualRev.getCopySource());
                    RevInfoKey moveFrom = actualRev.getMoveSource();
                    Assert.assertEquals((String)id, (Object)expectedRev.fromPath, (Object)moveFrom.getPath().getPath());
                    Assert.assertTrue((String)id, (boolean)expectedRev.parents.contains(new DvcsRepoValidation.RevisionParent(moveFrom.getPath().getPath(), moveFrom.getRev())));
                    DvcsRevInfo moveParent = this.getCache().getFileRevision(moveFrom);
                    Assert.assertTrue((String)id, (boolean)moveParent.getMoveDestination().equals((Object)actualRev.getRevInfoKey()));
                    Assert.assertEquals((String)id, (Object)expectedRev.fromPath, (Object)moveParent.getPath().getPath());
                    break;
                }
                case Deleted: 
                case Modified: {
                    Assert.assertNull((String)(id + " shouldn't have moveSource"), (Object)actualRev.getMoveSource());
                    Assert.assertNull((String)(id + " shouldn't have copySource"), (Object)actualRev.getCopySource());
                }
            }
        }
        Assert.assertEquals((String)(id + " binary"), (Object)expectedRev.binary, (Object)actualRev.isBinary());
        Assert.assertEquals((String)(id + " linecount"), (long)expectedRev.lineCount, (long)actualRev.getLineCount());
        Assert.assertEquals((String)(id + " lines added"), (long)expectedRev.linesAdded, (long)actualRev.getLinesAdded());
        Assert.assertEquals((String)(id + " lines removed"), (long)expectedRev.linesRemoved, (long)actualRev.getLinesRemoved());
    }

    public void assertRevisionData(DvcsRepoValidation.FileRevs revs) throws DbException {
        FileHistory history = this.getCache().getFileHistory(new Path((CharSequence)revs.name));
        Assert.assertEquals((String)("Number of revisions to " + revs.name), (long)revs.revisions.size(), (long)history.getRevisions().size());
        for (DvcsRepoValidation.Revision expectedRev : revs.revisions) {
            this.assertRevisionEquals(expectedRev, this.getCache().getFileRevision(new RevInfoKey(new Path((CharSequence)expectedRev.name), expectedRev.rev)));
        }
    }

    public H getTestHarness() {
        return this.testHarness;
    }

    public boolean isFlagWarnings() {
        return false;
    }
}

