/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dvcs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class DvcsRepoValidation {
    private static List<String> createParentList(String parent0, String parent1) {
        ArrayList<String> parents = new ArrayList<String>();
        if (parent0 != null) {
            parents.add(parent0);
        }
        if (parent1 != null) {
            parents.add(parent1);
        }
        return parents;
    }

    public static class FileRevs
    implements Cloneable {
        public final String name;
        public List<Revision> revisions = Lists.newLinkedList();
        private Revision current = null;

        public static FileRevs file(String name) {
            return new FileRevs(name);
        }

        private FileRevs(String name) {
            this.name = name;
        }

        public FileRevs rev(Revision rev) {
            rev.name(this.name);
            this.revisions.add(rev);
            this.current = rev;
            return this;
        }

        public FileRevs rev(String rev, String parent0, String parent1, String author, String msg, long date, String branch, RevState state, String fromPath, boolean binary, int lineCount, int linesAdded, int linesRemoved) {
            return this.rev(rev, (List<String>)DvcsRepoValidation.createParentList(parent0, parent1), author, msg, date, branch, state, fromPath, binary, lineCount, linesAdded, linesRemoved);
        }

        public FileRevs rev(String rev, String parent0, String parent1, String author, String msg, long date, String[] branches, RevState state, String fromPath, boolean binary, int lineCount, int linesAdded, int linesRemoved) {
            return this.rev(rev, (List<String>)DvcsRepoValidation.createParentList(parent0, parent1), author, msg, date, branches, state, fromPath, binary, lineCount, linesAdded, linesRemoved);
        }

        public FileRevs rev(String rev, List<String> parents, String author, String msg, long date, String branch, RevState state, String fromPath, boolean binary, int lineCount, int linesAdded, int linesRemoved) {
            this.current = new Revision().name(this.name).rev(rev).author(author).msg(msg).date(date).branch(branch).state(state).fromPath(fromPath).binary(binary).lineCount(lineCount).linesAdded(linesAdded).linesRemoved(linesRemoved);
            this.revisions.add(this.current);
            for (String p : parents) {
                this.current.parent(p);
            }
            return this;
        }

        public FileRevs rev(String rev, List<String> parents, String author, String msg, long date, String[] branches, RevState state, String fromPath, boolean binary, int lineCount, int linesAdded, int linesRemoved) {
            this.current = new Revision().name(this.name).rev(rev).author(author).msg(msg).date(date).branches(branches).state(state).fromPath(fromPath).binary(binary).lineCount(lineCount).linesAdded(linesAdded).linesRemoved(linesRemoved);
            this.revisions.add(this.current);
            for (String p : parents) {
                this.current.parent(p);
            }
            return this;
        }

        public FileRevs rev(String rev) {
            this.current = new Revision().name(this.name).rev(rev);
            this.revisions.add(this.current);
            return this;
        }

        public FileRevs author(String author) {
            this.current.author(author);
            return this;
        }

        public FileRevs msg(String msg) {
            this.current.msg(msg);
            return this;
        }

        public FileRevs date(long date) {
            this.current.date(date);
            return this;
        }

        public FileRevs branch(String branch) {
            this.current.branch(branch);
            return this;
        }

        public FileRevs branches(String[] branches) {
            this.current.branches(branches);
            return this;
        }

        public FileRevs state(RevState state) {
            this.current.state(state);
            return this;
        }

        public FileRevs fromPath(String fromPath) {
            this.current.fromPath(fromPath);
            return this;
        }

        public FileRevs binary(boolean binary) {
            this.current.binary(binary);
            return this;
        }

        public FileRevs lineCount(int lineCount) {
            this.current.lineCount(lineCount);
            return this;
        }

        public FileRevs linesAdded(int linesAdded) {
            this.current.linesAdded(linesAdded);
            return this;
        }

        public FileRevs linesRemoved(int linesRemoved) {
            this.current.linesRemoved(linesRemoved);
            return this;
        }

        public FileRevs parent(String path, String hash) {
            this.current.parent(path, hash);
            return this;
        }

        public FileRevs clone() {
            try {
                FileRevs clone = (FileRevs)super.clone();
                clone.revisions = Lists.newLinkedList(this.revisions);
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append(this.name).append("[");
            String sep = "";
            for (Revision rev : this.revisions) {
                sb.append(sep).append(rev.rev);
                sep = ", ";
            }
            return sb.append("]").toString();
        }
    }

    public static final class Revision {
        public String rev;
        public String name;
        public String author;
        public String msg;
        public long date;
        public Set<String> branches = new HashSet<String>();
        public RevState state = RevState.Modified;
        public String fromPath;
        public List<RevisionParent> parents = new ArrayList<RevisionParent>();
        public boolean binary = false;
        public int lineCount = 0;
        public int linesAdded = 0;
        public int linesRemoved = 0;
        public boolean copy = false;
        public boolean move = false;

        public Revision() {
        }

        public Revision(String name, String rev, List<String> parents, String author, String msg, long date, String branch, RevState state, String fromPath, boolean binary, int lineCount, int linesAdded, int linesRemoved) {
            this.rev = rev;
            this.name = name;
            this.author = author;
            this.msg = msg;
            this.date = date;
            if (branch != null) {
                this.branches.add(branch);
            }
            this.state = state;
            this.fromPath = fromPath;
            this.binary = binary;
            this.lineCount = lineCount;
            this.linesAdded = linesAdded;
            this.linesRemoved = linesRemoved;
            for (String p : parents) {
                this.parent(p);
            }
        }

        public Revision(String name, String rev, List<String> parents, String author, String msg, long date, Collection<String> branches, RevState state, String fromPath, boolean binary, int lineCount, int linesAdded, int linesRemoved) {
            this.rev = rev;
            this.name = name;
            this.author = author;
            this.msg = msg;
            this.date = date;
            if (branches != null) {
                this.branches.addAll(branches);
            }
            this.state = state;
            this.fromPath = fromPath;
            this.binary = binary;
            this.lineCount = lineCount;
            this.linesAdded = linesAdded;
            this.linesRemoved = linesRemoved;
            for (String p : parents) {
                this.parent(p);
            }
        }

        public String toString() {
            return this.name + ":" + this.rev;
        }

        public Revision name(String name) {
            this.name = name;
            if (this.fromPath == null) {
                this.fromPath = name;
            }
            return this;
        }

        public Revision rev(String rev) {
            this.rev = rev;
            return this;
        }

        public Revision author(String author) {
            this.author = author;
            return this;
        }

        public Revision msg(String msg) {
            this.msg = msg;
            return this;
        }

        public Revision date(long date) {
            this.date = date;
            return this;
        }

        public Revision branch(String branch) {
            if (branch != null) {
                this.branches.add(branch);
            }
            return this;
        }

        public Revision branches(String[] branches) {
            if (branches != null) {
                for (String branch : branches) {
                    this.branches.add(branch);
                }
            }
            return this;
        }

        public Revision state(RevState state) {
            this.state = state;
            return this;
        }

        public Revision fromPath(String fromPath) {
            this.fromPath = fromPath;
            return this;
        }

        public Revision binary(boolean binary) {
            this.binary = binary;
            return this;
        }

        public Revision lineCount(int lineCount) {
            this.lineCount = lineCount;
            return this;
        }

        public Revision linesAdded(int linesAdded) {
            this.linesAdded = linesAdded;
            return this;
        }

        public Revision linesRemoved(int linesRemoved) {
            this.linesRemoved = linesRemoved;
            return this;
        }

        public Revision isCopy(boolean isCopy) {
            this.copy = isCopy;
            return this;
        }

        public Revision isMove(boolean isMove) {
            this.move = isMove;
            return this;
        }

        public Revision parents(List<RevisionParent> parents) {
            this.parents = parents;
            return this;
        }

        public Revision parent(RevisionParent parent) {
            this.parents.add(parent);
            return this;
        }

        public Revision parent(String path, String hash) {
            this.parents.add(new RevisionParent(path, hash));
            return this;
        }

        public Revision parent(String parent) {
            this.parents.add(new RevisionParent(this.state == RevState.Copied || this.state == RevState.Renamed ? this.fromPath : this.name, parent));
            return this;
        }
    }

    public static final class RevisionParent {
        private final String path;
        private final String hash;

        public RevisionParent(String path, String hash) {
            this.path = path;
            this.hash = hash;
        }

        public String getPath() {
            return this.path;
        }

        public String getHash() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof RevisionParent) {
                RevisionParent o = (RevisionParent)obj;
                return StringUtils.equals((String)o.path, (String)this.path) && StringUtils.equals((String)o.hash, (String)this.hash);
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            return result;
        }

        public String toString() {
            return this.path + "@" + this.hash;
        }
    }

    public static enum RevState {
        Added,
        Deleted,
        Renamed,
        Copied,
        Modified,
        MetaChange;

    }

    public static class Commits {
        private List<Commit> commits = new LinkedList<Commit>();

        public static Commits first(Commit commit) {
            Commits cb = new Commits();
            cb.next(commit);
            return cb;
        }

        public static Commits first(String hash, String author, String desc, String branch, long date, int fileRevs) {
            return Commits.first(hash, (String)null, author, desc, new String[]{branch}, date, fileRevs);
        }

        public static Commits first(String hash, String author, String desc, String[] branches, long date, int fileRevs) {
            return Commits.first(hash, (String)null, author, desc, branches, date, fileRevs);
        }

        public static Commits first(String hash, String parent0, String author, String desc, String branch, long date, int fileRevs) {
            return Commits.first(hash, (List<String>)DvcsRepoValidation.createParentList(parent0, null), author, desc, new String[]{branch}, date, fileRevs);
        }

        public static Commits first(String hash, String parent0, String author, String desc, String[] branches, long date, int fileRevs) {
            return Commits.first(hash, (List<String>)DvcsRepoValidation.createParentList(parent0, null), author, desc, branches, date, fileRevs);
        }

        public static Commits first(String hash, String parent0, String parent1, String author, String desc, String branch, long date, int fileRevs) {
            return Commits.first(hash, (List<String>)DvcsRepoValidation.createParentList(parent0, parent1), author, desc, new String[]{branch}, date, fileRevs);
        }

        public static Commits first(String hash, String parent0, String parent1, String author, String desc, String[] branches, long date, int fileRevs) {
            return Commits.first(hash, (List<String>)DvcsRepoValidation.createParentList(parent0, parent1), author, desc, branches, date, fileRevs);
        }

        public static Commits first(String hash, List<String> parents, String author, String desc, String branch, long date, int fileRevs) {
            return Commits.first(hash, parents, author, desc, new String[]{branch}, date, fileRevs);
        }

        public static Commits first(String hash, List<String> parents, String author, String desc, String[] branches, long date, int fileRevs) {
            Commits cb = new Commits();
            cb.next(hash, parents, author, desc, branches, date, fileRevs);
            return cb;
        }

        public Commits next(String hash, String author, String desc, String branch, long date, int fileRevs) {
            return this.next(hash, (String)null, author, desc, new String[]{branch}, date, fileRevs);
        }

        public Commits next(String hash, String author, String desc, String[] branches, long date, int fileRevs) {
            return this.next(hash, (String)null, author, desc, branches, date, fileRevs);
        }

        public Commits next(String hash, String parent0, String author, String desc, String branch, long date, int fileRevs) {
            return this.next(hash, (List<String>)DvcsRepoValidation.createParentList(parent0, null), author, desc, new String[]{branch}, date, fileRevs);
        }

        public Commits next(String hash, String parent0, String author, String desc, String[] branches, long date, int fileRevs) {
            return this.next(hash, (List<String>)DvcsRepoValidation.createParentList(parent0, null), author, desc, branches, date, fileRevs);
        }

        public Commits next(String hash, String parent0, String parent1, String author, String desc, String[] branches, long date, int fileRevs) {
            return this.next(hash, (List<String>)DvcsRepoValidation.createParentList(parent0, parent1), author, desc, branches, date, fileRevs);
        }

        public Commits next(String hash, List<String> parents, String author, String desc, String branch, long date, int fileRevs) {
            return this.next(hash, parents, author, desc, new String[]{branch}, date, fileRevs);
        }

        public Commits next(String hash, List<String> parents, String author, String desc, String[] branches, long date, int fileRevs) {
            this.commits.add(new Commit(hash, parents, author, desc, branches, date, fileRevs));
            return this;
        }

        public Commits next(Commit commit) {
            this.commits.add(commit);
            return this;
        }

        public List<Commit> l() {
            return this.commits;
        }
    }

    public static class Commit {
        public String hash;
        public List<String> parents = new ArrayList<String>();
        public String author;
        public String desc;
        public long date;
        public int fileRevs;
        public Set<String> branches = new HashSet<String>();
        public Set<String> nextCrossBranchCommits = null;

        public Commit() {
        }

        public Commit(String hash, List<String> parents, String author, String desc, String[] branches, long date, int fileRevs) {
            this.hash = hash;
            if (parents != null) {
                this.parents = parents;
            }
            this.author = author;
            this.desc = desc;
            this.branches = new HashSet<String>();
            this.branches.addAll(Arrays.asList(branches));
            this.date = date;
            this.fileRevs = fileRevs;
        }

        public Commit(String hash) {
            this.hash(hash);
        }

        public Commit hash(String hash) {
            this.hash = hash;
            return this;
        }

        public Commit parents(List<String> parents) {
            this.parents = parents;
            return this;
        }

        public Commit parents(String ... parents) {
            this.parents.addAll(Arrays.asList(parents));
            return this;
        }

        public Commit author(String author) {
            this.author = author;
            return this;
        }

        public Commit desc(String desc) {
            this.desc = desc;
            return this;
        }

        public Commit branches(Set<String> branches) {
            this.branches = branches;
            return this;
        }

        public Commit branches(String ... branches) {
            this.branches.addAll(Arrays.asList(branches));
            return this;
        }

        public Commit date(long date) {
            this.date = date;
            return this;
        }

        public Commit fileRevs(int fileRevs) {
            this.fileRevs = fileRevs;
            return this;
        }

        public Commit branch(String branch) {
            this.branches.add(branch);
            return this;
        }

        public Commit parent(String parent) {
            this.parents.add(parent);
            return this;
        }

        public Commit nextCrossBranchCommits(String ... hashes) {
            if (this.nextCrossBranchCommits == null) {
                this.nextCrossBranchCommits = new HashSet<String>();
            }
            this.nextCrossBranchCommits.addAll(Arrays.asList(hashes));
            return this;
        }
    }
}

