/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dbtest;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.template.TemplateManager;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fisheye.activity.ActivityItemManager;
import com.atlassian.fisheye.activity.DefaultActivityItemManager;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.web.DefaultWatchManager;
import com.cenqua.fisheye.web.MailEnabledTestBase;
import com.cenqua.fisheye.web.Watch;
import com.cenqua.fisheye.web.WatchDAO;
import com.cenqua.fisheye.web.WatchManager;
import java.text.ParseException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class WatchManagerMailTest
extends MailEnabledTestBase {
    private static final String REP = "cvs2";
    private static final Path PATH = new Path((CharSequence)"/CleanSweeper.java");
    private WatchManager wm;
    private Mailer mailer;
    private CommitterUserMappingManager committerUserMappingManager;
    private RootConfig rootConfig;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rootConfig = (RootConfig)SpringContext.getComponentByClass(RootConfig.class);
        this.committerUserMappingManager = (CommitterUserMappingManager)SpringContext.getComponentByClass(CommitterUserMappingManager.class);
        ActivityItemManager activityItemManager = (ActivityItemManager)SpringContext.getComponentByClass(DefaultActivityItemManager.class);
        TemplateManager templateManager = (TemplateManager)SpringContext.getComponentByClass(TemplateManager.class);
        RepositoryManager repositoryManager = (RepositoryManager)SpringContext.getComponentByClass(RepositoryManager.class);
        EventPublisher eventPublisher = (EventPublisher)SpringContext.getComponent(EventPublisher.class, (String)"eventPublisher");
        this.mailer = (Mailer)SpringContext.getComponentByClass(Mailer.class);
        EffectiveUserProviderImpl effectiveUserProvider = (EffectiveUserProviderImpl)SpringContext.getComponentByClass(EffectiveUserProviderImpl.class);
        WatchDAO watchDAO = (WatchDAO)SpringContext.getComponentByClass(WatchDAO.class);
        FecruUserDAO userDAO = (FecruUserDAO)SpringContext.getComponentByClass(FecruUserDAO.class);
        TxTemplate txTemplate = (TxTemplate)SpringContext.getComponent((String)"txTemplate");
        this.wm = new DefaultWatchManager(txTemplate, watchDAO, userDAO, eventPublisher, activityItemManager, repositoryManager, this.committerUserMappingManager, templateManager, this.mailer, effectiveUserProvider);
        junit.framework.Assert.assertFalse((boolean)this.wm.isStopped());
        this.greenmail.setUser("test@test.com", "test", "test");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            this.deleteWatch("watchmanagertest", REP, PATH);
            this.deleteWatch("otheruser", REP, PATH);
            this.deleteEmail();
            this.committerUserMappingManager.deleteAllForUser("watchmanagertest");
            this.mailer.reload(this.rootConfig.getConfig().getSmtp());
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testDeletedUser() throws Exception {
        junit.framework.Assert.assertTrue((boolean)this.um.existsLicensedUser("watchmanagertest"));
        Watch w = this.setupWatch("watchmanagertest", REP, PATH);
        junit.framework.Assert.assertEquals((int)1, (int)this.wm.getWatchesForUser("watchmanagertest").size());
        this.um.deleteUserFully("watchmanagertest");
        junit.framework.Assert.assertEquals((int)0, (int)this.wm.getWatchesForUser("watchmanagertest").size());
    }

    @Test
    public void testWatchCheckerSanity() throws Exception {
        this.setupWatch("watchmanagertest", REP, PATH);
        junit.framework.Assert.assertEquals((int)1, (int)this.wm.getWatchesForUser("watchmanagertest").size());
        Message[] messages = this.advanceAndWaitForMessages();
        for (int i = 0; i < 12; ++i) {
            junit.framework.Assert.assertEquals((String)"watchmanagertest@lowercase.com", (String)messages[i].getAllRecipients()[0].toString());
        }
    }

    @Test
    public void testDeleteWatch() throws Exception {
        this.setupWatch("otheruser", REP, PATH);
        this.setupWatch("watchmanagertest", REP, PATH);
        junit.framework.Assert.assertEquals((int)1, (int)this.wm.getWatchesForUser("otheruser").size());
        junit.framework.Assert.assertEquals((int)1, (int)this.wm.getWatchesForUser("watchmanagertest").size());
        this.deleteWatch("watchmanagertest", REP, PATH);
        junit.framework.Assert.assertEquals((int)1, (int)this.wm.getWatchesForUser("otheruser").size());
        junit.framework.Assert.assertEquals((int)0, (int)this.wm.getWatchesForUser("watchmanagertest").size());
        Message[] messages = this.advanceAndWaitForMessages();
        for (int i = 0; i < 12; ++i) {
            Address[] recipients = messages[i].getAllRecipients();
            junit.framework.Assert.assertEquals((int)1, (int)recipients.length);
            junit.framework.Assert.assertEquals((String)"otheruser@uppercase.com", (String)recipients[0].toString());
        }
    }

    @Test
    public void testFromWithMappedUserEmail_useUserAddress() throws Exception {
        this.setupWatch("watchmanagertest", REP, PATH);
        this.committerUserMappingManager.addMapping("watchmanagertest", REP, "anthony");
        this.mailer.setUseFrom(false);
        Message[] messages = this.advanceAndWaitForMessages();
        InternetAddress fromAnthony = (InternetAddress)messages[0].getFrom()[0];
        InternetAddress fromMatt = (InternetAddress)messages[3].getFrom()[0];
        Assert.assertThat((Object)fromAnthony.getAddress(), (Matcher)Matchers.equalTo((Object)"watchmanagertest@lowercase.com"));
        Assert.assertThat((Object)fromMatt.getAddress(), (Matcher)Matchers.equalTo((Object)this.rootConfig.getConfig().getSmtp().getFrom()));
    }

    @Test
    public void testFromWithMappedUserEmail_useServerAddress() throws Exception {
        this.setupWatch("watchmanagertest", REP, PATH);
        this.committerUserMappingManager.addMapping("watchmanagertest", REP, "anthony");
        this.mailer.setUseFrom(true);
        Message[] messages = this.advanceAndWaitForMessages();
        InternetAddress fromAnthony = (InternetAddress)messages[0].getFrom()[0];
        InternetAddress fromMatt = (InternetAddress)messages[3].getFrom()[0];
        Assert.assertThat((Object)fromAnthony.getAddress(), (Matcher)Matchers.equalTo((Object)this.rootConfig.getConfig().getSmtp().getFrom()));
        Assert.assertThat((Object)fromMatt.getAddress(), (Matcher)Matchers.equalTo((Object)this.rootConfig.getConfig().getSmtp().getFrom()));
    }

    private Message[] advanceAndWaitForMessages() throws Exception {
        this.deleteEmail();
        TestFishEyeInstances.advanceSanity1Repos2(1);
        junit.framework.Assert.assertTrue((String)"Expected 12 messages in 60000ms", (boolean)this.greenmail.waitForIncomingEmail(60000L, 12));
        MimeMessage[] messages = this.greenmail.getReceivedMessages();
        junit.framework.Assert.assertEquals((int)12, (int)messages.length);
        return messages;
    }

    private void resetWatchLastCheckedTimeTo(DateTime date, Watch w) {
        w.setLastChecked(date.getMillis());
        this.wm.updateWatch(w);
    }

    private Watch setupWatch(String username, String rep, Path path) throws DbException, ParseException {
        junit.framework.Assert.assertFalse((boolean)this.wm.isStopped());
        this.wm.addWatch(username, rep, path);
        Watch w = this.wm.getWatch(username, rep, path);
        System.err.println("added " + w);
        this.resetWatchLastCheckedTimeTo(new DateTime(2001, 1, 1, 0, 0, 0, DateTimeZone.UTC), w);
        return w;
    }

    private void deleteWatch(String username, String rep, Path path) throws DbException {
        Watch watchToDelete = this.wm.getWatch(username, rep, path);
        while (watchToDelete != null) {
            System.err.println("deleting " + watchToDelete);
            this.wm.deleteWatch(watchToDelete.getId().longValue());
            watchToDelete = this.wm.getWatch(username, rep, path);
        }
    }
}

