/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dbtest;

import com.atlassian.fecru.page.Page;
import com.atlassian.fecru.page.PageRequest;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.user.UserSearchCriteria;
import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import com.cenqua.fisheye.web.filters.DummyHttpServletResponse;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class UserManagerTest
extends RepSanityTestBase {
    private static final String PASSWORD = "password";
    private static final String USERNAME = "username";
    private static final String uppercase = "username".toUpperCase(Locale.US);
    private static final String lowercase = "username".toLowerCase(Locale.US);
    private UserManager um;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.um = (UserManager)SpringContext.getComponentByClass(UserManager.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            if (this.um != null) {
                this.deleteUser(this.um, uppercase);
                this.deleteUser(this.um, lowercase);
                this.deleteUser(this.um, "NEW" + uppercase);
                this.deleteUser(this.um, "NEW" + lowercase);
            }
        }
        finally {
            HibernateUtil.closeSession();
            super.tearDown();
        }
    }

    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Test
    public void testTrailingSpaceUsernames() throws Exception {
        this.um.addUser("username    ", USERNAME, USERNAME, PASSWORD, false);
        FecruUser retrievedUser = this.um.getUser(USERNAME);
        Assert.assertNotNull((Object)retrievedUser);
        Assert.assertEquals((String)"retrieved username hasn't had trailing spaces removed", (Object)USERNAME, (Object)retrievedUser.getUsername());
    }

    @Test
    public void testCaseInsensitive() throws LicensePolicyException, DbException, IOException {
        this.userPermissionsTestRule.addFisheyeUser(uppercase, uppercase, uppercase);
        FecruUser retrievedUser = this.um.getLicensedUser(uppercase);
        Assert.assertNotNull((Object)retrievedUser);
        retrievedUser = this.um.getLicensedUser(lowercase);
        Assert.assertEquals((String)"retrieved username case not preserved", (Object)uppercase, (Object)retrievedUser.getUsername());
        UserLogin ul = this.um.login((HttpServletRequest)new MockHttpRequest(), (HttpServletResponse)new MockHttpResponse(), lowercase, uppercase, false);
        Assert.assertNotNull((Object)ul);
        Assert.assertEquals((String)"retrieved login name case is not preserved", (Object)uppercase, (Object)ul.getUsername());
        ul = this.um.login((HttpServletRequest)new MockHttpRequest(), (HttpServletResponse)new MockHttpResponse(), uppercase, uppercase, false);
        Assert.assertNotNull((Object)ul);
        Assert.assertEquals((String)"retrieved login name case is not preserved", (Object)uppercase, (Object)ul.getUsername());
        try {
            this.um.addUser(lowercase, lowercase, lowercase, PASSWORD, true);
            Assert.fail((String)"should not be able to add another user that differ in case only");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.um.renameUser(lowercase, uppercase);
            Assert.fail((String)"should not be able to rename a user with a username that differ in case only");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testgetUsersWithDisplayNamesContaining() throws Exception {
        String name = "prefix1name";
        try {
            FecruUser fecruUser = this.um.addUser("prefix1name", "test matching prefix3name", "prefix2@in.email", PASSWORD, true);
            this.assertUserFound(fecruUser, "prefix1");
            this.assertUserFound(fecruUser, "prefix2");
            this.assertUserFound(fecruUser, "prefix3");
            this.assertUserFound(fecruUser, "matching");
            ImmutableList match = ImmutableList.copyOf((Iterable)this.um.searchUsers(UserSearchCriteria.create().named("UserManagerTest"), PageRequest.createDefault()).getValues());
            Assert.assertEquals((long)0L, (long)match.size());
        }
        finally {
            try {
                this.um.deleteUserFully("prefix1name");
            }
            catch (DbException e) {
                Logs.APP_LOG.error((Object)"Error while deleting the user prefix1name", (Throwable)e);
            }
        }
    }

    private void assertUserFound(FecruUser user, String prefix) {
        Page match = this.um.searchUsers(UserSearchCriteria.create().named(prefix), PageRequest.createDefault());
        Assert.assertEquals((long)1L, (long)match.getSize());
        FecruUser foundUser = (FecruUser)match.getValues().iterator().next();
        Assert.assertEquals((Object)foundUser, (Object)user);
    }

    private void deleteUser(UserManager userManager, String username) {
        FecruUser user = userManager.getUser(username);
        if (user != null) {
            this.um.deleteUserFully(username);
        }
    }

    private class MockHttpResponse
    extends DummyHttpServletResponse {
        private MockHttpResponse() {
        }
    }

    private class MockHttpRequest
    extends DummyHttpServletRequest {
        private MockHttpRequest() {
        }

        @Override
        public String getContextPath() {
            return "/";
        }

        @Override
        public HttpSession getSession(boolean b) {
            return new HttpSession(){

                public long getCreationTime() {
                    return 0L;
                }

                public String getId() {
                    return null;
                }

                public long getLastAccessedTime() {
                    return 0L;
                }

                public ServletContext getServletContext() {
                    return null;
                }

                public void setMaxInactiveInterval(int i) {
                }

                public int getMaxInactiveInterval() {
                    return 0;
                }

                public HttpSessionContext getSessionContext() {
                    return null;
                }

                public Object getAttribute(String s) {
                    return null;
                }

                public Object getValue(String s) {
                    return null;
                }

                public Enumeration getAttributeNames() {
                    return null;
                }

                public String[] getValueNames() {
                    return new String[0];
                }

                public void setAttribute(String s, Object o) {
                }

                public void putValue(String s, Object o) {
                }

                public void removeAttribute(String s) {
                }

                public void removeValue(String s) {
                }

                public void invalidate() {
                }

                public boolean isNew() {
                    return false;
                }
            };
        }
    }
}

