/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dbtest;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.cvsrep.FisheyeSanityTestBase;
import com.cenqua.fisheye.model.CommitterDisplayDetails;
import com.cenqua.fisheye.model.CommitterUserMapping;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.util.RepositoryUtil;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class UserCommitterMappingTest
extends FisheyeSanityTestBase {
    private UserManager um;
    private CommitterUserMappingManager manager;
    private RepositoryManager repositoryManager;

    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            FecruUser user = this.um.getLicensedUser("a");
            if (user != null) {
                this.um.deleteUserFully("a");
            }
        }
        finally {
            HibernateUtil.closeSession();
            super.tearDown();
            UserCommitterMappingTest.fisheyeTearDown();
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        UserCommitterMappingTest.fisheyeSetUp();
        super.setUp();
        this.um = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        this.manager = (CommitterUserMappingManager)SpringContext.getComponent(CommitterUserMappingManager.class, (String)"committerUserMappingManager");
        this.repositoryManager = (RepositoryManager)SpringContext.getComponentByClass(RepositoryManager.class);
    }

    @Test
    public void testMappingUserToCommitter() throws DbException, LicensePolicyException {
        Map<String, Map<String, String>> expected = this.addUsers();
        for (String user : this.um.getAllLicensedUsernames()) {
            Multimap hibMappings = this.manager.getExplicitCommittersForUser(user);
            Map<String, String> mappings = expected.get(user);
            for (Map.Entry<String, String> e : mappings.entrySet()) {
                Assert.assertTrue((String)e.getKey(), (boolean)hibMappings.containsKey((Object)e.getKey()));
                Assert.assertEquals((String)((String)hibMappings.get((Object)e.getKey()).iterator().next()), (String)e.getValue());
                hibMappings.removeAll((Object)e.getKey());
            }
            Assert.assertTrue((boolean)hibMappings.isEmpty());
        }
    }

    @Test
    public void testMappingCommitterToUser() throws DbException, LicensePolicyException {
        Map<String, Map<String, String>> expected = this.addUsers();
        System.out.println("expected: " + expected);
        System.out.println("manager.findAll(): " + this.manager.findAll());
        for (CommitterUserMapping mapping : this.manager.findAll()) {
            System.out.println("Mapping " + mapping);
            Assert.assertEquals((String)mapping.getCommitterName(), (String)expected.get(mapping.getUserName()).remove(mapping.getRepositoryName()));
            if (expected.get(mapping.getUserName()).size() != 0) continue;
            expected.remove(mapping.getUserName());
        }
        Assert.assertTrue((String)("Should be empty: " + expected), (boolean)expected.isEmpty());
    }

    @Test
    public void testDeletingMapping() throws DbException, LicensePolicyException {
        this.addUsers();
        Assert.assertNotNull((Object)this.manager.getUserForCommitter("cvs", "aa"));
        this.manager.delete("a", "cvs", "aa");
        Assert.assertNull((Object)this.manager.getUserForCommitter("cvs", "aa"));
    }

    @Test
    public void testDeletingMappingForUser() throws LicensePolicyException, DbException {
        this.addUsers();
        Assert.assertFalse((boolean)this.manager.getExplicitCommittersForUser("a").isEmpty());
        Assert.assertTrue((boolean)this.manager.deleteAllForUser("a"));
        Assert.assertTrue((boolean)this.manager.getExplicitCommittersForUser("a").isEmpty());
        Assert.assertFalse((boolean)this.manager.getExplicitCommittersForUser("b").isEmpty());
        Assert.assertFalse((boolean)this.manager.getExplicitCommittersForUser("c").isEmpty());
    }

    @Test
    public void testUpdateMapping() throws LicensePolicyException, DbException {
        this.addUsers();
        Assert.assertNotNull((Object)this.manager.getUserForCommitter("cvs", "aa"));
        CommitterUserMapping oldMapping = new CommitterUserMapping("a", "cvs", "aa");
        CommitterUserMapping newMapping = new CommitterUserMapping("zebra", "cvs2", "zz");
        this.manager.updateMapping(oldMapping, newMapping);
        Assert.assertNull((Object)this.manager.getUserForCommitter("cvs", "aa"));
        this.userPermissionsTestRule.addFisheyeUser("zebra", "zebra", "zebra");
        Assert.assertNotNull((Object)this.manager.getUserForCommitter("cvs2", "zz"));
        Assert.assertEquals((String)"zebra", (String)this.manager.getUserForCommitter("cvs2", "zz").getUsername());
    }

    private Map<String, Map<String, String>> addUsers() throws DbException, LicensePolicyException {
        HashMap<String, Map<String, String>> added = new HashMap<String, Map<String, String>>();
        for (String user : this.um.getAllLicensedUsernames()) {
            this.um.deleteUserFully(user);
        }
        for (CommitterUserMapping mapping : this.manager.findAll()) {
            this.manager.delete(mapping.getUserName(), mapping.getRepositoryName(), mapping.getCommitterName());
        }
        for (Iterator<Object> iterator : new String[]{"a", "b", "c"}) {
            HashMap<String, String> mappings = new HashMap<String, String>();
            added.put((String)((Object)iterator), (Map<String, String>)mappings);
            this.userPermissionsTestRule.addFisheyeUser((String)((Object)iterator), (String)((Object)iterator), (String)((Object)iterator));
            this.manager.addMapping(iterator, "RepA", "" + iterator + iterator);
            this.manager.addMapping(iterator, "cvs", "" + iterator + iterator);
            this.manager.addMapping(iterator, "cvs2", "" + iterator + iterator);
            mappings.put("RepA", "" + iterator + iterator);
            mappings.put("cvs", "" + iterator + iterator);
            mappings.put("cvs2", "" + iterator + iterator);
        }
        return added;
    }

    @Test
    public void testGetUserForCommitter() throws LicensePolicyException, DbException {
        this.addUsers();
        this.userPermissionsTestRule.addFisheyeUser("implicit", "I am implicit", "implicit");
        FecruUser obtained = this.manager.getUserForCommitter("rep", "implicit");
        Assert.assertNotNull((Object)obtained);
        Assert.assertTrue((boolean)obtained.getUsername().equals("implicit"));
        Assert.assertTrue((boolean)obtained.getDisplayName().equals("I am implicit"));
        obtained = this.manager.getUserForCommitter("cvs", "aa");
        Assert.assertNotNull((Object)obtained);
        Assert.assertTrue((boolean)obtained.getUsername().equals("a"));
        this.userPermissionsTestRule.addFisheyeUser("aa", "aa", "aa");
        obtained = this.manager.getUserForCommitter("cvs", "aa");
        Assert.assertNotNull((Object)obtained);
        Assert.assertTrue((boolean)obtained.getUsername().equals("a"));
        Assert.assertTrue((boolean)obtained.getDisplayName().equals("a"));
        this.um.deleteUserFully(obtained.getUsername());
    }

    @Test
    public void testUserListConstruction() throws Exception {
        this.userPermissionsTestRule.addFisheyeUser("blah", "Bald Balh", "blah");
        this.userPermissionsTestRule.addFisheyeUser("tony", "Toe Knee", "tony");
        this.userPermissionsTestRule.addFisheyeUser("bonnie", "Bonnie McFishFace", "bonnie");
        List committers = RepositoryUtil.getCommittersInRep((RepositoryHandle)this.repositoryManager.getRepository("cvs"));
        this.manager.addMapping("bonnie", "cvs", (String)committers.get(0));
        this.manager.addMapping("bonnie", "cvs", (String)committers.get(1));
        this.manager.addMapping("tony", "cvs", (String)committers.get(2));
        List list = this.manager.constructUserListFromCommitters("cvs", committers);
        CommitterDisplayDetails expected = new CommitterDisplayDetails("Bonnie McFishFace", (String)committers.get(0));
        Assert.assertTrue((boolean)list.contains(expected));
        expected = new CommitterDisplayDetails("Bonnie McFishFace", (String)committers.get(1));
        Assert.assertTrue((boolean)list.contains(expected));
        expected = new CommitterDisplayDetails("Toe Knee", (String)committers.get(2));
        Assert.assertTrue((boolean)list.contains(expected));
        expected = new CommitterDisplayDetails("Bald Balh", "blah");
        Assert.assertTrue((boolean)list.contains(expected));
        expected = new CommitterDisplayDetails((String)committers.get(4), (String)committers.get(4));
        Assert.assertTrue((boolean)list.contains(expected));
        this.um.deleteUserFully("tony");
        this.um.deleteUserFully("blah");
        this.um.deleteUserFully("bonnie");
    }

    @Test
    public void testGetCommittersForUserInRep() throws LicensePolicyException, DbException {
        List committers = RepositoryUtil.getCommittersInRep((RepositoryHandle)this.repositoryManager.getRepository("cvs"));
        String committer1 = (String)committers.get(0);
        String committer2 = (String)committers.get(1);
        FecruUser user = new FecruUser(committer1);
        this.userPermissionsTestRule.addFisheyeUser(committer1, committer1, committer1);
        this.manager.addMapping(committer1, "cvs", committer2);
        List implicitCommitters = this.manager.getImplicitCommittersForUserInRep("cvs", user);
        List explicitCommitters = this.manager.getExplicitCommittersForUserInRep("cvs", user.getUsername());
        Assert.assertFalse((boolean)explicitCommitters.contains(committer1));
        Assert.assertTrue((boolean)explicitCommitters.contains(committer2));
        Assert.assertTrue((boolean)implicitCommitters.contains(committer1));
        Assert.assertFalse((boolean)implicitCommitters.contains(committer2));
    }
}

