/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dbtest;

import com.atlassian.crucible.filters.CrucibleFilter;
import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.stars.StarManager;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.ChangesetStar;
import com.atlassian.fisheye.stars.model.ChartStar;
import com.atlassian.fisheye.stars.model.CommentStar;
import com.atlassian.fisheye.stars.model.CommitterStar;
import com.atlassian.fisheye.stars.model.DiffStar;
import com.atlassian.fisheye.stars.model.FileStar;
import com.atlassian.fisheye.stars.model.ProjectStar;
import com.atlassian.fisheye.stars.model.QuickSearchStar;
import com.atlassian.fisheye.stars.model.RepositoryStar;
import com.atlassian.fisheye.stars.model.ReviewStar;
import com.atlassian.fisheye.stars.model.RevisionStar;
import com.atlassian.fisheye.stars.model.Star;
import com.atlassian.fisheye.stars.model.StarKey;
import com.atlassian.fisheye.stars.model.UserStar;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.hibernate.HibernateUtilCurrentSessionProvider;
import com.cenqua.crucible.model.Principal;
import com.cenqua.crucible.model.managers.PermissionManager;
import com.cenqua.crucible.model.managers.PermissionManagerTestUtil;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.filters.DummyHttpServletRequest;
import javax.servlet.ServletRequest;
import junit.framework.TestCase;

public class StarValidationTestBase
extends TestCase {
    public static final String USERNAME = "starman";
    private StarManager universe;
    protected UserLogin currentUser;
    protected UserManager um;
    protected GroupMembershipManager groupMembershipManager;
    protected String rep;
    protected FecruUser currentCrucibleUser;
    protected ReviewManager reviewManager;
    protected EffectiveUserProviderImpl effectiveUserProvider;

    public void setUp() throws Exception {
        TestFishEyeInstances.checkCleanStart();
        TestFishEyeInstances.deleteData0();
        Disposer.pushThreadInstance();
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        this.um = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        this.rep = handle.getName();
        if (this.um.getUser(USERNAME) == null) {
            this.um.addUser(USERNAME, USERNAME, USERNAME, USERNAME, true);
        }
        this.groupMembershipManager = (GroupMembershipManager)SpringContext.getComponentByClass(GroupMembershipManager.class);
        this.currentCrucibleUser = ModelUtils.makeAndSaveUser(USERNAME);
        this.currentUser = this.createTrustedUserLogin(USERNAME);
        this.effectiveUserProvider = (EffectiveUserProviderImpl)SpringContext.getComponent(EffectiveUserProviderImpl.class, (String)"effectiveUserProvider");
        this.effectiveUserProvider.pushEffectivePrincipal((Principal)this.currentUser, this.currentCrucibleUser);
        CrucibleFilter.setContext((CrucibleFilter.Context)new CrucibleFilter.Context((ServletRequest)new DummyHttpServletRequest(), null));
        this.universe = (StarManager)SpringContext.getComponentByClass(StarManager.class);
        this.reviewManager = (ReviewManager)SpringContext.getComponentByClass(ReviewManager.class);
        HibernateUtil.beginTransaction();
        PermissionManagerTestUtil.checkAndCreateDefaultPS((CurrentSessionProvider)new HibernateUtilCurrentSessionProvider(), (PermissionManager)SpringContext.getComponentByClass(PermissionManager.class));
        HibernateUtil.commitTransaction();
    }

    protected void tearDown() throws Exception {
        HibernateUtil.forceRollbackTransaction();
        HibernateUtil.closeSession();
        this.effectiveUserProvider.popEffectivePrincipal();
        Disposer.popThreadInstance();
        TestFishEyeInstances.stop();
        TestFishEyeInstances.checkCleanStart();
        CrucibleFilter.setContext(null);
    }

    protected void testStar(StarKey key, boolean exists) throws Exception {
        HibernateUtil.beginTransaction();
        Star star = this.constructStarSansFactory(key);
        HibernateUtil.currentSession().save((Object)star);
        HibernateUtil.commitTransaction();
        if (exists) {
            StarValidationTestBase.assertTrue((String)"Existential star did not exist", (boolean)star.targetExists());
            StarValidationTestBase.assertTrue((String)"User did not have existing star", (boolean)this.universe.getStarsForUser(this.currentUser.getUserName()).contains(star));
        } else {
            StarValidationTestBase.assertFalse((String)"Star that should not exist defies reality", (boolean)star.targetExists());
            StarValidationTestBase.assertFalse((String)"User did have non-existing star", (boolean)this.universe.getStarsForUser(this.currentUser.getUserName()).contains(star));
        }
        HibernateUtil.beginTransaction();
        this.universe.removeStar(star.getId().intValue());
        HibernateUtil.commitTransaction();
    }

    protected StarKey createIntStarKey(StarType type, int intKey1) {
        StarKey key = new StarKey(type.getName());
        key.setIntKey1(Integer.valueOf(intKey1));
        return key;
    }

    protected StarKey createTwoStringStarKey(StarType type, String stringKey1, String stringKey2) {
        StarKey key = new StarKey(type.getName());
        key.setStringKey1(stringKey1);
        key.setStringKey2(stringKey2);
        return key;
    }

    protected StarKey createThreeStringStarKey(StarType type, String s1, String s2, String s3) {
        StarKey key = this.createTwoStringStarKey(type, s1, s2);
        key.setStringKey3(s3);
        return key;
    }

    protected StarKey createFiveStringStarKey(StarType type, String s1, String s2, String s3, String s4, String s5) {
        StarKey key = this.createThreeStringStarKey(type, s1, s2, s3);
        key.setStringKey4(s4);
        key.setStringKey5(s5);
        return key;
    }

    protected UserLogin createTrustedUserLogin(String username) throws DbException, LicensePolicyException {
        UserLogin ul = this.um.createTrustedUserLogin(username);
        return ul;
    }

    private Star constructStarSansFactory(StarKey s) throws Exception {
        StarType type = StarType.getById((String)s.getItemType());
        switch (type) {
            case CHANGESET: {
                return new ChangesetStar(s, this.currentUser.getUserName());
            }
            case COMMITTER: {
                return new CommitterStar(s, this.currentUser.getUserName());
            }
            case CHART: {
                return new ChartStar(s, this.currentUser.getUserName());
            }
            case DIFF: {
                return new DiffStar(s, this.currentUser.getUserName());
            }
            case FILE: {
                return new FileStar(s, this.currentUser.getUserName());
            }
            case QUICKSEARCH: {
                return new QuickSearchStar(s, this.currentUser.getUserName());
            }
            case REPOSITORY: {
                return new RepositoryStar(s, this.currentUser.getUserName());
            }
            case REVISION: {
                return new RevisionStar(s, this.currentUser.getUserName());
            }
            case USER: {
                return new UserStar(s, this.currentUser.getUsername());
            }
            case PROJECT: {
                return new ProjectStar(s, this.currentUser.getUsername());
            }
            case REVIEW: {
                return new ReviewStar(s, this.currentUser.getUsername());
            }
            case COMMENT: {
                return new CommentStar(s, this.currentUser.getUsername());
            }
        }
        throw new Exception("Star not created due to bad star type");
    }
}

