/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dbtest;

import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.template.DefaultTemplateManager;
import com.atlassian.fecru.template.TemplateManager;
import com.atlassian.fecru.user.FecruUser;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.mail.Mailer;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.MailEnabledTestBase;
import com.cenqua.fisheye.web.login.PasswordResetAction;
import com.cenqua.fisheye.web.login.RequestPasswordResetAction;
import javax.mail.Address;
import javax.mail.internet.MimeMessage;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class PasswordResetMailTest
extends MailEnabledTestBase {
    private UserRepositoryPropertyManager userRepositoryPropertyManager;

    private String subtestVerificationEmailContent(final String mailContentType) throws Exception {
        RequestPasswordResetAction action = new RequestPasswordResetAction(){

            protected String generateSecureRnd() {
                return "CAFEBABE";
            }

            protected String resolvePreferredMailFormat(FecruUser user) throws DbException {
                return mailContentType;
            }

            public void validateCaptcha() {
            }

            protected void assignCaptchaId() {
            }

            protected UserManager getUserManager() {
                return PasswordResetMailTest.this.um;
            }
        };
        action.setTemplateManager((TemplateManager)new DefaultTemplateManager());
        action.setMailer(new Mailer(AppConfig.getsConfig()));
        action.setUsernameOrEmail("watchmanagertest");
        action.doDefault();
        action.validate();
        Assert.assertEquals((String)"success", (String)action.execute());
        Assert.assertTrue((boolean)this.greenmail.waitForIncomingEmail(5000L, 1));
        MimeMessage message = this.greenmail.getReceivedMessages()[0];
        String content = String.valueOf(message.getContent());
        this.assertSubstring("Hi watchmanagertest,", content);
        this.assertSubstring("Somebody (possibly you) has requested that your password for watchmanagertest be reset", content);
        this.assertSubstring("/login/resetPassword.do?usernameOrEmail=watchmanagertest@lowercase.com&code=CAFEBABE", content);
        Address[] recipients = message.getAllRecipients();
        Assert.assertEquals((int)1, (int)recipients.length);
        Assert.assertEquals((String)"watchmanagertest@lowercase.com", (String)recipients[0].toString());
        Assert.assertEquals((String)(AppConfig.getProductName() + " Password Reset"), (String)message.getSubject());
        return content;
    }

    private String subtestPasswordEmailContent(final String mailContentType) throws Exception {
        PasswordResetAction action = new PasswordResetAction(){
            {
                this.setUserManager(PasswordResetMailTest.this.um);
                this.setUserRepositoryPropertyManager(PasswordResetMailTest.this.userRepositoryPropertyManager);
            }

            protected String resolvePreferredMailFormat(FecruUser user) throws DbException {
                return mailContentType;
            }

            protected String generateNewPassword() {
                return "SECRET";
            }

            protected UserManager getUserManager() {
                return PasswordResetMailTest.this.um;
            }
        };
        action.setTemplateManager((TemplateManager)new DefaultTemplateManager());
        action.setMailer(new Mailer(AppConfig.getsConfig()));
        action.setUsernameOrEmail("watchmanagertest@lowercase.com");
        action.setCode("CAFEBABE");
        action.validate();
        Assert.assertEquals((String)"success", (String)action.execute());
        Assert.assertTrue((boolean)this.greenmail.waitForIncomingEmail(5000L, 1));
        MimeMessage message = this.greenmail.getReceivedMessages()[0];
        String content = String.valueOf(message.getContent());
        this.assertSubstring("Hi watchmanagertest,", content);
        this.assertSubstring("You may use this to log in at ", content);
        this.assertSubstring("If you did not request a new password, please notify your System Administrator of this email immediately.", content);
        Address[] recipients = message.getAllRecipients();
        Assert.assertEquals((int)1, (int)recipients.length);
        Assert.assertEquals((String)"watchmanagertest@lowercase.com", (String)recipients[0].toString());
        Assert.assertEquals((String)"New FishEye Password", (String)message.getSubject());
        return content;
    }

    @Test
    public void testPlainVerificationEmailContent() throws Exception {
        String content = this.subtestVerificationEmailContent("text/plain; charset=UTF-8");
        this.assertNotSubstring("<html>", content);
        this.assertNotSubstring("<body>", content);
    }

    @Test
    public void testHtmlVerificationEmailContent() throws Exception {
        String content = this.subtestVerificationEmailContent("text/html; charset=UTF-8");
        this.assertSubstring("<html>", content);
        this.assertSubstring("<body>", content);
    }

    @Test
    public void testPlainNewPasswordEmailContent() throws Exception {
        String content = this.subtestPasswordEmailContent("text/plain; charset=UTF-8");
        this.assertNotSubstring("<html>", content);
        this.assertSubstring("password is: SECRET", content);
        this.assertNotSubstring("password is: <strong>SECRET</strong>", content);
    }

    @Test
    public void testHtmlNewPasswordEmailContent() throws Exception {
        String content = this.subtestPasswordEmailContent("text/html; charset=UTF-8");
        this.assertSubstring("<html>", content);
        this.assertNotSubstring("password is: SECRET", content);
        this.assertSubstring("password is: <strong>SECRET</strong>", content);
    }

    private void assertSubstring(String substring, String superstring) {
        String errmsg = "cannot find substring '" + substring + "' : superstring is '" + superstring + "'";
        Assert.assertTrue((String)errmsg, (boolean)superstring.contains(substring));
    }

    private void assertNotSubstring(String substring, String superstring) {
        String errmsg = "found unexpected substring '" + substring + "' : superstring is '" + superstring + "'";
        Assert.assertTrue((String)errmsg, (!superstring.contains(substring) ? 1 : 0) != 0);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deleteEmail();
        this.userRepositoryPropertyManager = (UserRepositoryPropertyManager)SpringContext.getComponentByClass(UserRepositoryPropertyManager.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            this.deleteEmail();
        }
        finally {
            super.tearDown();
        }
    }
}

