/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dbtest;

import com.atlassian.fisheye.dbtest.StarValidationTestBase;
import com.atlassian.fisheye.stars.StarType;
import com.atlassian.fisheye.stars.model.StarKey;

public class FishEyeStarValidationTest
extends StarValidationTestBase {
    public void testChangesetStarValidation() throws Exception {
        String validCsid = "BRANCH_2_2:matt:20050517064053";
        String invalidCsid = "monkeys";
        StarKey starKey = this.createTwoStringStarKey(StarType.CHANGESET, this.rep, validCsid);
        this.testStar(starKey, true);
        StarKey invalidStarKey = this.createTwoStringStarKey(StarType.CHANGESET, this.rep, invalidCsid);
        this.testStar(invalidStarKey, false);
    }

    public void testCommitterStarValidation() throws Exception {
        String validCommitter = "matt";
        String invalidCommitter = "zebra";
        StarKey valid = this.createTwoStringStarKey(StarType.COMMITTER, this.rep, validCommitter);
        StarKey invalid = this.createTwoStringStarKey(StarType.COMMITTER, this.rep, invalidCommitter);
        this.testStar(valid, true);
        this.testStar(invalid, false);
    }

    public void testChartStarValidation() throws Exception {
        String validFilePath = "/test/branching/c.txt";
        String invalidFilePath = "/test/foo/z.java";
        String validDirPath = "/";
        String invalidDirPath = "/fadlkaj/p";
        String wb = "~charttype=Area,stacktype=Author";
        StarKey validFile = this.createThreeStringStarKey(StarType.CHART, validFilePath, this.rep, wb);
        StarKey invalidFile = this.createThreeStringStarKey(StarType.CHART, invalidFilePath, this.rep, wb);
        StarKey validDir = this.createThreeStringStarKey(StarType.CHART, validDirPath, this.rep, wb);
        StarKey invalidDir = this.createThreeStringStarKey(StarType.CHART, invalidDirPath, this.rep, wb);
        this.testStar(validFile, true);
        this.testStar(invalidFile, false);
        this.testStar(validDir, true);
        this.testStar(invalidDir, false);
    }

    public void testDiffStarValidation() throws Exception {
        String validToRev = "1.9.6.2";
        String validFromRev = "1.9";
        String invalidToRev = "1.10";
        String invalidFromRev = "0.5";
        String validToPath = "/test/CleanSweeper.java";
        String invalidToPath = "/a/f";
        String validFromPath = "/test/CleanSweeper.java";
        String invalidFromPath = "d/b";
        StarKey valid = this.createFiveStringStarKey(StarType.DIFF, validFromPath, validFromRev, validToPath, validToRev, this.rep);
        StarKey invalid1 = this.createFiveStringStarKey(StarType.DIFF, invalidFromPath, validToRev, validToPath, validToRev, this.rep);
        StarKey invalid2 = this.createFiveStringStarKey(StarType.DIFF, validFromPath, invalidToRev, validToPath, validToRev, this.rep);
        StarKey invalid3 = this.createFiveStringStarKey(StarType.DIFF, validFromPath, validFromRev, invalidToPath, validToRev, this.rep);
        StarKey invalid4 = this.createFiveStringStarKey(StarType.DIFF, validFromPath, validFromRev, validToPath, invalidToRev, this.rep);
        StarKey invalid5 = this.createFiveStringStarKey(StarType.DIFF, invalidFromPath, validFromRev, validToPath, invalidToRev, this.rep);
        StarKey invalid6 = this.createFiveStringStarKey(StarType.DIFF, invalidFromPath, invalidFromRev, invalidToPath, invalidToRev, this.rep);
        this.testStar(valid, true);
        this.testStar(invalid1, false);
        this.testStar(invalid2, false);
        this.testStar(invalid3, false);
        this.testStar(invalid4, false);
        this.testStar(invalid5, false);
        this.testStar(invalid6, false);
    }

    public void testFileStarValidation() throws Exception {
        String invalidFilePath = "/bah/baa";
        String validFilePath = "/test/CleanSweeper.java";
        StarKey valid = this.createTwoStringStarKey(StarType.FILE, validFilePath, this.rep);
        StarKey invalid = this.createTwoStringStarKey(StarType.FILE, invalidFilePath, this.rep);
        this.testStar(valid, true);
        this.testStar(invalid, false);
    }

    public void testQuickSearchStarValidation() throws Exception {
        String invalidRep = "lion";
        String text = "test";
        StarKey valid = this.createTwoStringStarKey(StarType.QUICKSEARCH, this.rep, text);
        StarKey invalid = this.createTwoStringStarKey(StarType.QUICKSEARCH, invalidRep, text);
        StarKey all = this.createTwoStringStarKey(StarType.QUICKSEARCH, "__ALL_REPOS__", "bah");
        this.testStar(valid, true);
        this.testStar(all, true);
        this.testStar(invalid, false);
    }

    public void testRepositoryStarValidation() throws Exception {
        String invalidRep = "insanity1";
        StarKey valid = this.createTwoStringStarKey(StarType.REPOSITORY, this.rep, "");
        StarKey invalid = this.createTwoStringStarKey(StarType.REPOSITORY, invalidRep, "");
        this.testStar(valid, true);
        this.testStar(invalid, false);
    }

    public void testUserStarValidation() throws Exception {
        String invalidUser = "donkey";
        StarKey valid = this.createTwoStringStarKey(StarType.USER, "starman", "");
        StarKey invalid = this.createTwoStringStarKey(StarType.USER, invalidUser, "");
        this.testStar(valid, true);
        this.testStar(invalid, false);
    }

    public void testRevisionStarValidation() throws Exception {
        String invalidRevPath = "invalid";
        String invalidRev = "0.09";
        String validRevPath = "/test/CleanSweeper.java";
        String validRev = "1.5";
        StarKey valid = this.createThreeStringStarKey(StarType.REVISION, validRevPath, validRev, this.rep);
        StarKey invalid1 = this.createThreeStringStarKey(StarType.REVISION, invalidRevPath, validRev, this.rep);
        StarKey invalid2 = this.createThreeStringStarKey(StarType.REVISION, validRevPath, invalidRev, this.rep);
        StarKey invalid3 = this.createThreeStringStarKey(StarType.REVISION, invalidRevPath, invalidRev, this.rep);
        StarKey invalid4 = this.createThreeStringStarKey(StarType.REVISION, validRevPath, validRev, "insanity");
        this.testStar(valid, true);
        this.testStar(invalid1, false);
        this.testStar(invalid2, false);
        this.testStar(invalid3, false);
        this.testStar(invalid4, false);
    }
}

