/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dbtest;

import com.atlassian.fecru.user.UserPermissionsTestRule;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.cvsrep.RepSanityTestBase;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.user.DefaultAdminUserConfig;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class AdminGroupUserTest
extends RepSanityTestBase {
    private RootConfig config;
    private UserManager um;
    private GroupMembershipManager groupMembershipManager;
    private DefaultAdminUserConfig aum;
    private final Set<String> umUsersToRemoveAfterTest = new HashSet<String>();
    private final Set<String> umGroupsToRemoveAfterTest = new HashSet<String>();
    private final Set<String> aumUsersToRemoveAfterTest = new HashSet<String>();
    private final Set<String> aumGroupsToRemoveAfterTest = new HashSet<String>();
    private UserPermissionsTestRule userPermissionsTestRule;
    private static final String ANNA = "anna";
    private static final String MATT = "matt";
    private static final String GROUP = "admingroup";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.config = AppConfig.getsConfig();
        this.um = (UserManager)SpringContext.getComponentByClass(UserManager.class);
        this.aum = (DefaultAdminUserConfig)SpringContext.getComponentByClass(DefaultAdminUserConfig.class);
        this.groupMembershipManager = (GroupMembershipManager)SpringContext.getComponentByClass(GroupMembershipManager.class);
        this.userPermissionsTestRule = (UserPermissionsTestRule)((Object)SpringContext.createComponent(UserPermissionsTestRule.class));
        this.umUsersToRemoveAfterTest.clear();
        this.umGroupsToRemoveAfterTest.clear();
        this.aumUsersToRemoveAfterTest.clear();
        this.aumGroupsToRemoveAfterTest.clear();
    }

    @Override
    protected RepositoryHandle whichHandle() throws Exception {
        return TestFishEyeInstances.getSanity1Repos();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        try {
            for (String user : this.umUsersToRemoveAfterTest) {
                this.um.deleteUserFully(user);
            }
            for (String group : this.umGroupsToRemoveAfterTest) {
                this.um.deleteGroup(group);
            }
            for (String user : this.aumUsersToRemoveAfterTest) {
                this.aum.removeUser(user);
            }
            for (String group : this.aumGroupsToRemoveAfterTest) {
                this.aum.removeGroup(group);
            }
        }
        finally {
            HibernateUtil.closeSession();
            super.tearDown();
        }
    }

    private void addUserIfNotExists(String userName) throws LicensePolicyException {
        this.userPermissionsTestRule.addFisheyeUser(userName);
        this.umUsersToRemoveAfterTest.add(userName);
    }

    private void addGroupIfNotExists(String groupName) {
        if (!this.um.groupExists(groupName)) {
            this.um.addGroup(groupName);
            this.umGroupsToRemoveAfterTest.add(groupName);
        }
    }

    private void continueSetup() throws IOException, DbException, ConfigException, LicensePolicyException {
        this.addUserIfNotExists(MATT);
        this.addUserIfNotExists(ANNA);
        this.addGroupIfNotExists(GROUP);
        AppConfig.getsConfig().saveConfig();
    }

    @Test
    public void testAddingAdminUser() throws IOException, ConfigException, DbException, LicensePolicyException {
        this.continueSetup();
        Assert.assertFalse((String)"Anna shouldn't have sys admin privileges prior to the test", (boolean)this.aum.toString().contains("Anna"));
        Assert.assertFalse((String)"adminGroup shouldn't be a system admin group prior to the test", (boolean)this.aum.toString().contains("adminGroup"));
        Assert.assertFalse((String)"Anna shouldn't have sys admin privileges prior to the test", (boolean)this.um.hasSysAdminPrivileges(ANNA));
        Assert.assertFalse((String)"Matt shouldn't have sys admin privileges prior to the test", (boolean)this.um.hasSysAdminPrivileges(MATT));
        this.config.getConfig().getSecurity().addNewAdmins();
        this.aum.addUser(ANNA);
        this.aum.addGroup(GROUP);
        AppConfig.getsConfig().saveConfig();
        Assert.assertTrue((String)"Anna should have sys admin privileges now", (boolean)this.aum.getUserSet().contains(ANNA));
        Assert.assertTrue((String)"adminGroup should be a system admin group now", (boolean)this.aum.isAdminGroup("adminGroup"));
        this.groupMembershipManager.removeUserFromGroup(GROUP, MATT);
        Assert.assertTrue((String)"Anna should still have sys admin privileges", (boolean)this.um.hasSysAdminPrivileges(ANNA));
        Assert.assertFalse((String)"matt shouldn't yet have sys admin privileges", (boolean)this.um.hasSysAdminPrivileges(MATT));
        this.groupMembershipManager.addUserToGroup(GROUP, MATT);
        Assert.assertTrue((String)"matt should gain sys admin privileges after becoming admin group member", (boolean)this.um.hasSysAdminPrivileges(MATT));
    }

    @Test
    public void testAddTwice() throws IOException {
        this.aum.addUser("user1");
        this.aum.addUser("user1");
        this.aumUsersToRemoveAfterTest.add("user1");
        this.aum.addGroup("group1");
        this.aum.addGroup("group1");
        this.aumGroupsToRemoveAfterTest.add("group1");
        AppConfig.getsConfig().saveConfig();
        Assert.assertEquals((String)this.aum.toString(), (String)"System admins: users [user1], groups [group1]");
    }
}

