/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.db;

import com.atlassian.fisheye.db.PersistentStringSet;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.infinitydb.EntityClass;
import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PersistentStringSetTest {
    private File dbFile;
    private InfinityDbHandle dbHandle;
    private PersistentStringSet set;

    @Before
    public void createInfDb() throws Exception {
        this.dbFile = File.createTempFile("persistent-string-set", ".db");
        if (this.dbFile.exists()) {
            this.dbFile.delete();
        }
        this.dbHandle = new InfinityDbHandle(this.dbFile);
        this.set = new PersistentStringSet(this.dbHandle, new EntityClass(100L));
    }

    @After
    public void deleteDb() throws Exception {
        if (this.dbFile.exists()) {
            this.dbHandle.close();
            if (!this.dbFile.delete()) {
                this.dbFile.deleteOnExit();
            }
        }
    }

    @Test
    public void testBasicUsage() throws Exception {
        this.set.add("value1");
        this.set.add("value2");
        Assert.assertEquals((long)2L, (long)this.set.size());
        Assert.assertFalse((boolean)this.set.isEmpty());
        Assert.assertTrue((boolean)this.set.contains((Object)"value1"));
        Assert.assertTrue((boolean)this.set.contains((Object)"value2"));
        Assert.assertFalse((boolean)this.set.contains((Object)"value3"));
        this.set.clear();
        Assert.assertEquals((long)0L, (long)this.set.size());
        Assert.assertTrue((boolean)this.set.isEmpty());
    }

    @Test
    public void testCloseReOpen() throws Exception {
        this.set.add("value1");
        this.set.add("value2");
        this.set = new PersistentStringSet(this.dbHandle, new EntityClass(100L));
        Assert.assertEquals((long)2L, (long)this.set.size());
        Assert.assertFalse((boolean)this.set.isEmpty());
        Assert.assertTrue((boolean)this.set.contains((Object)"value1"));
        Assert.assertTrue((boolean)this.set.contains((Object)"value2"));
        Assert.assertFalse((boolean)this.set.contains((Object)"value3"));
    }

    @Test
    public void testRemove() throws Exception {
        this.set.add("foo");
        this.set.add("bar");
        this.set.remove((Object)"bar");
        this.set.remove((Object)"baz");
        Assert.assertThat((Object)this.set, (Matcher)Matchers.contains((Object[])new String[]{"foo"}));
    }
}

