/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.db;

import com.atlassian.fisheye.db.CommonBranchDAO;
import com.atlassian.fugue.Option;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommonBranchDAOTest {
    private File dbFile;
    private InfinityDbHandle dbHandle;
    private CommonBranchDAO branchDAO;

    @Before
    public void setup() throws IOException {
        this.dbFile = File.createTempFile("branchdaotest", ".db");
        if (this.dbFile.exists()) {
            this.dbFile.delete();
        }
        this.dbHandle = new InfinityDbHandle(this.dbFile);
        CommonStringTables stringTables = new CommonStringTables((UniqueStringTableFactory)this.dbHandle);
        this.branchDAO = new CommonBranchDAO(this.dbHandle, stringTables);
    }

    @After
    public void teardown() {
        if (!this.dbFile.delete()) {
            this.dbFile.deleteOnExit();
        }
        this.branchDAO = null;
    }

    public void assertBranchEqualsButNotSame(Branch expected, Branch actual) {
        Assert.assertNotSame((Object)expected, (Object)actual);
        Assert.assertEquals((Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((Object)expected.getState(), (Object)actual.getState());
        Assert.assertEquals((Object)expected.getLatestChangeSetId(), (Object)actual.getLatestChangeSetId());
        Assert.assertEquals((Object)expected.getLatestMarkedChangesetId(), (Object)actual.getLatestMarkedChangesetId());
    }

    @Test
    public void testStoreAndLoad() throws DbException {
        Branch branch = new Branch("branch-name", "head-1", BranchState.CLOSED);
        branch.setLatestMarkedChangesetId(Option.some((Object)"head-0"));
        this.branchDAO.store(branch, true);
        Branch retrieved = this.branchDAO.load("branch-name");
        this.assertBranchEqualsButNotSame(branch, retrieved);
    }

    @Test
    public void testUpdate() throws DbException {
        Branch branch = new Branch("branch-name", "head", BranchState.CLOSED);
        this.branchDAO.store(branch, true);
        branch.setState(BranchState.INACTIVE);
        branch.setLatestMarkedChangesetId(Option.none());
        this.branchDAO.store(branch, true);
        Branch retrieved = this.branchDAO.load("branch-name");
        this.assertBranchEqualsButNotSame(branch, retrieved);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoreNull() throws DbException {
        this.branchDAO.store(null, true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadNull() throws DbException {
        this.branchDAO.load(null);
    }

    @Test
    public void testLoadNonExistent() throws DbException {
        Assert.assertNull((Object)this.branchDAO.load("blablabla"));
    }

    @Test
    public void testExists() throws DbException {
        Branch branch = new Branch("branch-name", "head", BranchState.CLOSED);
        this.branchDAO.store(branch, true);
        Assert.assertTrue((boolean)this.branchDAO.exists("branch-name"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExistsNull() throws DbException {
        this.branchDAO.exists(null);
    }

    @Test
    public void testExistsDoesNotExists() throws DbException {
        Assert.assertFalse((boolean)this.branchDAO.exists("does-not-exists"));
    }
}

