/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dag;

import com.atlassian.fisheye.dag.GraphIterator;
import com.atlassian.fisheye.dag.GraphUtils;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class GraphUtilsTest {
    private static final Map<String, List<String>> EXAMPLE_DAG = ImmutableMap.builder().put((Object)"a", (Object)ImmutableList.of((Object)"b", (Object)"e")).put((Object)"b", (Object)ImmutableList.of((Object)"c")).put((Object)"c", (Object)ImmutableList.of((Object)"d")).put((Object)"d", (Object)ImmutableList.of((Object)"g")).put((Object)"e", (Object)ImmutableList.of((Object)"d")).put((Object)"f", (Object)ImmutableList.of((Object)"e")).put((Object)"g", Collections.emptyList()).build();
    protected static final Function<String, Collection<String>> EXAMPLE_DAG_PROVIDER = EXAMPLE_DAG::get;
    private static final String EXPECTED_DFS_ORDER_WITH_DUPLICATES = "abcdgedgfedg";
    private static final String EXPECTED_BFS_ORDER_WITH_DUPLICATES = "afbeecdddggg";
    private static final String EXPECTED_DFS_ORDER_NO_DUPLICATES = "abcdgef";
    private static final String EXPECTED_BFS_ORDER_NO_DUPLICATES = "afbecdg";
    private static final String EXPECTED_BFS_ORDER_NO_DUPLICATES_PRUNED = "afedg";

    @Test
    public void testBreadthFirstNodeInserter() {
        LinkedList<String> expected = new LinkedList<String>(Arrays.asList("1", "2", "3", "4"));
        LinkedList<String> actual = new LinkedList<String>(Arrays.asList("1", "2"));
        GraphUtils.BreadthFirstNodeInserter inserter = new GraphUtils.BreadthFirstNodeInserter();
        inserter.insertNextNodes(actual, Arrays.asList("3", "4"));
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testDepthFirstNodeInserter() {
        LinkedList<String> expected = new LinkedList<String>(Arrays.asList("3", "4", "1", "2"));
        LinkedList<String> actual = new LinkedList<String>(Arrays.asList("1", "2"));
        GraphUtils.DepthFirstNodeInserter inserter = new GraphUtils.DepthFirstNodeInserter();
        inserter.insertNextNodes(actual, Arrays.asList("3", "4"));
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testFirstOccurrenceConsumer() {
        GraphUtils.PredicateMatcher searcher = new GraphUtils.PredicateMatcher(Predicates.equalTo((Object)"target"));
        Assert.assertTrue((boolean)searcher.apply((Object)"not-target"));
        Assert.assertTrue((boolean)searcher.apply(null));
        Assert.assertTrue((boolean)searcher.apply((Object)""));
        Assert.assertNull((Object)searcher.getResult());
        Assert.assertFalse((boolean)searcher.apply((Object)"target"));
        Assert.assertEquals((Object)"target", (Object)searcher.getResult());
    }

    @Test
    public void testIterateBreadthFirstSearchWithDuplicates() {
        StringBuilder walked = new StringBuilder();
        GraphIterator it = GraphUtils.iterateBreadthFirst(Arrays.asList("a", "f"), EXAMPLE_DAG_PROVIDER, null);
        while (it.hasNext()) {
            walked.append((String)it.next());
        }
        Assert.assertEquals((Object)EXPECTED_BFS_ORDER_WITH_DUPLICATES, (Object)walked.toString());
    }

    @Test
    public void testIterateBreadthFirstSearchWithoutDuplicates() {
        StringBuilder walked = new StringBuilder();
        GraphIterator it = GraphUtils.iterateBreadthFirst(Arrays.asList("a", "f"), EXAMPLE_DAG_PROVIDER, (Function)Functions.identity());
        while (it.hasNext()) {
            walked.append((String)it.next());
        }
        Assert.assertEquals((Object)EXPECTED_BFS_ORDER_NO_DUPLICATES, (Object)walked.toString());
    }

    @Test
    public void testIterateBFSWithPrune() {
        StringBuilder walked = new StringBuilder();
        GraphIterator it = GraphUtils.iterateBreadthFirst(Arrays.asList("a", "f"), EXAMPLE_DAG_PROVIDER, (Function)Functions.identity());
        while (it.hasNext()) {
            String value = (String)it.next();
            if ("b".equals(value)) {
                it.prune();
                continue;
            }
            walked.append(value);
        }
        Assert.assertEquals((Object)EXPECTED_BFS_ORDER_NO_DUPLICATES_PRUNED, (Object)walked.toString());
    }

    @Test
    public void testDepthFirstSearchWithDuplicates() {
        StringBuilder walked = new StringBuilder();
        GraphIterator it = GraphUtils.iterateDepthFirst(Arrays.asList("a", "f"), EXAMPLE_DAG_PROVIDER, null);
        while (it.hasNext()) {
            walked.append((String)it.next());
        }
        Assert.assertEquals((Object)EXPECTED_DFS_ORDER_WITH_DUPLICATES, (Object)walked.toString());
    }

    @Test
    public void testDepthFirstSearchWithoutDuplicates() {
        StringBuilder walked = new StringBuilder();
        GraphIterator it = GraphUtils.iterateDepthFirst(Arrays.asList("a", "f"), EXAMPLE_DAG_PROVIDER, (Function)Functions.identity());
        while (it.hasNext()) {
            walked.append((String)it.next());
        }
        Assert.assertEquals((Object)EXPECTED_DFS_ORDER_NO_DUPLICATES, (Object)walked.toString());
    }

    @Test
    public void testPruneLastItem() {
        StringBuilder walked = new StringBuilder();
        GraphIterator it = GraphUtils.iterateBreadthFirst(Arrays.asList("a", "f"), EXAMPLE_DAG_PROVIDER, (Function)Functions.identity());
        while (it.hasNext()) {
            String node = (String)it.next();
            walked.append(node);
            if (!node.equals("d")) continue;
            Assert.assertTrue((String)"There should have been more items in the GraphIterator", (boolean)it.hasNext());
            it.prune();
            Assert.assertFalse((String)"The GraphIterator should have been depleted", (boolean)it.hasNext());
        }
    }

    @Test
    public void testIterateFromNull() {
        GraphIterator it = GraphUtils.iterateDepthFirst(Arrays.asList(null, null), EXAMPLE_DAG_PROVIDER, null);
        Assert.assertFalse((String)"The graph iterator should skip null nodes", (boolean)it.hasNext());
    }
}

