/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.dag;

import com.atlassian.fisheye.dag.FilteredGraphIteratorDecorator;
import com.atlassian.fisheye.dag.GraphUtils;
import com.atlassian.fisheye.dag.GraphUtilsTest;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FilteredGraphIteratorDecoratorTest {
    @Test
    public void shouldIterateWithFiltering() throws Exception {
        FilteredGraphIteratorDecorator<String> filteredIterator = this.makeFilteredIterator();
        ImmutableList visitedItems = ImmutableList.copyOf(filteredIterator);
        Assert.assertThat((Object)visitedItems, (Matcher)Matchers.contains((Object[])new String[]{"a", "b", "e", "g"}));
    }

    @Test
    public void shouldPruneFilteredNode() throws Exception {
        FilteredGraphIteratorDecorator<String> filteredIterator = this.makeFilteredIterator();
        filteredIterator.next();
        filteredIterator.next();
        filteredIterator.prune();
        ImmutableList visitedItems = ImmutableList.copyOf(filteredIterator);
        Assert.assertThat((Object)visitedItems, (Matcher)Matchers.contains((Object[])new String[]{"e", "g"}));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIfPruneCalledWithNextItemAlreadyPolled() throws Exception {
        FilteredGraphIteratorDecorator<String> filteredIterator = this.makeFilteredIterator();
        filteredIterator.hasNext();
        filteredIterator.prune();
    }

    private FilteredGraphIteratorDecorator<String> makeFilteredIterator() {
        return new FilteredGraphIteratorDecorator(GraphUtils.iterateBreadthFirst((Collection)ImmutableList.of((Object)"a"), GraphUtilsTest.EXAMPLE_DAG_PROVIDER, (Function)Functions.identity()), Predicates.in((Collection)ImmutableList.of((Object)"a", (Object)"e", (Object)"b", (Object)"g", (Object)"f")));
    }
}

