/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.csvis;

import com.atlassian.fisheye.csvis.VisResult;
import com.atlassian.fisheye.csvis.VisualisationChangesetsCalculator;
import com.atlassian.fisheye.spi.services.Direction;
import com.atlassian.fisheye.util.MockChangeSetService;
import com.cenqua.fisheye.rep.impl.ChangeSetService;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.junit.Test;

public class VisualisationDataTest {
    private static final String CS_0 = "0";
    private static final String CS_1 = "1";
    private static final String CS_2 = "2";
    private static final String CS_3 = "3";
    private static final String CS_4 = "4";
    private static final String CS_5 = "5";
    private static final String CS_6 = "6";
    private static final String CS_7 = "7";
    private static final String CS_8 = "8";
    private static final String CS_9 = "9";
    private static final Set<String> SET_EMPTY = Collections.emptySet();
    private static final Set<String> SET_0 = ImmutableSet.of((Object)"0");
    private static final Set<String> SET_01 = ImmutableSet.of((Object)"0", (Object)"1");
    private static final Set<String> SET_012 = ImmutableSet.of((Object)"0", (Object)"1", (Object)"2");
    private static final Set<String> SET_01234567 = ImmutableSet.of((Object)"0", (Object)"1", (Object)"2", (Object)"3", (Object)"4", (Object)"5", (Object[])new String[]{"6", "7"});
    private static final Set<String> SET_017 = ImmutableSet.of((Object)"0", (Object)"1", (Object)"7");
    private static final Set<String> SET_1 = ImmutableSet.of((Object)"1");
    private static final Set<String> SET_1247 = ImmutableSet.of((Object)"1", (Object)"2", (Object)"4", (Object)"7");
    private static final Set<String> SET_17 = ImmutableSet.of((Object)"1", (Object)"7");
    private static final Set<String> SET_3 = ImmutableSet.of((Object)"3");
    private static final Set<String> SET_567 = ImmutableSet.of((Object)"5", (Object)"6", (Object)"7");
    private static final Set<String> SET_7 = ImmutableSet.of((Object)"7");
    private VisualisationChangesetsCalculator visCalc;
    MockChangeSetService csService;
    private Map<Set<String>, Set<String>> expectedAdjacentChangeSets = new HashMap<Set<String>, Set<String>>();

    public VisualisationDataTest() {
        this.csService = new MockChangeSetService();
        this.visCalc = new VisualisationChangesetsCalculator((ChangeSetService)this.csService);
    }

    private void initData1() {
        this.csService.addChangeSet(this.mockChangeset(CS_0).branch("A"));
        this.csService.addChangeSet(this.mockChangeset(CS_1).parents(CS_0).branch("A"));
        this.csService.addChangeSet(this.mockChangeset(CS_2).parents(CS_0).branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_3).parents(CS_0).branch("C"));
        this.csService.addChangeSet(this.mockChangeset(CS_4).parents(CS_2).branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_5).parents(CS_3).branch("C"));
        this.csService.addChangeSet(this.mockChangeset(CS_6).parents(CS_4, CS_5).branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_7).parents(CS_1, CS_6).branch("A"));
        this.addExpectedAdjacentChangeSets(SET_EMPTY, SET_EMPTY);
        this.addExpectedAdjacentChangeSets(SET_0, (Set<String>)ImmutableSet.of((Object)CS_1, (Object)CS_2, (Object)CS_3));
        this.addExpectedAdjacentChangeSets(SET_01, (Set<String>)ImmutableSet.of((Object)CS_2, (Object)CS_3, (Object)CS_7));
        this.addExpectedAdjacentChangeSets(SET_012, (Set<String>)ImmutableSet.of((Object)CS_3, (Object)CS_4, (Object)CS_7));
        this.addExpectedAdjacentChangeSets(SET_01234567, SET_EMPTY);
        this.addExpectedAdjacentChangeSets(SET_017, (Set<String>)ImmutableSet.of((Object)CS_2, (Object)CS_3, (Object)CS_6));
        this.addExpectedAdjacentChangeSets(SET_1, (Set<String>)ImmutableSet.of((Object)CS_0, (Object)CS_7));
        this.addExpectedAdjacentChangeSets(SET_3, (Set<String>)ImmutableSet.of((Object)CS_0, (Object)CS_5));
        this.addExpectedAdjacentChangeSets(SET_567, (Set<String>)ImmutableSet.of((Object)CS_1, (Object)CS_3, (Object)CS_4));
        this.addExpectedAdjacentChangeSets(SET_7, (Set<String>)ImmutableSet.of((Object)CS_1, (Object)CS_6));
    }

    private void addExpectedAdjacentChangeSets(Set<String> live, Set<String> adjacent) {
        this.expectedAdjacentChangeSets.put(live, adjacent);
    }

    @Test
    public void testSmallWindowAtEnd() throws Exception {
        this.initData1();
        VisResult vis = this.visCalc.getChangeSets(CS_6, 3, Direction.around);
        this.assertChangeSets(vis, SET_567);
        vis = this.visCalc.getChangeSets(CS_5, 3, Direction.after);
        this.assertChangeSets(vis, SET_567);
        vis = this.visCalc.getChangeSets(CS_7, 3, Direction.before);
        this.assertChangeSets(vis, SET_567);
    }

    @Test
    public void testAllFromStart() throws Exception {
        this.initData1();
        VisResult vis = this.visCalc.getChangeSets(CS_0, 20, Direction.around);
        this.assertChangeSets(vis, SET_01234567);
        vis = this.visCalc.getChangeSets(CS_0, 20, Direction.after);
        this.assertChangeSets(vis, SET_01234567);
        vis = this.visCalc.getChangeSets(CS_0, 20, Direction.before);
        this.assertChangeSets(vis, SET_0);
    }

    @Test
    public void testAllFromEnd() throws Exception {
        this.initData1();
        VisResult vis = this.visCalc.getChangeSets(CS_7, 20, Direction.around);
        this.assertChangeSets(vis, SET_01234567);
        vis = this.visCalc.getChangeSets(CS_7, 20, Direction.after);
        this.assertChangeSets(vis, SET_7);
        vis = this.visCalc.getChangeSets(CS_7, 20, Direction.before);
        this.assertChangeSets(vis, SET_01234567);
    }

    @Test
    public void testSmallWindowAtStart() throws Exception {
        this.initData1();
        VisResult vis = this.visCalc.getChangeSets(CS_1, 3, Direction.around);
        this.assertChangeSets(vis, SET_012);
        vis = this.visCalc.getChangeSets(CS_0, 3, Direction.after);
        this.assertChangeSets(vis, SET_012);
        vis = this.visCalc.getChangeSets(CS_2, 3, Direction.before);
        this.assertChangeSets(vis, SET_012);
    }

    @Test
    public void testSpanningAtMiddle() throws Exception {
        this.initData1();
        VisResult vis = this.visCalc.getChangeSets(CS_3, 1, Direction.around);
        this.assertChangeSets(vis, SET_3, SET_1247);
        vis = this.visCalc.getChangeSets(CS_3, 1, Direction.after);
        this.assertChangeSets(vis, SET_3, SET_1247);
        vis = this.visCalc.getChangeSets(CS_3, 1, Direction.before);
        this.assertChangeSets(vis, SET_3, SET_1247);
    }

    @Test
    public void testAllBranchA() throws Exception {
        this.initData1();
        VisResult vis = this.visCalc.getChangeSets(CS_1, 3, Collections.singleton("A"), Direction.around);
        this.assertChangeSets(vis, SET_017);
        vis = this.visCalc.getChangeSets(CS_0, 3, Collections.singleton("A"), Direction.after);
        this.assertChangeSets(vis, SET_017);
        vis = this.visCalc.getChangeSets(CS_7, 3, Collections.singleton("A"), Direction.before);
        this.assertChangeSets(vis, SET_017);
        vis = this.visCalc.getChangeSets(CS_7, 3, Collections.singleton("A"), Direction.after);
        this.assertChangeSets(vis, SET_7);
        vis = this.visCalc.getChangeSets(CS_0, 3, Collections.singleton("A"), Direction.before);
        this.assertChangeSets(vis, SET_0);
    }

    @Test
    public void testAllBranchANonBranchStart() throws Exception {
        this.initData1();
        VisResult vis = this.visCalc.getChangeSets(CS_3, 3, Collections.singleton("A"), Direction.around);
        this.assertChangeSets(vis, SET_017);
        vis = this.visCalc.getChangeSets(CS_3, 3, Collections.singleton("A"), Direction.after);
        this.assertChangeSets(vis, SET_7);
        vis = this.visCalc.getChangeSets(CS_3, 3, Collections.singleton("A"), Direction.before);
        this.assertChangeSets(vis, SET_01);
    }

    @Test
    public void testPartBranchA() throws Exception {
        this.initData1();
        VisResult vis = this.visCalc.getChangeSets(CS_1, 1, Collections.singleton("A"), Direction.around);
        this.assertChangeSets(vis, SET_1);
    }

    @Test
    public void testSpanningBranches() throws Exception {
        this.initData1();
        VisResult vis = this.visCalc.getChangeSets(CS_3, 1, (Set)ImmutableSet.of((Object)"A", (Object)"C"), Direction.around);
        this.assertChangeSets(vis, SET_3, SET_17);
        vis = this.visCalc.getChangeSets(CS_3, 1, (Set)ImmutableSet.of((Object)"A", (Object)"C"), Direction.after);
        this.assertChangeSets(vis, SET_3, SET_17);
        vis = this.visCalc.getChangeSets(CS_3, 1, (Set)ImmutableSet.of((Object)"A", (Object)"C"), Direction.before);
        this.assertChangeSets(vis, SET_3, SET_17);
    }

    private void initData2() {
        this.csService.addChangeSet(this.mockChangeset(CS_0).branch("A").branch("B").branch("C"));
        this.csService.addChangeSet(this.mockChangeset(CS_1).parents(CS_0).branch("A"));
        this.csService.addChangeSet(this.mockChangeset(CS_2).parents(CS_0).branch("A").branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_3).parents(CS_0).branch("A").branch("B").branch("C"));
        this.csService.addChangeSet(this.mockChangeset(CS_4).parents(CS_2).branch("A").branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_5).parents(CS_3).branch("A").branch("B").branch("C"));
        this.csService.addChangeSet(this.mockChangeset(CS_6).parents(CS_4, CS_5).branch("A").branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_7).parents(CS_1, CS_6).branch("A"));
        this.csService.addChangeSet(this.mockChangeset(CS_8).parents(CS_6).branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_9).parents(CS_5).branch("C"));
        this.addExpectedAdjacentChangeSets(SET_EMPTY, SET_EMPTY);
        this.addExpectedAdjacentChangeSets(SET_0, (Set<String>)ImmutableSet.of((Object)CS_1, (Object)CS_2, (Object)CS_3));
        this.addExpectedAdjacentChangeSets(SET_01, (Set<String>)ImmutableSet.of((Object)CS_2, (Object)CS_3, (Object)CS_7));
        this.addExpectedAdjacentChangeSets(SET_012, (Set<String>)ImmutableSet.of((Object)CS_3, (Object)CS_4, (Object)CS_7));
        this.addExpectedAdjacentChangeSets(SET_01234567, SET_EMPTY);
        this.addExpectedAdjacentChangeSets(SET_017, (Set<String>)ImmutableSet.of((Object)CS_2, (Object)CS_3, (Object)CS_6));
        this.addExpectedAdjacentChangeSets(SET_1, (Set<String>)ImmutableSet.of((Object)CS_0, (Object)CS_7));
        this.addExpectedAdjacentChangeSets(SET_3, (Set<String>)ImmutableSet.of((Object)CS_0, (Object)CS_5));
        this.addExpectedAdjacentChangeSets(SET_567, (Set<String>)ImmutableSet.of((Object)CS_1, (Object)CS_3, (Object)CS_4));
        this.addExpectedAdjacentChangeSets(SET_7, (Set<String>)ImmutableSet.of((Object)CS_1, (Object)CS_6));
    }

    private void assertChangeSets(VisResult vis, Set<String> expectedLiveChangeSets, Set<String> expectedSpanningChangeSets) {
        TestCase.assertEquals(expectedLiveChangeSets, (Object)vis.getLiveChangesetIds());
        Set<String> adjacent = this.expectedAdjacentChangeSets.get(expectedLiveChangeSets);
        TestCase.assertEquals((Object)vis.getAdjacentContextChangesetIds(), adjacent);
        TestCase.assertEquals((Object)vis.getSpanningContextChangesetIds(), expectedSpanningChangeSets);
    }

    private void assertChangeSets(VisResult vis, Set<String> expectedLiveChangeSets) {
        this.assertChangeSets(vis, expectedLiveChangeSets, SET_EMPTY);
    }

    private MockChangeSetService.MockChangeSet mockChangeset(String csid) {
        return this.csService.mockChangeset(csid);
    }
}

