/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.csvis;

import com.atlassian.fisheye.csvis.AlternatingChangeSetIterator;
import com.atlassian.fisheye.csvis.VisParameters;
import com.atlassian.fisheye.spi.services.Direction;
import com.atlassian.fisheye.util.MockChangeSetService;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.ChangeSetService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;
import org.junit.Test;

public class AlternatingChangeSetIteratorTest {
    private static final String CS_0 = "0";
    private static final String CS_1 = "1";
    private static final String CS_2 = "2";
    private static final String CS_3 = "3";
    private static final String CS_4 = "4";
    private static final String CS_5 = "5";
    private static final String CS_6 = "6";
    private static final String CS_7 = "7";
    private static final String CS_8 = "8";
    private static final String CS_9 = "9";
    MockChangeSetService csService = new MockChangeSetService();

    private MockChangeSetService.MockChangeSet mockChangeset(String csid) {
        return this.csService.mockChangeset(csid);
    }

    private void initData1() {
        this.csService.addChangeSet(this.mockChangeset(CS_0).branch("A"));
        this.csService.addChangeSet(this.mockChangeset(CS_1).parents(CS_0).branch("A"));
        this.csService.addChangeSet(this.mockChangeset(CS_2).parents(CS_0).branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_3).parents(CS_0).branch("C"));
        this.csService.addChangeSet(this.mockChangeset(CS_4).parents(CS_2).branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_5).parents(CS_3).branch("C"));
        this.csService.addChangeSet(this.mockChangeset(CS_6).parents(CS_4, CS_5).branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_7).parents(CS_1, CS_6).branch("A"));
    }

    @Test
    public void testIterateNullBranches() throws DbException {
        this.initData1();
        VisParameters.Builder builder = new VisParameters.Builder().anchorChangeset(this.csService.getChangeSet(CS_0));
        this.assertIteration(builder, Direction.around, CS_1, CS_2, CS_3, CS_4, CS_5, CS_6, CS_7);
        this.assertIteration(builder, Direction.after, CS_1, CS_2, CS_3, CS_4, CS_5, CS_6, CS_7);
        this.assertIterationEmpty(builder, Direction.before);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_7));
        this.assertIteration(builder, Direction.around, CS_6, CS_5, CS_4, CS_3, CS_2, CS_1, CS_0);
        this.assertIterationEmpty(builder, Direction.after);
        this.assertIteration(builder, Direction.before, CS_6, CS_5, CS_4, CS_3, CS_2, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_4));
        this.assertIteration(builder, Direction.around, CS_5, CS_3, CS_6, CS_2, CS_7, CS_1, CS_0);
        this.assertIteration(builder, Direction.after, CS_5, CS_6, CS_7);
        this.assertIteration(builder, Direction.before, CS_3, CS_2, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_2));
        this.assertIteration(builder, Direction.around, CS_3, CS_1, CS_4, CS_0, CS_5, CS_6, CS_7);
        this.assertIteration(builder, Direction.after, CS_3, CS_4, CS_5, CS_6, CS_7);
        this.assertIteration(builder, Direction.before, CS_1, CS_0);
    }

    @Test
    public void testIterateAllBranches() throws DbException {
        this.initData1();
        HashSet<String> branches = new HashSet<String>(Arrays.asList("A", "B", "C"));
        VisParameters.Builder builder = new VisParameters.Builder().anchorChangeset(this.csService.getChangeSet(CS_0)).branches(branches);
        this.assertIteration(builder, Direction.around, CS_1, CS_2, CS_3, CS_4, CS_5, CS_6, CS_7);
        this.assertIteration(builder, Direction.after, CS_1, CS_2, CS_3, CS_4, CS_5, CS_6, CS_7);
        this.assertIterationEmpty(builder, Direction.before);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_7));
        this.assertIteration(builder, Direction.around, CS_6, CS_5, CS_4, CS_3, CS_2, CS_1, CS_0);
        this.assertIterationEmpty(builder, Direction.after);
        this.assertIteration(builder, Direction.before, CS_6, CS_5, CS_4, CS_3, CS_2, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_4));
        this.assertIteration(builder, Direction.around, CS_5, CS_3, CS_6, CS_2, CS_7, CS_1, CS_0);
        this.assertIteration(builder, Direction.after, CS_5, CS_6, CS_7);
        this.assertIteration(builder, Direction.before, CS_3, CS_2, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_2));
        this.assertIteration(builder, Direction.around, CS_3, CS_1, CS_4, CS_0, CS_5, CS_6, CS_7);
        this.assertIteration(builder, Direction.after, CS_3, CS_4, CS_5, CS_6, CS_7);
        this.assertIteration(builder, Direction.before, CS_1, CS_0);
    }

    @Test
    public void testIterateBranchesAB() throws DbException {
        this.initData1();
        HashSet<String> branches = new HashSet<String>(Arrays.asList("A", "B"));
        VisParameters.Builder builder = new VisParameters.Builder().anchorChangeset(this.csService.getChangeSet(CS_0)).branches(branches);
        this.assertIteration(builder, Direction.around, CS_1, CS_2, CS_4, CS_6, CS_7);
        this.assertIteration(builder, Direction.after, CS_1, CS_2, CS_4, CS_6, CS_7);
        this.assertIterationEmpty(builder, Direction.before);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_7));
        this.assertIteration(builder, Direction.around, CS_6, CS_4, CS_2, CS_1, CS_0);
        this.assertIterationEmpty(builder, Direction.after);
        this.assertIteration(builder, Direction.before, CS_6, CS_4, CS_2, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_4));
        this.assertIteration(builder, Direction.around, CS_6, CS_2, CS_7, CS_1, CS_0);
        this.assertIteration(builder, Direction.after, CS_6, CS_7);
        this.assertIteration(builder, Direction.before, CS_2, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_3));
        this.assertIteration(builder, Direction.around, CS_4, CS_2, CS_6, CS_1, CS_7, CS_0);
        this.assertIteration(builder, Direction.after, CS_4, CS_6, CS_7);
        this.assertIteration(builder, Direction.before, CS_2, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_2));
        this.assertIteration(builder, Direction.around, CS_4, CS_1, CS_6, CS_0, CS_7);
        this.assertIteration(builder, Direction.after, CS_4, CS_6, CS_7);
        this.assertIteration(builder, Direction.before, CS_1, CS_0);
    }

    @Test
    public void testIterateBranchesBC() throws DbException {
        this.initData1();
        HashSet<String> branches = new HashSet<String>(Arrays.asList("B", "C"));
        VisParameters.Builder builder = new VisParameters.Builder().anchorChangeset(this.csService.getChangeSet(CS_0)).branches(branches);
        this.assertIteration(builder, Direction.around, CS_2, CS_3, CS_4, CS_5, CS_6);
        this.assertIteration(builder, Direction.after, CS_2, CS_3, CS_4, CS_5, CS_6);
        this.assertIterationEmpty(builder, Direction.before);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_7));
        this.assertIteration(builder, Direction.around, CS_6, CS_5, CS_4, CS_3, CS_2);
        this.assertIterationEmpty(builder, Direction.after);
        this.assertIteration(builder, Direction.before, CS_6, CS_5, CS_4, CS_3, CS_2);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_4));
        this.assertIteration(builder, Direction.around, CS_5, CS_3, CS_6, CS_2);
        this.assertIteration(builder, Direction.after, CS_5, CS_6);
        this.assertIteration(builder, Direction.before, CS_3, CS_2);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_2));
        this.assertIteration(builder, Direction.around, CS_3, CS_4, CS_5, CS_6);
        this.assertIteration(builder, Direction.after, CS_3, CS_4, CS_5, CS_6);
        this.assertIterationEmpty(builder, Direction.before);
    }

    @Test
    public void testIterateBranchA() throws DbException {
        this.initData1();
        HashSet<String> branches = new HashSet<String>(Arrays.asList("A"));
        VisParameters.Builder builder = new VisParameters.Builder().anchorChangeset(this.csService.getChangeSet(CS_0)).branches(branches);
        this.assertIteration(builder, Direction.around, CS_1, CS_7);
        this.assertIteration(builder, Direction.after, CS_1, CS_7);
        this.assertIterationEmpty(builder, Direction.before);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_7));
        this.assertIteration(builder, Direction.around, CS_1, CS_0);
        this.assertIterationEmpty(builder, Direction.after);
        this.assertIteration(builder, Direction.before, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_4));
        this.assertIteration(builder, Direction.around, CS_7, CS_1, CS_0);
        this.assertIteration(builder, Direction.after, CS_7);
        this.assertIteration(builder, Direction.before, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_1));
        this.assertIteration(builder, Direction.around, CS_7, CS_0);
        this.assertIteration(builder, Direction.after, CS_7);
        this.assertIteration(builder, Direction.before, CS_0);
    }

    @Test
    public void testIterateBranchB() throws DbException {
        this.initData1();
        HashSet<String> branches = new HashSet<String>(Arrays.asList("B"));
        VisParameters.Builder builder = new VisParameters.Builder().anchorChangeset(this.csService.getChangeSet(CS_0)).branches(branches);
        this.assertIteration(builder, Direction.around, CS_2, CS_4, CS_6);
        this.assertIteration(builder, Direction.after, CS_2, CS_4, CS_6);
        this.assertIterationEmpty(builder, Direction.before);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_7));
        this.assertIteration(builder, Direction.around, CS_6, CS_4, CS_2);
        this.assertIterationEmpty(builder, Direction.after);
        this.assertIteration(builder, Direction.before, CS_6, CS_4, CS_2);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_4));
        this.assertIteration(builder, Direction.around, CS_6, CS_2);
        this.assertIteration(builder, Direction.after, CS_6);
        this.assertIteration(builder, Direction.before, CS_2);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_2));
        this.assertIteration(builder, Direction.around, CS_4, CS_6);
        this.assertIteration(builder, Direction.after, CS_4, CS_6);
        this.assertIterationEmpty(builder, Direction.before);
    }

    private void initData2() {
        this.csService.addChangeSet(this.mockChangeset(CS_0).branch("A").branch("B").branch("C"));
        this.csService.addChangeSet(this.mockChangeset(CS_1).parents(CS_0).branch("A"));
        this.csService.addChangeSet(this.mockChangeset(CS_2).parents(CS_0).branch("A").branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_3).parents(CS_0).branch("A").branch("B").branch("C"));
        this.csService.addChangeSet(this.mockChangeset(CS_4).parents(CS_2).branch("A").branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_5).parents(CS_3).branch("A").branch("B").branch("C"));
        this.csService.addChangeSet(this.mockChangeset(CS_6).parents(CS_4, CS_5).branch("A").branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_7).parents(CS_1, CS_6).branch("A"));
        this.csService.addChangeSet(this.mockChangeset(CS_8).parents(CS_6).branch("B"));
        this.csService.addChangeSet(this.mockChangeset(CS_9).parents(CS_5).branch("C"));
    }

    @Test
    public void testIterateAllOverlappingBranches() throws DbException {
        this.initData2();
        HashSet<String> branches = new HashSet<String>(Arrays.asList("A", "B", "C"));
        VisParameters.Builder builder = new VisParameters.Builder().anchorChangeset(this.csService.getChangeSet(CS_0)).branches(branches);
        this.assertIteration(builder, Direction.around, CS_1, CS_2, CS_3, CS_4, CS_5, CS_6, CS_7, CS_8, CS_9);
        this.assertIteration(builder, Direction.after, CS_1, CS_2, CS_3, CS_4, CS_5, CS_6, CS_7, CS_8, CS_9);
        this.assertIterationEmpty(builder, Direction.before);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_9));
        this.assertIteration(builder, Direction.around, CS_8, CS_7, CS_6, CS_5, CS_4, CS_3, CS_2, CS_1, CS_0);
        this.assertIterationEmpty(builder, Direction.after);
        this.assertIteration(builder, Direction.before, CS_8, CS_7, CS_6, CS_5, CS_4, CS_3, CS_2, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_4));
        this.assertIteration(builder, Direction.around, CS_5, CS_3, CS_6, CS_2, CS_7, CS_1, CS_8, CS_0, CS_9);
        this.assertIteration(builder, Direction.after, CS_5, CS_6, CS_7, CS_8, CS_9);
        this.assertIteration(builder, Direction.before, CS_3, CS_2, CS_1, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_2));
        this.assertIteration(builder, Direction.around, CS_3, CS_1, CS_4, CS_0, CS_5, CS_6, CS_7, CS_8, CS_9);
        this.assertIteration(builder, Direction.after, CS_3, CS_4, CS_5, CS_6, CS_7, CS_8, CS_9);
        this.assertIteration(builder, Direction.before, CS_1, CS_0);
    }

    @Test
    public void testIterateOverlappingBranchB() throws DbException {
        this.initData2();
        HashSet<String> branches = new HashSet<String>(Arrays.asList("B"));
        VisParameters.Builder builder = new VisParameters.Builder().anchorChangeset(this.csService.getChangeSet(CS_0)).branches(branches);
        this.assertIteration(builder, Direction.around, CS_2, CS_3, CS_4, CS_5, CS_6, CS_8);
        this.assertIteration(builder, Direction.after, CS_2, CS_3, CS_4, CS_5, CS_6, CS_8);
        this.assertIterationEmpty(builder, Direction.before);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_9));
        this.assertIteration(builder, Direction.around, CS_8, CS_6, CS_5, CS_4, CS_3, CS_2, CS_0);
        this.assertIterationEmpty(builder, Direction.after);
        this.assertIteration(builder, Direction.before, CS_8, CS_6, CS_5, CS_4, CS_3, CS_2, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_4));
        this.assertIteration(builder, Direction.around, CS_5, CS_3, CS_6, CS_2, CS_8, CS_0);
        this.assertIteration(builder, Direction.after, CS_5, CS_6, CS_8);
        this.assertIteration(builder, Direction.before, CS_3, CS_2, CS_0);
        builder = builder.anchorChangeset(this.csService.getChangeSet(CS_2));
        this.assertIteration(builder, Direction.around, CS_3, CS_0, CS_4, CS_5, CS_6, CS_8);
        this.assertIteration(builder, Direction.after, CS_3, CS_4, CS_5, CS_6, CS_8);
        this.assertIteration(builder, Direction.before, CS_0);
    }

    private void assertIterationEmpty(VisParameters.Builder builder, Direction direction) {
        AlternatingChangeSetIterator iterator = this.getIterator(builder, direction);
        TestCase.assertFalse((boolean)iterator.hasNext());
    }

    private void assertIteration(VisParameters.Builder builder, Direction direction, String ... csIds) {
        AlternatingChangeSetIterator iterator = this.getIterator(builder, direction);
        this.assertOrder(iterator, csIds);
    }

    private AlternatingChangeSetIterator getIterator(VisParameters.Builder builder, Direction direction) {
        return AlternatingChangeSetIterator.getInstance((ChangeSetService)this.csService, (VisParameters)builder.direction(direction).build());
    }

    private void assertOrder(AlternatingChangeSetIterator iterator, String ... csIds) {
        ArrayList<String> actualIds = new ArrayList<String>();
        while (iterator.hasNext()) {
            actualIds.add(iterator.next().getId());
        }
        TestCase.assertEquals(Arrays.asList(csIds), actualIds);
    }
}

