/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataElement;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.Pair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class TestUtils {
    static SimpleDateFormat df = new SimpleDateFormat("E MMM dd HH:mm:ss zz yyyy", Locale.US);

    static XYSeries seriesToBuckets(XYSeries dataOld, TimeZone timeZone) throws Exception {
        XYSeries dataOldBuckets = dataOld.createCopy(0, 0);
        dataOldBuckets.clear();
        if (dataOld.getItemCount() == 0) {
            return dataOldBuckets;
        }
        Period bucket = new Period(PeriodUnit.DAY, new Date(dataOld.getX(0).longValue()), timeZone);
        Period nextBucket = new Period(PeriodUnit.DAY, new Date(dataOld.getX(0).longValue()), timeZone);
        dataOldBuckets.add((double)(bucket.getStartTime() - 1L), 0.0);
        for (int i = 0; i < dataOld.getItemCount() - 1; ++i) {
            Date date = new Date(dataOld.getX(i).longValue());
            Date nextDate = new Date(dataOld.getX(i + 1).longValue());
            bucket = new Period(PeriodUnit.DAY, date, timeZone);
            nextBucket = new Period(PeriodUnit.DAY, nextDate, timeZone);
            if (bucket.getBucket() == nextBucket.getBucket()) continue;
            dataOldBuckets.add((double)bucket.getEndTime(), (double)dataOld.getY(i).intValue());
        }
        dataOldBuckets.add((double)nextBucket.getEndTime(), (double)dataOld.getY(dataOld.getItemCount() - 1).intValue());
        dataOldBuckets = TestUtils.fillGaps(dataOldBuckets, timeZone);
        return dataOldBuckets;
    }

    private static XYSeries fillGaps(XYSeries series, TimeZone timeZone) throws Exception {
        int value;
        int i;
        XYSeries newSeries = series.createCopy(0, 0);
        newSeries.clear();
        Period nextBucket = new Period(PeriodUnit.DAY, new Date(series.getX(0).longValue()), timeZone);
        for (i = 0; i < series.getItemCount() - 1; ++i) {
            Date date = new Date(series.getX(i).longValue());
            Date nextDate = new Date(series.getX(i + 1).longValue());
            Period bucket = new Period(PeriodUnit.DAY, date, timeZone);
            nextBucket = new Period(PeriodUnit.DAY, nextDate, timeZone);
            value = series.getY(i).intValue();
            for (int j = bucket.getBucket(); j < nextBucket.getBucket(); ++j) {
                Period tmpBucket = new Period(PeriodUnit.DAY, j, timeZone);
                newSeries.add((double)tmpBucket.getEndTime(), (double)value);
            }
        }
        value = series.getY(i).intValue();
        newSeries.add((double)nextBucket.getEndTime(), (double)value);
        return newSeries;
    }

    public static String seriesToString(XYSeries series, TimeZone tz) {
        StringBuilder sb = new StringBuilder();
        df.setTimeZone(tz);
        for (int i = 0; i < series.getItemCount(); ++i) {
            XYDataItem item = series.getDataItem(i);
            sb.append(TestUtils.formatDate(new Date(item.getX().longValue()), tz)).append(" ").append(item.getY()).append("\n");
        }
        return sb.toString();
    }

    public static String fileHistoryToString(FileHistory hist, String branch, TimeZone tz) {
        StringBuilder sb = new StringBuilder();
        hist.getRevisionsSorted();
        for (Object rev : hist.getRevisions(branch == null ? hist.getMainBranch() : branch)) {
            String revName = (String)rev;
            FileRevision filerev = hist.getRevision(revName);
            sb.append(TestUtils.formatDate(new Date(filerev.getDate()), tz)).append(" ").append(filerev.getLineCount()).append(" (+").append(filerev.getLinesAdded()).append(" -").append(filerev.getLinesRemoved()).append(": ").append(filerev.getLinesAdded() - filerev.getLinesRemoved()).append(")\n");
        }
        return sb.toString();
    }

    public static String readFile(String filename) throws Exception {
        File file = new File("src/tests/com/atlassian/fisheye/bucket/" + filename);
        StringBuilder sb = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            while (in.ready()) {
                sb.append(in.readLine()).append("\n");
            }
        }
        return sb.toString();
    }

    static boolean checkSeriesAreEquivalent(XYSeries dataOld, XYSeries dataNew, TimeZone timeZone) throws Exception {
        XYSeries dataOldBuckets = TestUtils.seriesToBuckets(dataOld, timeZone);
        return TestUtils.seriesToString(dataOldBuckets, timeZone).equals(TestUtils.seriesToString(dataNew, timeZone));
    }

    public static String bucketDataToString(BucketData<BucketDataElement> bucketData, TimeZone timeZone) throws BucketGraph.InvalidBucketException {
        StringBuilder sb = new StringBuilder();
        for (Pair element : bucketData.getPeriodData(timeZone)) {
            Period period = (Period)element.getFirst();
            sb.append(period.getBucket()).append("[").append(TestUtils.formatDate(period.getStartDate(), timeZone));
            sb.append(" - ").append(TestUtils.formatDate(period.getEndDate(), timeZone)).append("]: LOC ");
            sb.append(((BucketDataElement)element.getSecond()).getLinecountChange()).append(",\t revs ").append(((BucketDataElement)element.getSecond()).getRevcount()).append("\n");
        }
        return sb.toString();
    }

    public static String formatDate(Date date, TimeZone timeZone) {
        df.setTimeZone(timeZone);
        return df.format(date);
    }
}

