/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.bucket.TestUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.TestCase;

public class PeriodTest
extends TestCase {
    private final TimeZone timeZoneTokyo = TimeZone.getTimeZone("Asia/Tokyo");
    private final TimeZone timeZoneEurope = TimeZone.getTimeZone("Europe/Warsaw");

    private void checkDate(Calendar cal, Period p, String dateString, String periodString) throws Exception {
        Date date = cal.getTime();
        p.setPeriod(date);
        PeriodTest.assertEquals((String)TestUtils.formatDate(date, this.timeZoneTokyo), (String)dateString);
        PeriodTest.assertEquals((String)p.toString(), (String)periodString);
        Period p2 = new Period(p.getPeriodUnit(), p.getStartDate(), this.timeZoneTokyo);
        Period p3 = new Period(p.getPeriodUnit(), p.getEndDate(), this.timeZoneTokyo);
        PeriodTest.assertEquals((int)p.getBucket(), (int)p2.getBucket());
        PeriodTest.assertEquals((int)p.getBucket(), (int)p3.getBucket());
        Period p4 = new Period(p.getPeriodUnit(), p.getBucket(), this.timeZoneTokyo);
        PeriodTest.assertEquals((String)p.toString(), (String)p4.toString());
    }

    private Calendar getCalendar(TimeZone timeZone) {
        GregorianCalendar cal = new GregorianCalendar(timeZone);
        cal.set(1970, 0, 1, 0, 0, 0);
        return cal;
    }

    public void testDayBasic() throws Exception {
        Calendar cal = this.getCalendar(this.timeZoneTokyo);
        Period p = new Period(PeriodUnit.DAY, this.timeZoneTokyo);
        this.checkDate(cal, p, "Thu Jan 01 00:00:00 JST 1970", "4 (Thu Jan 01 00:00:00 JST 1970 - Thu Jan 01 23:59:59 JST 1970)");
        cal.add(10, 11);
        this.checkDate(cal, p, "Thu Jan 01 11:00:00 JST 1970", "4 (Thu Jan 01 00:00:00 JST 1970 - Thu Jan 01 23:59:59 JST 1970)");
        cal.add(6, 1);
        this.checkDate(cal, p, "Fri Jan 02 11:00:00 JST 1970", "5 (Fri Jan 02 00:00:00 JST 1970 - Fri Jan 02 23:59:59 JST 1970)");
        cal.add(1, 1);
        this.checkDate(cal, p, "Sat Jan 02 11:00:00 JST 1971", "370 (Sat Jan 02 00:00:00 JST 1971 - Sat Jan 02 23:59:59 JST 1971)");
        cal.add(2, 6);
        this.checkDate(cal, p, "Fri Jul 02 11:00:00 JST 1971", "551 (Fri Jul 02 00:00:00 JST 1971 - Fri Jul 02 23:59:59 JST 1971)");
        cal.add(1, 30);
        this.checkDate(cal, p, "Mon Jul 02 11:00:00 JST 2001", "11509 (Mon Jul 02 00:00:00 JST 2001 - Mon Jul 02 23:59:59 JST 2001)");
        cal.add(2, 6);
        this.checkDate(cal, p, "Wed Jan 02 11:00:00 JST 2002", "11693 (Wed Jan 02 00:00:00 JST 2002 - Wed Jan 02 23:59:59 JST 2002)");
    }

    public void testDayBoundary() throws Exception {
        Calendar cal = this.getCalendar(this.timeZoneTokyo);
        Period p = new Period(PeriodUnit.DAY, this.timeZoneTokyo);
        cal.add(6, 1);
        this.checkDate(cal, p, "Fri Jan 02 00:00:00 JST 1970", "5 (Fri Jan 02 00:00:00 JST 1970 - Fri Jan 02 23:59:59 JST 1970)");
        cal.add(13, -1);
        this.checkDate(cal, p, "Thu Jan 01 23:59:59 JST 1970", "4 (Thu Jan 01 00:00:00 JST 1970 - Thu Jan 01 23:59:59 JST 1970)");
    }

    public void testWeekBasic() throws Exception {
        Calendar cal = this.getCalendar(this.timeZoneTokyo);
        Period p = new Period(PeriodUnit.WEEK, this.timeZoneTokyo);
        this.checkDate(cal, p, "Thu Jan 01 00:00:00 JST 1970", "0 (Sun Dec 28 00:00:00 JST 1969 - Sat Jan 03 23:59:59 JST 1970)");
        cal.add(10, 11);
        this.checkDate(cal, p, "Thu Jan 01 11:00:00 JST 1970", "0 (Sun Dec 28 00:00:00 JST 1969 - Sat Jan 03 23:59:59 JST 1970)");
        cal.add(3, 1);
        this.checkDate(cal, p, "Thu Jan 08 11:00:00 JST 1970", "1 (Sun Jan 04 00:00:00 JST 1970 - Sat Jan 10 23:59:59 JST 1970)");
        cal.add(6, 21);
        this.checkDate(cal, p, "Thu Jan 29 11:00:00 JST 1970", "4 (Sun Jan 25 00:00:00 JST 1970 - Sat Jan 31 23:59:59 JST 1970)");
        cal.add(1, 1);
        this.checkDate(cal, p, "Fri Jan 29 11:00:00 JST 1971", "56 (Sun Jan 24 00:00:00 JST 1971 - Sat Jan 30 23:59:59 JST 1971)");
        cal.add(2, 6);
        this.checkDate(cal, p, "Thu Jul 29 11:00:00 JST 1971", "82 (Sun Jul 25 00:00:00 JST 1971 - Sat Jul 31 23:59:59 JST 1971)");
        cal.add(1, 30);
        this.checkDate(cal, p, "Sun Jul 29 11:00:00 JST 2001", "1648 (Sun Jul 29 00:00:00 JST 2001 - Sat Aug 04 23:59:59 JST 2001)");
        cal.add(2, 6);
        this.checkDate(cal, p, "Tue Jan 29 11:00:00 JST 2002", "1674 (Sun Jan 27 00:00:00 JST 2002 - Sat Feb 02 23:59:59 JST 2002)");
    }

    public void testWeekBoundary() throws Exception {
        Calendar cal = this.getCalendar(this.timeZoneTokyo);
        Period p = new Period(PeriodUnit.WEEK, this.timeZoneTokyo);
        cal.add(6, 3);
        this.checkDate(cal, p, "Sun Jan 04 00:00:00 JST 1970", "1 (Sun Jan 04 00:00:00 JST 1970 - Sat Jan 10 23:59:59 JST 1970)");
        cal.add(13, -1);
        this.checkDate(cal, p, "Sat Jan 03 23:59:59 JST 1970", "0 (Sun Dec 28 00:00:00 JST 1969 - Sat Jan 03 23:59:59 JST 1970)");
    }

    public void testMonthBasic() throws Exception {
        Calendar cal = this.getCalendar(this.timeZoneTokyo);
        Period p = new Period(PeriodUnit.MONTH, this.timeZoneTokyo);
        this.checkDate(cal, p, "Thu Jan 01 00:00:00 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Sat Jan 31 23:59:59 JST 1970)");
        cal.add(10, 11);
        this.checkDate(cal, p, "Thu Jan 01 11:00:00 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Sat Jan 31 23:59:59 JST 1970)");
        cal.add(2, 1);
        this.checkDate(cal, p, "Sun Feb 01 11:00:00 JST 1970", "1 (Sun Feb 01 00:00:00 JST 1970 - Sat Feb 28 23:59:59 JST 1970)");
        cal.add(1, 1);
        this.checkDate(cal, p, "Mon Feb 01 11:00:00 JST 1971", "13 (Mon Feb 01 00:00:00 JST 1971 - Sun Feb 28 23:59:59 JST 1971)");
    }

    public void testMonthBoundary() throws Exception {
        Calendar cal = this.getCalendar(this.timeZoneTokyo);
        Period p = new Period(PeriodUnit.MONTH, this.timeZoneTokyo);
        cal.add(2, 1);
        this.checkDate(cal, p, "Sun Feb 01 00:00:00 JST 1970", "1 (Sun Feb 01 00:00:00 JST 1970 - Sat Feb 28 23:59:59 JST 1970)");
        cal.add(13, -1);
        this.checkDate(cal, p, "Sat Jan 31 23:59:59 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Sat Jan 31 23:59:59 JST 1970)");
    }

    public void testYearBasic() throws Exception {
        Calendar cal = this.getCalendar(this.timeZoneTokyo);
        Period p = new Period(PeriodUnit.YEAR, this.timeZoneTokyo);
        this.checkDate(cal, p, "Thu Jan 01 00:00:00 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Thu Dec 31 23:59:59 JST 1970)");
        cal.add(10, 11);
        this.checkDate(cal, p, "Thu Jan 01 11:00:00 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Thu Dec 31 23:59:59 JST 1970)");
        cal.add(2, 1);
        this.checkDate(cal, p, "Sun Feb 01 11:00:00 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Thu Dec 31 23:59:59 JST 1970)");
        cal.add(1, 1);
        this.checkDate(cal, p, "Mon Feb 01 11:00:00 JST 1971", "1 (Fri Jan 01 00:00:00 JST 1971 - Fri Dec 31 23:59:59 JST 1971)");
    }

    public void testYearBoundary() throws Exception {
        Calendar cal = this.getCalendar(this.timeZoneTokyo);
        Period p = new Period(PeriodUnit.YEAR, this.timeZoneTokyo);
        cal.add(1, 1);
        this.checkDate(cal, p, "Fri Jan 01 00:00:00 JST 1971", "1 (Fri Jan 01 00:00:00 JST 1971 - Fri Dec 31 23:59:59 JST 1971)");
        cal.add(13, -1);
        this.checkDate(cal, p, "Thu Dec 31 23:59:59 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Thu Dec 31 23:59:59 JST 1970)");
    }

    public void testQuarterBasic() throws Exception {
        Calendar cal = this.getCalendar(this.timeZoneTokyo);
        Period p = new Period(PeriodUnit.QUARTER, this.timeZoneTokyo);
        this.checkDate(cal, p, "Thu Jan 01 00:00:00 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Tue Mar 31 23:59:59 JST 1970)");
        cal.add(10, 11);
        this.checkDate(cal, p, "Thu Jan 01 11:00:00 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Tue Mar 31 23:59:59 JST 1970)");
        cal.add(2, 1);
        this.checkDate(cal, p, "Sun Feb 01 11:00:00 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Tue Mar 31 23:59:59 JST 1970)");
        cal.add(1, 1);
        this.checkDate(cal, p, "Mon Feb 01 11:00:00 JST 1971", "4 (Fri Jan 01 00:00:00 JST 1971 - Wed Mar 31 23:59:59 JST 1971)");
    }

    public void testQuarterBoundary() throws Exception {
        Calendar cal = this.getCalendar(this.timeZoneTokyo);
        Period p = new Period(PeriodUnit.QUARTER, this.timeZoneTokyo);
        cal.add(2, 3);
        this.checkDate(cal, p, "Wed Apr 01 00:00:00 JST 1970", "1 (Wed Apr 01 00:00:00 JST 1970 - Tue Jun 30 23:59:59 JST 1970)");
        cal.add(13, -1);
        this.checkDate(cal, p, "Tue Mar 31 23:59:59 JST 1970", "0 (Thu Jan 01 00:00:00 JST 1970 - Tue Mar 31 23:59:59 JST 1970)");
    }

    public void testConversion() throws Exception {
        Period p = new Period(PeriodUnit.DAY, 12627, this.timeZoneTokyo);
        Date startDate = p.getStartDate();
        Date endDate = p.getEndDate();
        Period p1 = new Period(PeriodUnit.DAY, startDate, this.timeZoneTokyo);
        Period p2 = new Period(PeriodUnit.DAY, endDate, this.timeZoneTokyo);
        PeriodTest.assertEquals((int)p.getBucket(), (int)p1.getBucket());
        PeriodTest.assertEquals((int)p.getBucket(), (int)p2.getBucket());
    }

    public void testDaylightSavings() throws Exception {
        PeriodTest.assertEquals((String)TestUtils.formatDate(new Date(PeriodUnit.DAY.bucketToStartDate(12354, this.timeZoneTokyo)), this.timeZoneTokyo), (String)"Sat Oct 25 00:00:00 JST 2003");
        PeriodTest.assertEquals((String)TestUtils.formatDate(new Date(PeriodUnit.DAY.bucketToStartDate(12355, this.timeZoneTokyo)), this.timeZoneTokyo), (String)"Sun Oct 26 00:00:00 JST 2003");
        PeriodTest.assertEquals((String)TestUtils.formatDate(new Date(PeriodUnit.DAY.bucketToStartDate(12356, this.timeZoneTokyo)), this.timeZoneTokyo), (String)"Mon Oct 27 00:00:00 JST 2003");
        PeriodTest.assertEquals((String)TestUtils.formatDate(new Date(PeriodUnit.DAY.bucketToStartDate(12357, this.timeZoneTokyo)), this.timeZoneTokyo), (String)"Tue Oct 28 00:00:00 JST 2003");
        PeriodTest.assertEquals((String)TestUtils.formatDate(new Date(PeriodUnit.DAY.bucketToEndDate(12354, this.timeZoneTokyo)), this.timeZoneTokyo), (String)"Sat Oct 25 23:59:59 JST 2003");
        PeriodTest.assertEquals((String)TestUtils.formatDate(new Date(PeriodUnit.DAY.bucketToEndDate(12355, this.timeZoneTokyo)), this.timeZoneTokyo), (String)"Sun Oct 26 23:59:59 JST 2003");
        PeriodTest.assertEquals((String)TestUtils.formatDate(new Date(PeriodUnit.DAY.bucketToEndDate(12356, this.timeZoneTokyo)), this.timeZoneTokyo), (String)"Mon Oct 27 23:59:59 JST 2003");
        PeriodTest.assertEquals((String)TestUtils.formatDate(new Date(PeriodUnit.DAY.bucketToEndDate(12357, this.timeZoneTokyo)), this.timeZoneTokyo), (String)"Tue Oct 28 23:59:59 JST 2003");
        GregorianCalendar cal = new GregorianCalendar(this.timeZoneTokyo);
        cal.set(2003, 9, 25, 0, 0, 0);
        Period p1 = new Period(PeriodUnit.DAY, this.timeZoneTokyo);
        this.checkDate(cal, p1, "Sat Oct 25 00:00:00 JST 2003", "12354 (Sat Oct 25 00:00:00 JST 2003 - Sat Oct 25 23:59:59 JST 2003)");
        ((Calendar)cal).add(6, 1);
        this.checkDate(cal, p1, "Sun Oct 26 00:00:00 JST 2003", "12355 (Sun Oct 26 00:00:00 JST 2003 - Sun Oct 26 23:59:59 JST 2003)");
    }

    public void testTimeZonePeriods() throws Exception {
        Period periodSyd = new Period(PeriodUnit.DAY, 12627, this.timeZoneTokyo);
        Period periodPol = new Period(PeriodUnit.DAY, 12627, this.timeZoneEurope);
        PeriodTest.assertEquals((String)periodSyd.toString(), (String)"12627 (Sat Jul 24 00:00:00 JST 2004 - Sat Jul 24 23:59:59 JST 2004)");
        PeriodTest.assertEquals((String)periodPol.toString(), (String)"12627 (Sat Jul 24 00:00:00 CEST 2004 - Sat Jul 24 23:59:59 CEST 2004)");
    }

    public void testPeriodBug() throws BucketGraph.InvalidBucketException {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(2008, 4, 8, 12, 0);
        System.out.println(cal.getTime());
        Period day1 = new Period(PeriodUnit.DAY, cal.getTime(), this.timeZoneTokyo);
        System.out.println("Day 1: " + day1.toString());
        int bucket = day1.getBucket();
        Period day2 = new Period(PeriodUnit.DAY, bucket, this.timeZoneTokyo);
        System.out.println("Day 2: " + day2.toString());
        cal.set(1970, 6, 3, 12, 0);
        Period day3 = new Period(PeriodUnit.DAY, cal.getTime(), this.timeZoneTokyo);
        System.out.println("Day 3: " + day3.toString());
        bucket = day3.getBucket();
        Period day4 = new Period(PeriodUnit.DAY, bucket, this.timeZoneTokyo);
        System.out.println("Day 4: " + day4.toString());
        cal.set(2008, 4, 8, 12, 0);
        ((Calendar)cal).add(6, -187);
        System.out.println(cal.getTime());
        cal.set(1969, 11, 28, 0, 0);
        System.out.println(cal.getTime());
        ((Calendar)cal).add(6, 187);
        System.out.println(cal.getTime());
    }
}

