/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.Dir;
import com.atlassian.fisheye.bucket.InfinityDBConnector;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class CaseSensitivityTest {
    private String filename = "testdb.idb";
    private File dbFile = new File(FisheyeTestEnv.WORKSPACE_DIR, "output/" + this.filename);
    private InfinityDbHandle dbh = new InfinityDbHandle(this.dbFile);
    private InfinityDBConnector con;
    Date date1;
    Date date2;
    private TimeZone tzDefault = TimeZone.getTimeZone("Australia/Perth");

    @Before
    public void setUp() throws Exception {
        this.con = new InfinityDBConnector(this.dbh, "test", true, new CommonStringTables((UniqueStringTableFactory)this.dbh));
        this.con.deleteAllData();
        this.date1 = new Period(PeriodUnit.DAY, 1, this.tzDefault).getStartDate();
        this.date2 = new Period(PeriodUnit.DAY, 2, this.tzDefault).getStartDate();
    }

    @After
    public void tearDown() throws Exception {
        this.con.deleteAllData();
        this.dbh.close();
        this.dbFile.delete();
        Dir.setCacheDepth((int)6);
    }

    @Test
    public void testCaseSensitive() throws DbException, IOException {
        BucketGraph bucketGraph = new BucketGraph(this.dbh, "test", true, new CommonStringTables((UniqueStringTableFactory)this.dbh), null);
        Dir.setCacheDepth((int)-1);
        this.con.addDirToIndex(Path.ROOT);
        this.con.addDirToIndex(new Path((CharSequence)"Test"));
        this.con.addFileToIndex(new Path((CharSequence)"Test/Test.java"));
        this.con.addDirToIndex(new Path((CharSequence)"test"));
        this.con.addFileToIndex(new Path((CharSequence)"test/Test.java"));
        this.con.addFileToIndex(new Path((CharSequence)"test/test.java"));
        bucketGraph.addRevision(new Path((CharSequence)"Test/Test.java"), "TRUNK", this.date1, 10, "Anna", false, 0L);
        bucketGraph.addRevision(new Path((CharSequence)"test/Test.java"), "TRUNK", this.date1, 7, "Anna", false, 0L);
        bucketGraph.addRevision(new Path((CharSequence)"test/test.java"), "TRUNK", this.date1, 22, "Anna", false, 0L);
        Assert.assertEquals((String)bucketGraph.toStringFull(), (String)"\nTest/Test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[10,1] \nTest/Test.java data [TRUNK, .java, anna] 0-0=[10,1] \nTest/Test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[10,1] \nTest/Test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[10,1] \ntest/Test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[7,1] \ntest/Test.java data [TRUNK, .java, anna] 0-0=[7,1] \ntest/Test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[7,1] \ntest/Test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[7,1] \ntest/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[22,1] \ntest/test.java data [TRUNK, .java, anna] 0-0=[22,1] \ntest/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[22,1] \ntest/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[22,1] ");
    }

    @Test
    public void testCaseInsensitive() throws DbException, IOException {
        BucketGraph bucketGraph = new BucketGraph(this.dbh, "test", false, new CommonStringTables((UniqueStringTableFactory)this.dbh), null);
        Dir.setCacheDepth((int)-1);
        this.con.addDirToIndex(Path.ROOT);
        this.con.addDirToIndex(new Path((CharSequence)"Test"));
        this.con.addFileToIndex(new Path((CharSequence)"Test/Test.java"));
        this.con.addDirToIndex(new Path((CharSequence)"test"));
        this.con.addFileToIndex(new Path((CharSequence)"test/Test.java"));
        this.con.addFileToIndex(new Path((CharSequence)"test/test.java"));
        bucketGraph.addRevision(new Path((CharSequence)"Test/Test.java"), "TRUNK", this.date1, 10, "Anna", false, 0L);
        bucketGraph.addRevision(new Path((CharSequence)"test/Test.java"), "TRUNK", this.date1, 7, "Anna", false, 0L);
        bucketGraph.addRevision(new Path((CharSequence)"test/test.java"), "TRUNK", this.date1, 22, "Anna", false, 0L);
        Assert.assertEquals((String)bucketGraph.toStringFull(), (String)"\ntest/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[39,3] \ntest/test.java data [TRUNK, .java, anna] 0-0=[39,3] \ntest/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[39,3] \ntest/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[39,3] ");
    }
}

