/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.CalculatedBucketGraphXY;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.vis.LocChartParams;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class CalculatedBucketGraphXYTest
extends TestCase {
    private final TimeZone tzDefault = TimeZone.getTimeZone("Australia/Perth");
    private final Date endDate = new GregorianCalendar(2012, 11, 1).getTime();
    private final Period endPeriod = new Period(this.endDate, this.tzDefault);
    private final int bucket_0 = this.endPeriod.getBucket();
    private final int bucket_1 = this.bucket_0 - 1;
    private final int bucket_3 = this.bucket_0 - 3;
    private final int bucket_4 = this.bucket_0 - 4;
    private PeriodUnit periodUnit = PeriodUnit.DAY;
    private TimeZone timeZone = this.tzDefault;

    public void testGraphMaxPlus1() throws BucketGraph.InvalidBucketException, DbException {
        BucketDataCollectionTotalled collection = new BucketDataCollectionTotalled(this.periodUnit, this.timeZone);
        collection.add((BucketData)new BucketDataTotalled("D", this.bucket_0, 100, 1, 100, 1));
        collection.add((BucketData)new BucketDataTotalled("B", this.bucket_0, 105, 1, 105, 1));
        collection.add((BucketData)new BucketDataTotalled("E", this.bucket_0, 109, 1, 109, 1));
        collection.add((BucketData)new BucketDataTotalled("C", this.bucket_0, 105, 1, 105, 1));
        CalculatedBucketGraphXYTest.assertEquals((String)collection.toString(), (String)("{D={0={" + this.bucket_0 + "=[100(+100),1(+1)]}}, " + "B={0={" + this.bucket_0 + "=[105(+105),1(+1)]}}, " + "E={0={" + this.bucket_0 + "=[109(+109),1(+1)]}}, " + "C={0={" + this.bucket_0 + "=[105(+105),1(+1)]}}}"));
        CalculatedBucketGraphXY graph = new CalculatedBucketGraphXY(collection, true, PeriodUnit.DAY, "repo", 3, BreakdownOption.NONE, false);
        LinkedHashMap<String, Map<Long, Integer>> expectedResult = new LinkedHashMap<String, Map<Long, Integer>>();
        LinkedHashMap<Long, Integer> result_e = new LinkedHashMap<Long, Integer>();
        result_e.put(this.endPeriod.getStartTime() - 1L, 0);
        result_e.put(this.endPeriod.getEndTime(), 109);
        expectedResult.put("E-0", result_e);
        LinkedHashMap<Long, Integer> result_b = new LinkedHashMap<Long, Integer>();
        result_b.put(this.endPeriod.getStartTime() - 1L, 0);
        result_b.put(this.endPeriod.getEndTime(), 105);
        expectedResult.put("B-0", result_b);
        LinkedHashMap<Long, Integer> result_other = new LinkedHashMap<Long, Integer>();
        result_other.put(this.endPeriod.getStartTime() - 1L, 0);
        result_other.put(this.endPeriod.getEndTime(), 205);
        expectedResult.put("Other-0", result_other);
        this.assertExpectedResult(graph.getLinecountCollection(), expectedResult);
    }

    public void testGraphMax() throws BucketGraph.InvalidBucketException, DbException {
        BucketDataCollectionTotalled collection = new BucketDataCollectionTotalled(this.periodUnit, this.timeZone);
        collection.add((BucketData)new BucketDataTotalled("D", this.bucket_0, 100, 1, 100, 1));
        collection.add((BucketData)new BucketDataTotalled("B", this.bucket_0, 105, 1, 105, 1));
        collection.add((BucketData)new BucketDataTotalled("E", this.bucket_0, 109, 1, 109, 1));
        CalculatedBucketGraphXYTest.assertEquals((String)collection.toString(), (String)("{D={0={" + this.bucket_0 + "=[100(+100),1(+1)]}}, " + "B={0={" + this.bucket_0 + "=[105(+105),1(+1)]}}, " + "E={0={" + this.bucket_0 + "=[109(+109),1(+1)]}}}"));
        CalculatedBucketGraphXY graph = new CalculatedBucketGraphXY(collection, true, PeriodUnit.DAY, "repo", 3, BreakdownOption.NONE, false);
        LinkedHashMap<String, Map<Long, Integer>> expectedResult = new LinkedHashMap<String, Map<Long, Integer>>();
        LinkedHashMap<Long, Integer> result_e = new LinkedHashMap<Long, Integer>();
        result_e.put(this.endPeriod.getStartTime() - 1L, 0);
        result_e.put(this.endPeriod.getEndTime(), 109);
        expectedResult.put("E-0", result_e);
        LinkedHashMap<Long, Integer> result_b = new LinkedHashMap<Long, Integer>();
        result_b.put(this.endPeriod.getStartTime() - 1L, 0);
        result_b.put(this.endPeriod.getEndTime(), 105);
        expectedResult.put("B-0", result_b);
        LinkedHashMap<Long, Integer> result_other = new LinkedHashMap<Long, Integer>();
        result_other.put(this.endPeriod.getStartTime() - 1L, 0);
        result_other.put(this.endPeriod.getEndTime(), 100);
        expectedResult.put("D-0", result_other);
        this.assertExpectedResult(graph.getLinecountCollection(), expectedResult);
    }

    public void testGraphLessThanMax() throws BucketGraph.InvalidBucketException, DbException {
        BucketDataCollectionTotalled collection = new BucketDataCollectionTotalled(this.periodUnit, this.timeZone);
        collection.add((BucketData)new BucketDataTotalled("D", this.bucket_0, 100, 1, 100, 1));
        collection.add((BucketData)new BucketDataTotalled("B", this.bucket_0, 105, 1, 105, 1));
        CalculatedBucketGraphXYTest.assertEquals((String)collection.toString(), (String)("{D={0={" + this.bucket_0 + "=[100(+100),1(+1)]}}" + ", B={0={" + this.bucket_0 + "=[105(+105),1(+1)]}}}"));
        CalculatedBucketGraphXY graph = new CalculatedBucketGraphXY(collection, true, PeriodUnit.DAY, "repo", 3, BreakdownOption.NONE, false);
        LinkedHashMap<String, Map<Long, Integer>> expectedResult = new LinkedHashMap<String, Map<Long, Integer>>();
        LinkedHashMap<Long, Integer> result_b = new LinkedHashMap<Long, Integer>();
        result_b.put(this.endPeriod.getStartTime() - 1L, 0);
        result_b.put(this.endPeriod.getEndTime(), 105);
        expectedResult.put("B-0", result_b);
        LinkedHashMap<Long, Integer> result_other = new LinkedHashMap<Long, Integer>();
        result_other.put(this.endPeriod.getStartTime() - 1L, 0);
        result_other.put(this.endPeriod.getEndTime(), 100);
        expectedResult.put("D-0", result_other);
        this.assertExpectedResult(graph.getLinecountCollection(), expectedResult);
    }

    public void testGraphReplaceKeyMax() throws BucketGraph.InvalidBucketException, DbException {
        BucketDataCollectionTotalled collection = new BucketDataCollectionTotalled(this.periodUnit, this.timeZone);
        collection.add((BucketData)new BucketDataTotalled("D", this.bucket_0, 100, 1, 100, 1));
        collection.add((BucketData)new BucketDataTotalled("__NO_AUTHOR__", this.bucket_0, 105, 1, 105, 1));
        collection.add((BucketData)new BucketDataTotalled("__NO_EXTENSION__", this.bucket_0, 109, 1, 109, 1));
        CalculatedBucketGraphXYTest.assertEquals((String)collection.toString(), (String)("{D={0={" + this.bucket_0 + "=[100(+100),1(+1)]}}, " + "__NO_AUTHOR__={0={" + this.bucket_0 + "=[105(+105),1(+1)]}}, " + "__NO_EXTENSION__={0={" + this.bucket_0 + "=[109(+109),1(+1)]}}}"));
        CalculatedBucketGraphXY graph = new CalculatedBucketGraphXY(collection, true, PeriodUnit.DAY, "repo", 3, BreakdownOption.NONE, false);
        LinkedHashMap<String, Map<Long, Integer>> expectedResult = new LinkedHashMap<String, Map<Long, Integer>>();
        LinkedHashMap<Long, Integer> result_e = new LinkedHashMap<Long, Integer>();
        result_e.put(this.endPeriod.getStartTime() - 1L, 0);
        result_e.put(this.endPeriod.getEndTime(), 109);
        expectedResult.put("None-0", result_e);
        LinkedHashMap<Long, Integer> result_b = new LinkedHashMap<Long, Integer>();
        result_b.put(this.endPeriod.getStartTime() - 1L, 0);
        result_b.put(this.endPeriod.getEndTime(), 105);
        expectedResult.put("No author-0", result_b);
        LinkedHashMap<Long, Integer> result_other = new LinkedHashMap<Long, Integer>();
        result_other.put(this.endPeriod.getStartTime() - 1L, 0);
        result_other.put(this.endPeriod.getEndTime(), 100);
        expectedResult.put("D-0", result_other);
        this.assertExpectedResult(graph.getLinecountCollection(), expectedResult);
    }

    public void testGraphReplaceKeyMaxPlus2() throws BucketGraph.InvalidBucketException, DbException {
        BucketDataCollectionTotalled collection = new BucketDataCollectionTotalled(this.periodUnit, this.timeZone);
        collection.add((BucketData)new BucketDataTotalled("D", this.bucket_0, 100, 1, 100, 1));
        collection.add((BucketData)new BucketDataTotalled("__NO_AUTHOR__", this.bucket_0, 105, 1, 105, 1));
        collection.add((BucketData)new BucketDataTotalled("__NO_EXTENSION__", this.bucket_0, 109, 1, 109, 1));
        collection.add((BucketData)new BucketDataTotalled("B", this.bucket_0, 105, 1, 105, 1));
        collection.add((BucketData)new BucketDataTotalled("E", this.bucket_0, 109, 1, 109, 1));
        CalculatedBucketGraphXYTest.assertEquals((String)collection.toString(), (String)("{D={0={" + this.bucket_0 + "=[100(+100),1(+1)]}}, " + "__NO_AUTHOR__={0={" + this.bucket_0 + "=[105(+105),1(+1)]}}, " + "__NO_EXTENSION__={0={" + this.bucket_0 + "=[109(+109),1(+1)]}}, " + "B={0={" + this.bucket_0 + "=[105(+105),1(+1)]}}, " + "E={0={" + this.bucket_0 + "=[109(+109),1(+1)]}}}"));
        CalculatedBucketGraphXY graph = new CalculatedBucketGraphXY(collection, true, PeriodUnit.DAY, "repo", 3, BreakdownOption.NONE, false);
        LinkedHashMap<String, Map<Long, Integer>> expectedResult = new LinkedHashMap<String, Map<Long, Integer>>();
        LinkedHashMap<Long, Integer> result_e = new LinkedHashMap<Long, Integer>();
        result_e.put(this.endPeriod.getStartTime() - 1L, 0);
        result_e.put(this.endPeriod.getEndTime(), 109);
        expectedResult.put("None-0", result_e);
        LinkedHashMap<Long, Integer> result_b = new LinkedHashMap<Long, Integer>();
        result_b.put(this.endPeriod.getStartTime() - 1L, 0);
        result_b.put(this.endPeriod.getEndTime(), 109);
        expectedResult.put("E-0", result_b);
        LinkedHashMap<Long, Integer> result_other = new LinkedHashMap<Long, Integer>();
        result_other.put(this.endPeriod.getStartTime() - 1L, 0);
        result_other.put(this.endPeriod.getEndTime(), 310);
        expectedResult.put("Other-0", result_other);
        this.assertExpectedResult(graph.getLinecountCollection(), expectedResult);
    }

    public void testDatesOutside() throws DbException, BucketGraph.InvalidBucketException {
        BucketDataCollectionTotalled collection = new BucketDataCollectionTotalled(this.periodUnit, this.timeZone);
        collection.add((BucketData)new BucketDataTotalled("A", this.bucket_4, 10, 2, 10, 2));
        collection.add((BucketData)new BucketDataTotalled("A", this.bucket_3, 5, 1, 15, 3));
        collection.add((BucketData)new BucketDataTotalled("A", this.bucket_1, -1, 2, 14, 5));
        collection.add((BucketData)new BucketDataTotalled("A", this.bucket_0, 1, 4, 15, 9));
        CalculatedBucketGraphXYTest.assertEquals((String)collection.toString(), (String)("{A={0={" + this.bucket_4 + "=[10(+10),2(+2)], " + this.bucket_3 + "=[15(+5),3(+1)], " + this.bucket_1 + "=[14(-1),5(+2)], " + this.bucket_0 + "=[15(+1),9(+4)]}}}"));
        LocChartParams params = new LocChartParams();
        params.setDimension(Integer.valueOf(200), Integer.valueOf(200));
        Period period = new Period(PeriodUnit.DAY, this.bucket_1, this.tzDefault);
        CalculatedBucketGraphXY graph = new CalculatedBucketGraphXY(collection, true, period.getStartDate(), period.getEndDate(), "repo", params, 10, false, null, BreakdownOption.NONE, false, false);
        Period p = new Period(this.endDate, this.tzDefault);
        p.setToNextBucket(-4);
        LinkedHashMap<String, Map<Long, Integer>> expectedResult = new LinkedHashMap<String, Map<Long, Integer>>();
        LinkedHashMap<Long, Integer> result_e = new LinkedHashMap<Long, Integer>();
        result_e.put(p.getStartTime() - 1L, 0);
        result_e.put(p.getEndTime(), 10);
        p.setToNextBucket(1);
        result_e.put(p.getEndTime(), 15);
        p.setToNextBucket(1);
        result_e.put(p.getEndTime(), 15);
        p.setToNextBucket(1);
        result_e.put(p.getEndTime(), 14);
        p.setToNextBucket(1);
        result_e.put(p.getEndTime(), 15);
        expectedResult.put("A-0", result_e);
        this.assertExpectedResult(graph.getLinecountCollection(), expectedResult);
        graph = new CalculatedBucketGraphXY(collection, true, period.getStartDate(), period.getEndDate(), "repo", params, 10, false, null, BreakdownOption.NONE, false, false);
        this.assertExpectedResult(graph.getLinecountCollection(), expectedResult);
        graph = new CalculatedBucketGraphXY(collection, true, new Date(0L), this.endDate, "repo", params, 10, false, null, BreakdownOption.NONE, false, false);
        Period p2 = new Period(PeriodUnit.YEAR, this.endDate, this.tzDefault);
        expectedResult = new LinkedHashMap();
        result_e = new LinkedHashMap();
        result_e.put(p2.getStartTime() - 1L, 0);
        result_e.put(p2.getEndTime(), 15);
        expectedResult.put("A-0", result_e);
        this.assertExpectedResult(graph.getLinecountCollection(), expectedResult);
    }

    public void testBadData() throws DbException, BucketGraph.InvalidBucketException {
        BucketDataCollectionTotalled collection = new BucketDataCollectionTotalled(PeriodUnit.DAY, this.tzDefault);
        LocChartParams params = new LocChartParams();
        params.setDimension(Integer.valueOf(200), Integer.valueOf(200));
        CalculatedBucketGraphXY graph = new CalculatedBucketGraphXY(collection, true, new Date(0L), this.endDate, "repo", params, 10, false, null, BreakdownOption.NONE, false, false);
        this.assertExpectedResult(graph.getLinecountCollection(), Collections.emptyMap());
        graph = new CalculatedBucketGraphXY(collection, true, null, null, "repo", params, 10, false, null, BreakdownOption.NONE, false, false);
        this.assertExpectedResult(graph.getLinecountCollection(), Collections.emptyMap());
    }

    private void assertExpectedResult(XYSeriesCollection lc, Map<String, Map<Long, Integer>> expectedResult) {
        CalculatedBucketGraphXYTest.assertEquals((int)lc.getSeriesCount(), (int)expectedResult.size());
        for (Map.Entry<String, Map<Long, Integer>> e : expectedResult.entrySet()) {
            XYSeries series = lc.getSeries((Comparable)((Object)e.getKey()));
            Map<Long, Integer> expectedValues = e.getValue();
            for (Map.Entry<Long, Integer> e2 : expectedValues.entrySet()) {
                int i = series.indexOf((Number)e2.getKey());
                CalculatedBucketGraphXYTest.assertTrue((i >= 0 ? 1 : 0) != 0);
                CalculatedBucketGraphXYTest.assertEquals((int)e2.getValue(), (int)series.getY(i).intValue());
            }
        }
    }
}

