/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.CalculatedBucketGraphPie;
import com.cenqua.fisheye.rep.DbException;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Date;
import junit.framework.TestCase;
import org.jfree.data.general.DefaultPieDataset;

public class CalculatedBucketGraphPieTest
extends TestCase {
    private final int maxItems = 10;

    public void testPieData() throws DbException {
        Object2IntLinkedOpenHashMap pieValues = new Object2IntLinkedOpenHashMap();
        pieValues.put((Object)"A", 105);
        pieValues.put((Object)"B", 101);
        pieValues.put((Object)"D", 102);
        pieValues.put((Object)"C", 102);
        pieValues.put((Object)"E", 104);
        pieValues.put((Object)"F", 109);
        pieValues.put((Object)"G", 106);
        CalculatedBucketGraphPie graph = new CalculatedBucketGraphPie(new Date(System.currentTimeMillis()), (Object2IntMap)pieValues, 10, BreakdownOption.NONE, false);
        CalculatedBucketGraphPieTest.assertEquals((String)this.graphToString(graph), (String)"7 data items: F=109.0 G=106.0 A=105.0 E=104.0 C=102.0 D=102.0 B=101.0 ");
    }

    public void testPieDataSmallPieces() throws DbException {
        Object2IntLinkedOpenHashMap pieValues = new Object2IntLinkedOpenHashMap();
        pieValues.put((Object)"A", 105);
        pieValues.put((Object)"B", 101);
        pieValues.put((Object)"C", 102);
        pieValues.put((Object)"D", 102);
        pieValues.put((Object)"E", 104);
        pieValues.put((Object)"F", 109);
        pieValues.put((Object)"G", 106);
        pieValues.put((Object)"H", 10);
        pieValues.put((Object)"I", 2);
        CalculatedBucketGraphPie graph = new CalculatedBucketGraphPie(new Date(System.currentTimeMillis()), (Object2IntMap)pieValues, 10, BreakdownOption.NONE, false);
        CalculatedBucketGraphPieTest.assertEquals((String)this.graphToString(graph), (String)"8 data items: F=109.0 G=106.0 A=105.0 E=104.0 C=102.0 D=102.0 B=101.0 Other=12.0 ");
    }

    public void testPieDataExactPieces() throws DbException {
        Object2IntLinkedOpenHashMap pieValues = new Object2IntLinkedOpenHashMap();
        pieValues.put((Object)"A", 105);
        pieValues.put((Object)"B", 101);
        pieValues.put((Object)"C", 102);
        pieValues.put((Object)"D", 102);
        pieValues.put((Object)"E", 104);
        pieValues.put((Object)"F", 109);
        pieValues.put((Object)"G", 106);
        pieValues.put((Object)"H", 101);
        pieValues.put((Object)"I", 103);
        pieValues.put((Object)"J", 107);
        CalculatedBucketGraphPie graph = new CalculatedBucketGraphPie(new Date(System.currentTimeMillis()), (Object2IntMap)pieValues, 10, BreakdownOption.NONE, false);
        CalculatedBucketGraphPieTest.assertEquals((String)this.graphToString(graph), (String)"10 data items: F=109.0 J=107.0 G=106.0 A=105.0 E=104.0 I=103.0 C=102.0 D=102.0 B=101.0 H=101.0 ");
    }

    public void testPieDataTooManyPieces() throws DbException {
        Object2IntLinkedOpenHashMap pieValues = new Object2IntLinkedOpenHashMap();
        pieValues.put((Object)"A", 105);
        pieValues.put((Object)"B", 101);
        pieValues.put((Object)"C", 102);
        pieValues.put((Object)"D", 102);
        pieValues.put((Object)"E", 104);
        pieValues.put((Object)"F", 109);
        pieValues.put((Object)"G", 106);
        pieValues.put((Object)"H", 101);
        pieValues.put((Object)"I", 103);
        pieValues.put((Object)"J", 107);
        pieValues.put((Object)"K", 108);
        CalculatedBucketGraphPie graph = new CalculatedBucketGraphPie(new Date(System.currentTimeMillis()), (Object2IntMap)pieValues, 10, BreakdownOption.NONE, false);
        CalculatedBucketGraphPieTest.assertEquals((String)this.graphToString(graph), (String)"10 data items: F=109.0 K=108.0 J=107.0 G=106.0 A=105.0 E=104.0 I=103.0 C=102.0 D=102.0 Other=202.0 ");
    }

    public void testPieDataTooManySmallPieces() throws DbException {
        Object2IntLinkedOpenHashMap pieValues = new Object2IntLinkedOpenHashMap();
        pieValues.put((Object)"A", 105);
        pieValues.put((Object)"B", 101);
        pieValues.put((Object)"C", 102);
        pieValues.put((Object)"D", 102);
        pieValues.put((Object)"E", 104);
        pieValues.put((Object)"F", 109);
        pieValues.put((Object)"G", 106);
        pieValues.put((Object)"H", 10);
        pieValues.put((Object)"I", 2);
        pieValues.put((Object)"J", 5);
        pieValues.put((Object)"K", 7);
        pieValues.put((Object)"L", 20);
        CalculatedBucketGraphPie graph = new CalculatedBucketGraphPie(new Date(System.currentTimeMillis()), (Object2IntMap)pieValues, 10, BreakdownOption.NONE, false);
        CalculatedBucketGraphPieTest.assertEquals((String)this.graphToString(graph), (String)"8 data items: F=109.0 G=106.0 A=105.0 E=104.0 C=102.0 D=102.0 B=101.0 Other=44.0 ");
    }

    private String graphToString(CalculatedBucketGraphPie graph) {
        DefaultPieDataset data = graph.getPieData();
        StringBuilder sb = new StringBuilder();
        sb.append(data.getItemCount()).append(" data items: ");
        for (int i = 0; i < data.getItemCount(); ++i) {
            sb.append(data.getKey(i)).append("=").append(data.getValue(i)).append(" ");
        }
        return sb.toString();
    }
}

