/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.Dir;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.ctl.NativeLibrarySetup;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.util.Disposer;
import java.io.File;
import java.util.Arrays;
import org.apache.log4j.Level;

public class BucketTestPerf {
    private String repName = "tiny";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doSlurp() {
        Disposer.pushThreadInstance();
        try {
            File appHome = new File(FisheyeTestEnv.WORKSPACE_DIR, "output/dist");
            File instHome = new File(FisheyeTestEnv.WORKSPACE_DIR, "/output/dist_cwd/../dist_inst");
            AppConfig.overrideAppHome((File)appHome, (File)instHome);
            File cfgFile = new File(AppConfig.getInstanceDir(), "config.xml").getAbsoluteFile();
            NativeLibrarySetup.setup();
            RootConfig rootConfig = AppConfig.getsConfig();
            rootConfig.load(cfgFile);
            rootConfig.loadLicense();
            rootConfig.start();
            RepositoryManager repositoryManager = rootConfig.getRepositoryManager();
            RepositoryHandle rep = repositoryManager.getRepository(this.repName);
            rep.setDisableBackgroundUpdaterOnInit(true);
            String ctlBind = rootConfig.getControlBind();
            repositoryManager.runRepository(this.repName);
            RepositoryEngine engine = rep.acquireEngine();
            long t0 = System.currentTimeMillis();
            engine.slurp();
            long t1 = System.currentTimeMillis();
            rep.stop();
            repositoryManager.fullShutdown();
            Disposer.popThreadInstance();
            long l = t1 - t0;
            return l;
        }
        catch (Exception e) {
            Logs.APP_LOG.warn((Object)"Exception:", (Throwable)e);
        }
        finally {
            Disposer.popThreadInstance();
        }
        return 0L;
    }

    private void doBucketSlurp(String repname, InfinityDbHandle dbh) throws DbException {
    }

    public static void main(String[] args) {
        BucketTestPerf tester = new BucketTestPerf();
        tester.runTest();
    }

    public void runTest() {
        int i;
        Logs.APP_LOG.setLevel(Level.OFF);
        File data = new File("/home/abuttfield/code/fisheye/output/dist_inst/var/cache/" + this.repName + "/");
        int runs = 1;
        long[][] result = new long[runs][6];
        for (i = 0; i < runs; ++i) {
            int j = -1;
            Dir.setCacheDepth((int)5);
            this.deleteDir(data);
            long tmp = this.doSlurp();
            result[i][j++] = tmp;
            this.deleteDir(data);
            tmp = this.doSlurp();
            result[i][j++] = tmp;
            Dir.setCacheDepth((int)Integer.MAX_VALUE);
            this.deleteDir(data);
            tmp = this.doSlurp();
            result[i][j++] = tmp;
            this.deleteDir(data);
            tmp = this.doSlurp();
            result[i][j++] = tmp;
            Dir.setCacheDepth((int)Integer.MIN_VALUE);
            this.deleteDir(data);
            tmp = this.doSlurp();
            result[i][j++] = tmp;
            this.deleteDir(data);
            tmp = this.doSlurp();
            result[i][j++] = tmp;
            System.out.println(Arrays.toString(result[i]));
            String[] resultStrings = new String[6];
            double[] average = new double[6];
            for (j = 0; j <= i; ++j) {
                for (int k = 0; k < 6; ++k) {
                    int n = k;
                    average[n] = average[n] + (double)(result[j][k] / (long)(i + 1));
                    if (i == 0) {
                        resultStrings[k] = "" + result[j][k];
                        continue;
                    }
                    if (j == 0) {
                        resultStrings[k] = " {" + result[j][k] + ", ";
                        continue;
                    }
                    if (j == i) {
                        resultStrings[k] = resultStrings[k] + result[j][k] + "}";
                        resultStrings[k] = average[k] + resultStrings[k];
                        continue;
                    }
                    resultStrings[k] = resultStrings[k] + result[j][k] + ", ";
                }
            }
            j = -1;
            System.out.println("Medium subdir caching");
            System.out.println("\tWith buckets: " + resultStrings[j++]);
            System.out.println("\tWithout buckets: " + resultStrings[j++]);
            System.out.println("Maximum subdir caching");
            System.out.println("\tWith buckets: " + resultStrings[j++]);
            System.out.println("\tWithout buckets: " + resultStrings[j++]);
            System.out.println("Minimum subdir caching");
            System.out.println("\tWith buckets: " + resultStrings[j++]);
            System.out.println("\tWithout buckets: " + resultStrings[j++]);
        }
        for (i = 0; i < runs; ++i) {
            System.out.println(Arrays.toString(result[i]));
        }
    }

    private void deleteDir(File dir) {
        String[] files = dir.list();
        dir.getAbsoluteFile();
        File parent = dir.getParentFile();
        if (files != null) {
            for (String filename : dir.list()) {
                File file = new File(dir, filename);
                if (file.isDirectory()) {
                    this.deleteDir(file);
                    continue;
                }
                file.delete();
            }
        }
        dir.delete();
    }
}

