/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.CalculatedBucketGraphXY;
import com.atlassian.fisheye.bucket.Dir;
import com.atlassian.fisheye.bucket.InfinityDBConnector;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.atlassian.fisheye.bucket.TestUtils;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.vis.ChartLocation;
import com.cenqua.fisheye.vis.LocChartParams;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class BucketGraphTest {
    private String filename = "testdb.idb";
    private File dbFile = new File(FisheyeTestEnv.WORKSPACE_DIR, "output/" + this.filename);
    private InfinityDbHandle dbh = new InfinityDbHandle(this.dbFile);
    private InfinityDBConnector con;
    private TimeZone tzDefault = TimeZone.getTimeZone("PST");
    BucketGraph bucketGraph;
    Date date1;
    Date date2;
    private InfinityDbHandle dbHandle;
    boolean caseSensitive = true;

    @Before
    public void setUp() throws Exception {
        if (this.dbFile.exists() && !this.dbFile.delete()) {
            throw new RuntimeException("Unable to delete Database file: " + this.dbFile.getAbsolutePath());
        }
        this.dbHandle = new InfinityDbHandle(this.dbFile);
        this.bucketGraph = new BucketGraph(this.dbHandle, "test", this.caseSensitive, new CommonStringTables((UniqueStringTableFactory)this.dbHandle), null);
        this.con = new InfinityDBConnector(this.dbHandle, "test", this.caseSensitive, new CommonStringTables((UniqueStringTableFactory)this.dbHandle));
    }

    @After
    public void tearDown() throws Exception {
        this.dbHandle.close();
        this.bucketGraph = null;
        if (this.dbFile.exists() && !this.dbFile.delete()) {
            throw new RuntimeException("Unable to delete Database file: " + this.dbFile.getAbsolutePath());
        }
        Dir.setCacheDepth((int)6);
    }

    @Test
    public void testChoosePeriod() throws Exception {
        for (int i = 1; i < 15000; ++i) {
            Period periodStart = new Period(PeriodUnit.DAY, 1, this.tzDefault);
            Period periodEnd = new Period(PeriodUnit.DAY, i, this.tzDefault);
            LocChartParams params = ChartLocation.SIDEBAR.getParams();
            params.setMaxBarWidth(3);
            params.setDimension(Integer.valueOf(400), Integer.valueOf(400));
            PeriodUnit periodUnit = CalculatedBucketGraphXY.choosePeriod((Date)periodStart.getStartDate(), (Date)periodEnd.getEndDate(), (LocChartParams)params);
            if (i < 124) {
                Assert.assertEquals((String)(i + ""), (Object)periodUnit, (Object)PeriodUnit.DAY);
                continue;
            }
            if (i < 862) {
                Assert.assertEquals((String)(i + ""), (Object)periodUnit, (Object)PeriodUnit.WEEK);
                continue;
            }
            if (i < 3741) {
                Assert.assertEquals((String)(i + ""), (Object)periodUnit, (Object)PeriodUnit.MONTH);
                continue;
            }
            if (i < 11233) {
                Assert.assertEquals((String)(i + ""), (Object)periodUnit, (Object)PeriodUnit.QUARTER);
                continue;
            }
            Assert.assertEquals((String)(i + ""), (Object)periodUnit, (Object)PeriodUnit.YEAR);
        }
    }

    @Test
    public void testDates() throws DbException, BucketGraph.InvalidBucketException {
        GregorianCalendar cal = new GregorianCalendar(this.tzDefault);
        Date date1 = this.getDate(cal, 1970, 0, 1);
        Date date2 = this.getDate(cal, 1970, 0, 2);
        Date date3 = this.getDate(cal, 1970, 3, 1);
        Assert.assertEquals((String)TestUtils.formatDate(date1, this.tzDefault), (String)"Thu Jan 01 00:00:00 PST 1970");
        Assert.assertEquals((String)TestUtils.formatDate(date2, this.tzDefault), (String)"Fri Jan 02 00:00:00 PST 1970");
        Assert.assertEquals((String)TestUtils.formatDate(date3, this.tzDefault), (String)"Wed Apr 01 00:00:00 PST 1970");
        Period period1 = new Period(PeriodUnit.DAY, date1, this.tzDefault);
        Period period2 = new Period(PeriodUnit.DAY, date2, this.tzDefault);
        Period period3 = new Period(PeriodUnit.DAY, date3, this.tzDefault);
        Pair dates = CalculatedBucketGraphXY.calculateDates(null, null, (int)period1.getBucket(), (int)period3.getBucket(), (TimeZone)this.tzDefault, (boolean)false);
        Assert.assertEquals((String)TestUtils.formatDate((Date)dates.getFirst(), this.tzDefault), (String)"Thu Jan 01 00:00:00 PST 1970");
        dates = CalculatedBucketGraphXY.calculateDates(null, null, (int)period1.getBucket(), (int)period3.getBucket(), (TimeZone)this.tzDefault, (boolean)false);
        Assert.assertEquals((String)TestUtils.formatDate((Date)dates.getFirst(), this.tzDefault), (String)"Thu Jan 01 00:00:00 PST 1970");
    }

    private Date getDate(Calendar cal, int year, int month, int day) {
        cal.set(year, month, day, 0, 0, 0);
        return cal.getTime();
    }

    @Test
    public void testEarlyDate() throws DbException {
        GregorianCalendar cal = new GregorianCalendar(this.tzDefault);
        Date date1 = this.getDate(cal, 1970, 0, 2);
        Date date2 = this.getDate(cal, 2010, 4, 20);
        this.bucketGraph.addRevision(Path.ROOT, "b", date1, 10, "a", true, 0L);
        this.bucketGraph.addRevision(Path.ROOT, "b", date2, -5, "a", true, 0L);
        this.bucketGraph.addRevision(Path.ROOT, null, date1, 10, "a", true, 0L);
        this.bucketGraph.addRevision(Path.ROOT, null, date2, -5, "a", true, 0L);
        ParameterSetQuery parameterSetQuery = new ParameterSetQuery();
        CalculatedBucketGraphXY graph = this.bucketGraph.getXYSeries(parameterSetQuery, null, null, ChartLocation.MAIN.getParams(), 10, false, null);
        parameterSetQuery.setBranch("b");
        graph = this.bucketGraph.getXYSeries(parameterSetQuery, null, null, ChartLocation.MAIN.getParams(), 10, false, null);
    }
}

