/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketDataDiffs;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.Dir;
import com.atlassian.fisheye.bucket.InfinityDBConnector;
import com.atlassian.fisheye.bucket.ParameterSetInsertion;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.atlassian.fisheye.bucket.Period;
import com.atlassian.fisheye.bucket.PeriodUnit;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class BucketDataTest {
    private BucketGraph dataCollector;
    private InfinityDBConnector con;
    private Date date1;
    private Date date2;
    private InfinityDbHandle dbHandle;
    private final File dbFile = new File(FisheyeTestEnv.WORKSPACE_DIR, "output/testdb.idb");
    private final TimeZone tzDefault = TimeZone.getTimeZone("Australia/Perth");
    private final boolean caseSensitive = true;

    @Before
    public void setUp() throws Exception {
        this.date1 = new Period(PeriodUnit.DAY, 1, this.tzDefault).getStartDate();
        this.date2 = new Period(PeriodUnit.DAY, 2, this.tzDefault).getStartDate();
        if (this.dbFile.exists() && !this.dbFile.delete()) {
            throw new RuntimeException("Unable to delete Database file: " + this.dbFile.getAbsolutePath());
        }
        this.dbHandle = new InfinityDbHandle(this.dbFile);
        this.dataCollector = new BucketGraph(this.dbHandle, "test", true, new CommonStringTables((UniqueStringTableFactory)this.dbHandle), null);
        this.con = new InfinityDBConnector(this.dbHandle, "test", true, new CommonStringTables((UniqueStringTableFactory)this.dbHandle));
    }

    @After
    public void tearDown() throws Exception {
        this.dbHandle.close();
        this.dataCollector = null;
        if (this.dbFile.exists() && !this.dbFile.delete()) {
            throw new RuntimeException("Unable to delete Database file: " + this.dbFile.getAbsolutePath());
        }
        Dir.setCacheDepth((int)6);
    }

    @Test
    public void testAddToData() throws Exception {
        Path path1 = new Path((CharSequence)"/test.java");
        this.con.addToData(0L, new ParameterSetInsertion(path1, "MAIN", 1, 5, 1, "Anna", false, 0L), CommonSchema.BucketDataNew.A_DATA);
        StringBuffer sb = new StringBuffer();
        this.con.dataToString(0L, "", sb, CommonSchema.BucketDataNew.A_DATA);
        Assert.assertEquals((String)sb.toString(), (String)"\n[MAIN, .java, __ALL_AUTHORS__] 0-1=[5,1] \n[MAIN, .java, anna] 0-1=[5,1] \n[MAIN, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-1=[5,1] \n[MAIN, __ALL_EXTENSIONS__, anna] 0-1=[5,1] ");
    }

    @Test
    public void testBucketDataCollectorNoCache() throws DbException, IOException {
        Dir.setCacheDepth((int)-2);
        this.addData();
        Assert.assertEquals((String)this.dataCollector.toStringFull(), (String)"\ndata/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-1=[8,1] \ndata/test.java data [TRUNK, .java, anna] 0-1=[8,1] \ndata/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-1=[8,1] \ndata/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-1=[8,1] \ntest/test/test/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test/test.java data [TRUNK, .java, anna] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[23,1] 0-1=[-10,1] \ntest/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[12,2] 0-1=[22,2] \ntest/test.java data [TRUNK, .java, anna] 0-0=[12,2] 0-1=[22,2] \ntest/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[12,2] 0-1=[22,2] \ntest/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[12,2] 0-1=[22,2] \ntest/test.xml data [TRUNK, .xml, __ALL_AUTHORS__] 0-0=[25,2] 0-1=[20,1] \ntest/test.xml data [TRUNK, .xml, anna] 0-0=[25,2] 0-1=[20,1] \ntest/test.xml data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[25,2] 0-1=[20,1] \ntest/test.xml data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[25,2] 0-1=[20,1] \ntest/test2/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[20,1] \ntest/test2/test.java data [TRUNK, .java, anna] 0-0=[20,1] \ntest/test2/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[20,1] \ntest/test2/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[20,1] \ntest.java data [TRUNK, .java, __ALL_AUTHORS__] 0-1=[20,2] \ntest.java data [TRUNK, .java, anna] 0-1=[20,2] \ntest.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-1=[20,2] \ntest.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-1=[20,2] \ntest2/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[12,1] 0-1=[7,1] \ntest2/test.java data [TRUNK, .java, anna] 0-0=[12,1] 0-1=[7,1] \ntest2/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[12,1] 0-1=[7,1] \ntest2/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[12,1] 0-1=[7,1] ");
    }

    @Test
    public void testBucketDataCollectorWithCache() throws DbException, IOException {
        Dir.setCacheDepth((int)12);
        this.addData();
        Assert.assertEquals((String)this.dataCollector.toStringFull(), (String)"\n cache [TRUNK, .java, __ALL_AUTHORS__] 0-0=[67,5] 0-1=[47,7] \n cache [TRUNK, .java, anna] 0-0=[67,5] 0-1=[47,7] \n cache [TRUNK, .xml, __ALL_AUTHORS__] 0-0=[25,2] 0-1=[20,1] \n cache [TRUNK, .xml, anna] 0-0=[25,2] 0-1=[20,1] \n cache [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[92,7] 0-1=[67,8] \n cache [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[92,7] 0-1=[67,8] \ndata cache [TRUNK, .java, __ALL_AUTHORS__] 0-1=[8,1] \ndata cache [TRUNK, .java, anna] 0-1=[8,1] \ndata cache [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-1=[8,1] \ndata cache [TRUNK, __ALL_EXTENSIONS__, anna] 0-1=[8,1] \ndata/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-1=[8,1] \ndata/test.java data [TRUNK, .java, anna] 0-1=[8,1] \ndata/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-1=[8,1] \ndata/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-1=[8,1] \ntest cache [TRUNK, .java, __ALL_AUTHORS__] 0-0=[55,4] 0-1=[12,3] \ntest cache [TRUNK, .java, anna] 0-0=[55,4] 0-1=[12,3] \ntest cache [TRUNK, .xml, __ALL_AUTHORS__] 0-0=[25,2] 0-1=[20,1] \ntest cache [TRUNK, .xml, anna] 0-0=[25,2] 0-1=[20,1] \ntest cache [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[80,6] 0-1=[32,4] \ntest cache [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[80,6] 0-1=[32,4] \ntest/test cache [TRUNK, .java, __ALL_AUTHORS__] 0-0=[23,1] 0-1=[-10,1] \ntest/test cache [TRUNK, .java, anna] 0-0=[23,1] 0-1=[-10,1] \ntest/test cache [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[23,1] 0-1=[-10,1] \ntest/test cache [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test cache [TRUNK, .java, __ALL_AUTHORS__] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test cache [TRUNK, .java, anna] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test cache [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test cache [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test/test.java data [TRUNK, .java, anna] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[23,1] 0-1=[-10,1] \ntest/test/test/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[23,1] 0-1=[-10,1] \ntest/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[12,2] 0-1=[22,2] \ntest/test.java data [TRUNK, .java, anna] 0-0=[12,2] 0-1=[22,2] \ntest/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[12,2] 0-1=[22,2] \ntest/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[12,2] 0-1=[22,2] \ntest/test.xml data [TRUNK, .xml, __ALL_AUTHORS__] 0-0=[25,2] 0-1=[20,1] \ntest/test.xml data [TRUNK, .xml, anna] 0-0=[25,2] 0-1=[20,1] \ntest/test.xml data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[25,2] 0-1=[20,1] \ntest/test.xml data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[25,2] 0-1=[20,1] \ntest/test2 cache [TRUNK, .java, __ALL_AUTHORS__] 0-0=[20,1] \ntest/test2 cache [TRUNK, .java, anna] 0-0=[20,1] \ntest/test2 cache [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[20,1] \ntest/test2 cache [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[20,1] \ntest/test2/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[20,1] \ntest/test2/test.java data [TRUNK, .java, anna] 0-0=[20,1] \ntest/test2/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[20,1] \ntest/test2/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[20,1] \ntest.java data [TRUNK, .java, __ALL_AUTHORS__] 0-1=[20,2] \ntest.java data [TRUNK, .java, anna] 0-1=[20,2] \ntest.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-1=[20,2] \ntest.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-1=[20,2] \ntest2 cache [TRUNK, .java, __ALL_AUTHORS__] 0-0=[12,1] 0-1=[7,1] \ntest2 cache [TRUNK, .java, anna] 0-0=[12,1] 0-1=[7,1] \ntest2 cache [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[12,1] 0-1=[7,1] \ntest2 cache [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[12,1] 0-1=[7,1] \ntest2/test.java data [TRUNK, .java, __ALL_AUTHORS__] 0-0=[12,1] 0-1=[7,1] \ntest2/test.java data [TRUNK, .java, anna] 0-0=[12,1] 0-1=[7,1] \ntest2/test.java data [TRUNK, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[12,1] 0-1=[7,1] \ntest2/test.java data [TRUNK, __ALL_EXTENSIONS__, anna] 0-0=[12,1] 0-1=[7,1] ");
    }

    private void addData() throws DbException, IOException {
        Path path1 = new Path((CharSequence)"/test.java");
        Path path2 = new Path((CharSequence)"/test/test.java");
        Path path2xml = new Path((CharSequence)"/test/test.xml");
        Path path3 = new Path((CharSequence)"/data/test.java");
        Path path4 = new Path((CharSequence)"/test/test/test/test.java");
        Path path5 = new Path((CharSequence)"/test/test2/test.java");
        Path path6 = new Path((CharSequence)"/test2/test.java");
        this.con.addDirToIndex(new Path((CharSequence)""));
        this.con.addDirToIndex(new Path((CharSequence)"data/"));
        this.con.addFileToIndex(new Path((CharSequence)"data/test.java"));
        this.con.addDirToIndex(new Path((CharSequence)"test/"));
        this.con.addDirToIndex(new Path((CharSequence)"test/test/"));
        this.con.addDirToIndex(new Path((CharSequence)"test/test/test/"));
        this.con.addFileToIndex(new Path((CharSequence)"test/test/test/test.java"));
        this.con.addFileToIndex(new Path((CharSequence)"test/test.java"));
        this.con.addFileToIndex(new Path((CharSequence)"test/test.xml"));
        this.con.addDirToIndex(new Path((CharSequence)"test/test2/"));
        this.con.addFileToIndex(new Path((CharSequence)"test/test2/test.java"));
        this.con.addFileToIndex(new Path((CharSequence)"test.java"));
        this.con.addDirToIndex(new Path((CharSequence)"test2/"));
        this.con.addFileToIndex(new Path((CharSequence)"test2/test.java"));
        this.dataCollector.addRevision(path1, "TRUNK", this.date2, 10, "Anna", false, 0L);
        this.dataCollector.addRevision(path2, "TRUNK", this.date2, 15, "Anna", false, 0L);
        this.dataCollector.addRevision(path2, "TRUNK", this.date1, 7, "Anna", false, 0L);
        this.dataCollector.addRevision(path2, "TRUNK", this.date1, 5, "Anna", false, 0L);
        this.dataCollector.addRevision(path2xml, "TRUNK", this.date1, 5, "Anna", false, 0L);
        this.dataCollector.addRevision(path2, "TRUNK", this.date2, 7, "Anna", false, 0L);
        this.dataCollector.addRevision(path2xml, "TRUNK", this.date2, 20, "Anna", false, 0L);
        this.dataCollector.addRevision(path3, "TRUNK", this.date2, 8, "Anna", false, 0L);
        ParameterSetQuery params = new ParameterSetQuery();
        params.setBranch("TRUNK");
        Assert.assertEquals((String)"{TRUNK={0={0=[17(+17),3(+3)], 1=[77(+60),8(+5)]}}}", (String)this.dataCollector.getBuckets(params).toString());
        params.setPath(new Path((CharSequence)"test"));
        Assert.assertEquals((String)"{TRUNK={0={0=[17(+17),3(+3)], 1=[59(+42),6(+3)]}}}", (String)this.dataCollector.getBuckets(params).toString());
        params.setExtension(".java");
        params.setPath(path1.getParent());
        Assert.assertEquals((String)"{TRUNK={0={0=[12(+12),2(+2)], 1=[52(+40),6(+4)]}}}", (String)this.dataCollector.getBuckets(params).toString());
        this.dataCollector.addRevision(path1, "TRUNK", this.date2, 10, "Anna", false, 0L);
        this.dataCollector.addRevision(path4, "TRUNK", this.date2, -10, "Anna", false, 0L);
        this.dataCollector.addRevision(path5, "TRUNK", this.date1, 20, "Anna", false, 0L);
        this.dataCollector.addRevision(path6, "TRUNK", this.date1, 12, "Anna", false, 0L);
        this.dataCollector.addRevision(path4, "TRUNK", this.date1, 23, "Anna", false, 0L);
        this.dataCollector.addRevision(path6, "TRUNK", this.date2, 7, "Anna", false, 0L);
        this.dataCollector.addRevision(path2xml, "TRUNK", this.date1, 20, "Anna", false, 0L);
    }

    @Test
    public void testBucketData() {
        BucketDataDiffs bucketData = new BucketDataDiffs("TRUNK");
        bucketData.add(0L, 0, 20, 10);
        bucketData.add(0L, 1, 15, 25);
        bucketData.add(0L, 1, 10, 20);
        bucketData.add(0L, 2, 1, 3);
        Assert.assertEquals((String)"{0={0=[20,10], 1=[25,45], 2=[1,3]}}", (String)bucketData.toString());
    }
}

