/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketData;
import com.atlassian.fisheye.bucket.BucketDataCollectionTotalled;
import com.atlassian.fisheye.bucket.BucketDataExporter;
import com.atlassian.fisheye.bucket.BucketDataTotalled;
import com.atlassian.fisheye.bucket.PeriodUnit;
import java.io.StringWriter;
import java.io.Writer;
import java.util.TimeZone;
import junit.framework.TestCase;

public class BucketDataExporterTest
extends TestCase {
    public void testJson() throws Exception {
        StringWriter writer = new StringWriter();
        TimeZone tz = TimeZone.getTimeZone("GMT+11");
        BucketDataCollectionTotalled data = new BucketDataCollectionTotalled(PeriodUnit.DAY, tz);
        data.add((BucketData)new BucketDataTotalled(".dfm", 12414, 47, 1, 0, 0));
        data.add((BucketData)new BucketDataTotalled(".dfm", 12424, -11, 0, 0, 0));
        data.add((BucketData)new BucketDataTotalled(".dfm", 12437, -29, 0, 0, 0));
        data.add((BucketData)new BucketDataTotalled("__ALL_EXTENSIONS__", 12414, 47, 1, 0, 0));
        data.add((BucketData)new BucketDataTotalled("__ALL_EXTENSIONS__", 12424, -11, 0, 0, 0));
        data.add((BucketData)new BucketDataTotalled("__ALL_EXTENSIONS__", 12437, -29, 0, 0, 0));
        BucketDataExporter.writeRawDataJson((Writer)writer, (BucketDataCollectionTotalled)data, (TimeZone)tz);
        System.out.println(writer.toString());
        BucketDataExporterTest.assertEquals((String)writer.toString(), (String)"[{\".dfm\":[{\"0\":[{\"loc_change\":47,\"num_revisions\":1,\"loc_running_total\":47,\"revisions_running_total\":1,\"start_time\":1072184400000,\"end_time\":1072270799999},{\"loc_change\":-11,\"num_revisions\":0,\"loc_running_total\":36,\"revisions_running_total\":1,\"start_time\":1073048400000,\"end_time\":1073134799999},{\"loc_change\":-29,\"num_revisions\":0,\"loc_running_total\":7,\"revisions_running_total\":1,\"start_time\":1074171600000,\"end_time\":1074257999999}]}]},{\"__ALL_EXTENSIONS__\":[{\"0\":[{\"loc_change\":47,\"num_revisions\":1,\"loc_running_total\":47,\"revisions_running_total\":1,\"start_time\":1072184400000,\"end_time\":1072270799999},{\"loc_change\":-11,\"num_revisions\":0,\"loc_running_total\":36,\"revisions_running_total\":1,\"start_time\":1073048400000,\"end_time\":1073134799999},{\"loc_change\":-29,\"num_revisions\":0,\"loc_running_total\":7,\"revisions_running_total\":1,\"start_time\":1074171600000,\"end_time\":1074257999999}]}]}]");
    }
}

