/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.bucket;

import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.InfinityDBConnector;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.cenqua.fisheye.util.SumMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class AuthorBlameTest {
    BucketGraph dataCollector;
    File dbFile = new File(FisheyeTestEnv.WORKSPACE_DIR, "output/testdb.idb");
    private InfinityDbHandle dbHandle;

    @Before
    public void setUp() throws Exception {
        if (this.dbFile.exists() && !this.dbFile.delete()) {
            throw new RuntimeException("Unable to delete Database file: " + this.dbFile.getAbsolutePath());
        }
        this.dbHandle = new InfinityDbHandle(this.dbFile);
        this.dataCollector = new BucketGraph(this.dbHandle, "test", true, new CommonStringTables((UniqueStringTableFactory)this.dbHandle), null);
    }

    @After
    public void tearDown() throws Exception {
        this.dbHandle.close();
        this.dataCollector = null;
        if (this.dbFile.exists() && !this.dbFile.delete()) {
            throw new RuntimeException("Unable to delete Database file: " + this.dbFile.getAbsolutePath());
        }
    }

    @Test
    public void testAuthorBlame() throws DbException, IOException {
        InfinityDBConnector con = this.dataCollector.getConnector();
        con.addFileToIndex(new Path((CharSequence)"/test.java"));
        Object2IntOpenHashMap linecountByAuthor = new Object2IntOpenHashMap();
        linecountByAuthor.put((Object)"Anna", 32);
        linecountByAuthor.put((Object)"Matt", -15);
        linecountByAuthor.put((Object)"Conor", -7);
        this.dataCollector.addRevision(new Path((CharSequence)"test.java"), "MAIN", 0, new SumMap((Object2IntMap)linecountByAuthor), "Anna", false, 0L);
        Assert.assertEquals((String)this.dataCollector.toStringFull(), (String)"\n cache [MAIN, .java, __ALL_AUTHORS__] 0-0=[10,1] \n cache [MAIN, .java, anna] 0-0=[32,1] \n cache [MAIN, .java, conor] 0-0=[-7,0] \n cache [MAIN, .java, matt] 0-0=[-15,0] \n cache [MAIN, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[10,1] \n cache [MAIN, __ALL_EXTENSIONS__, anna] 0-0=[32,1] \n cache [MAIN, __ALL_EXTENSIONS__, conor] 0-0=[-7,0] \n cache [MAIN, __ALL_EXTENSIONS__, matt] 0-0=[-15,0] \ntest.java data [MAIN, .java, __ALL_AUTHORS__] 0-0=[10,1] \ntest.java data [MAIN, .java, anna] 0-0=[32,1] \ntest.java data [MAIN, .java, conor] 0-0=[-7,0] \ntest.java data [MAIN, .java, matt] 0-0=[-15,0] \ntest.java data [MAIN, __ALL_EXTENSIONS__, __ALL_AUTHORS__] 0-0=[10,1] \ntest.java data [MAIN, __ALL_EXTENSIONS__, anna] 0-0=[32,1] \ntest.java data [MAIN, __ALL_EXTENSIONS__, conor] 0-0=[-7,0] \ntest.java data [MAIN, __ALL_EXTENSIONS__, matt] 0-0=[-15,0] ");
    }
}

