/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.branch;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.fecru.properties.UserRepositoryPropertyManager;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.branch.BranchPreferenceHandler;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.fisheye.web.BranchSelectorPref;
import junit.framework.Assert;
import org.json.JSONObject;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class BranchPreferenceHandlerTest {
    @MockitoAnnotations.Mock
    EffectiveUserProvider effectiveUserProvider;
    @MockitoAnnotations.Mock
    TxTemplate txTemplate;
    @MockitoAnnotations.Mock
    UserRepositoryPropertyManager propertyManager;

    @Test
    public void testCookieRequiresClearingOnExistingData() throws Exception {
        BranchPreferenceHandler handler = new BranchPreferenceHandler(this.txTemplate, this.propertyManager, this.effectiveUserProvider);
        FecruUser user = new FecruUser("user");
        JSONObject json = new JSONObject("{\"repo1\":{}}");
        BranchSelectorPref branchPref = new BranchSelectorPref(json);
        boolean shouldClearCookie = handler.upgradeLastSelectedBranchPref(user, branchPref);
        Assert.assertTrue((String)"should clear cookie with non empty branchPref", (boolean)shouldClearCookie);
    }

    @Test
    public void testCookieNotClearedOnNoData() throws Exception {
        BranchPreferenceHandler handler = new BranchPreferenceHandler(this.txTemplate, this.propertyManager, this.effectiveUserProvider);
        FecruUser user = new FecruUser("user");
        JSONObject json = new JSONObject("{}");
        BranchSelectorPref branchPref = new BranchSelectorPref(json);
        boolean shouldClearCookie = handler.upgradeLastSelectedBranchPref(user, branchPref);
        Assert.assertFalse((String)"should not clear cookie on empty branchPref", (boolean)shouldClearCookie);
        shouldClearCookie = handler.upgradeLastSelectedBranchPref(user, null);
        Assert.assertFalse((String)"should not clear cookie on null branchPref", (boolean)shouldClearCookie);
    }

    @Test
    public void testCookieClearedOnAnonUser() throws Exception {
        BranchPreferenceHandler handler = new BranchPreferenceHandler(this.txTemplate, this.propertyManager, this.effectiveUserProvider);
        boolean shouldClearCookie = handler.upgradeLastSelectedBranchPref(null, null);
        Assert.assertTrue((String)"should clear cookie with on anon user", (boolean)shouldClearCookie);
    }

    @Test
    public void testNoTransactionOnAnonUser() throws Exception {
        BranchPreferenceHandler handler = new BranchPreferenceHandler(this.txTemplate, this.propertyManager, this.effectiveUserProvider);
        handler.upgradeLastSelectedBranchPref(null, null);
        ((TxTemplate)Mockito.verify((Object)this.txTemplate, (VerificationMode)Mockito.never())).execute((TxCallback)Matchers.any());
    }
}

