/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity.external;

import com.atlassian.fisheye.activity.ExternalActivityItem;
import com.atlassian.fisheye.activity.external.ExternalActivityItemAdapter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ExternalActivityItemAdapterTest {
    @Test
    public void testParseTitleHtmlForStreams3() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithTitle("<a href=\"https://studio.atlassian.com/secure/ViewProfile.jspa?name=username\">User Name</a> commented on <a href=\"https://studio.atlassian.com/browse/TWO-2\">TWO-2</a> (Long issue title goes here)"));
        Assert.assertEquals((Object)"commented", (Object)item.getVerbageHtml());
        Assert.assertEquals((Object)"Long issue title goes here", (Object)item.getTitle());
    }

    @Test
    public void testParseTitleHtmlForStreams4() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithTitle("<a href=\"http://localhost:2990/streams/secure/ViewProfile.jspa?name=admin\" class=\"activity-item-user activity-item-author\">admin</a> commented on   <a href=\"http://localhost:2990/streams/browse/ONE-1\" class=\"issue-link\">ONE-1 - Issue One</a>"));
        Assert.assertEquals((Object)"commented", (Object)item.getVerbageHtml());
        Assert.assertEquals((Object)"ONE-1 - Issue One", (Object)item.getTitle());
    }

    @Test
    public void testParseTitleHtmlForStreams4ResolvedIssue() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithTitle("<a href=\"http://localhost:2990/streams/secure/ViewProfile.jspa?name=admin\" class=\"activity-item-user activity-item-author\">admin</a> commented on   <a href=\"http://localhost:2990/streams/browse/ONE-1\" class=\"issue-link\"><span class='resolved-link'>ONE-1</span> - Issue One</a>"));
        Assert.assertEquals((Object)"commented", (Object)item.getVerbageHtml());
        Assert.assertEquals((Object)"ONE-1 - Issue One", (Object)item.getTitle());
    }

    @Test
    public void testParseTitleHtmlForStreams4WithoutAuthor() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithTitle("commented on   <a href=\"http://localhost:2990/streams/browse/ONE-1\" class=\"issue-link\">ONE-1 - Issue One</a>"));
        Assert.assertEquals((Object)"commented", (Object)item.getVerbageHtml());
        Assert.assertEquals((Object)"ONE-1 - Issue One", (Object)item.getTitle());
    }

    @Test
    public void testParseTitleHtmlForStreams4LinkedTwoIssues() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithTitle("<a href=\"http://localhost:2990/streams/secure/ViewProfile.jspa?name=admin\" class=\"activity-item-user activity-item-author\">admin</a> linked 2 issues"));
        Assert.assertEquals((Object)"linked 2 issues", (Object)item.getVerbageHtml());
        Assert.assertEquals((Object)"", (Object)item.getTitle());
    }

    @Test
    public void testParseTitleHtmlForStreams4AddedFixForVersion() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithTitle("<a href=\"http://localhost:2990/streams/secure/ViewProfile.jspa?name=admin\" class=\"activity-item-user activity-item-author\">admin</a> added the Fix Version '<a href=\"https://idog.atlassian.com/jira/browse/STRM/fixforversion/10035\">4.0</a>' to   <a href=\"https://localhost:2990/streams/browse/STRM-717\" class=\"issue-link\">STRM-717 - Look at my bug</a>"));
        Assert.assertEquals((Object)"added the Fix Version '<a href=\"https://idog.atlassian.com/jira/browse/STRM/fixforversion/10035\">4.0</a>'", (Object)item.getVerbageHtml());
        Assert.assertEquals((Object)"STRM-717 - Look at my bug", (Object)item.getTitle());
    }

    @Test
    public void testParseSummaryHtmlForStreams3() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithSummary("<a href=\"https://studio.atlassian.com/secure/ViewProfile.jspa?name=username\">User Name</a> changed the Summary to 'New Summary' on <\"https://studio.atlassian.com/browse/ONE-1\">ONE-1</a> (Title goes here) saying: <div class=\"activity-item-description\"><p>Blah blah blah</p></div>"));
        Assert.assertEquals((Object)"<p>Blah blah blah</p>", (Object)item.getSummary());
    }

    @Test
    public void testParseSummaryHtmlWithNullSummary() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithSummary(null));
        Assert.assertEquals((Object)"", (Object)item.getSummary());
    }

    @Test
    public void testIssueKeyIsResolvedFromSimpleUrl() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithUrl("http://localhost:2990/streams/browse/ONE-1"));
        Assert.assertEquals((Object)"ONE-1", (Object)((ExternalActivityItemAdapter.IssueKey)item.getIssueKeys().get(0)).getKey());
    }

    @Test
    public void testIssueKeyIsResolvedFromCommentUrl() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithUrl("http://localhost:2990/streams/browse/ONE-1?focusedCommentId=10000&amp;page=com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel#comment-10000"));
        Assert.assertEquals((Object)"ONE-1", (Object)((ExternalActivityItemAdapter.IssueKey)item.getIssueKeys().get(0)).getKey());
    }

    @Test
    public void testIssueKeyIsNotResolvedFromBadUrl() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithUrl("http://localhost:2990/streams/browse/ONE-123+this+should+not+be+included"));
        Assert.assertNull((String)"issue key should be null", item.getIssueKeys().get(0));
    }

    @Test
    public void testIssueKeyIsNotResolvedFromNullUrl() {
        ExternalActivityItemAdapter item = new ExternalActivityItemAdapter(this.newItemWithUrl(null));
        Assert.assertNull((String)"issue key should be null", item.getIssueKeys().get(0));
    }

    private ExternalActivityItem newItemWithTitle(String titleHtml) {
        ExternalActivityItem item = (ExternalActivityItem)Mockito.mock(ExternalActivityItem.class);
        Mockito.when((Object)item.getTitle()).thenReturn((Object)titleHtml);
        Mockito.when((Object)item.getSummary()).thenReturn((Object)"");
        return item;
    }

    private ExternalActivityItem newItemWithSummary(String summaryHtml) {
        ExternalActivityItem item = (ExternalActivityItem)Mockito.mock(ExternalActivityItem.class);
        Mockito.when((Object)item.getTitle()).thenReturn((Object)"");
        Mockito.when((Object)item.getSummary()).thenReturn((Object)summaryHtml);
        return item;
    }

    private ExternalActivityItem newItemWithUrl(String url) {
        ExternalActivityItem item = (ExternalActivityItem)Mockito.mock(ExternalActivityItem.class);
        Mockito.when((Object)item.getTitle()).thenReturn((Object)"");
        Mockito.when((Object)item.getSummary()).thenReturn((Object)"");
        Mockito.when((Object)item.getUrl()).thenReturn((Object)url);
        return item;
    }
}

