/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.fisheye.activity.RepositoryConstraintBuilder;
import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.atlassian.fisheye.stars.model.CommentStar;
import com.atlassian.fisheye.stars.model.CommitterStar;
import com.atlassian.fisheye.stars.model.DirectoryStar;
import com.atlassian.fisheye.stars.model.FileStar;
import com.atlassian.fisheye.stars.model.RepositoryStar;
import com.atlassian.fisheye.stars.model.StarKey;
import com.atlassian.fisheye.stars.model.UserStar;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.LegacyRepositoryManagerRootConfig;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public final class RepositoryConstraintBuilderTest {
    @Test
    public void testConstraintBuilder() throws Exception {
        ArrayList<Object> stars = new ArrayList<Object>();
        stars.add(new CommitterStar(this.makeStarKey("cvs", "matt", "atlassian-committer"), null));
        stars.add(new CommitterStar(this.makeStarKey("cvs", "anthony", "atlassian-committer"), null));
        stars.add(new CommitterStar(this.makeStarKey("cvs2", "matt", "atlassian-committer"), null));
        stars.add(new RepositoryStar(this.makeStarKey("cvs2", null, "atlassian-repository"), null));
        stars.add(new FileStar(this.makeStarKey("a.txt", "cvs", "atlassian-file"), null));
        stars.add(new FileStar(this.makeStarKey("b.txt", "cvs", "atlassian-file"), null));
        stars.add(new FileStar(this.makeStarKey("blah/a.txt", "cvs", "atlassian-file"), null));
        stars.add(new FileStar(this.makeStarKey("a.txt", "cvs2", "atlassian-file"), null));
        stars.add(new FileStar(this.makeStarKey("blah/a.txt", "cvs2", "atlassian-file"), null));
        stars.add(new DirectoryStar(this.makeStarKey("blah", "cvs", "atlassian-directory"), null));
        stars.add(new DirectoryStar(this.makeStarKey("blah/blah", "cvs", "atlassian-directory"), null));
        stars.add(new DirectoryStar(this.makeStarKey("blah", "cvs", "atlassian-directory"), null));
        CommitterUserMappingManager mappingManager = (CommitterUserMappingManager)Mockito.mock(CommitterUserMappingManager.class);
        HashMultimap brendansMappings = HashMultimap.create();
        brendansMappings.put((Object)"cvs", (Object)"brendan");
        brendansMappings.put((Object)"cvs2", (Object)"brendan");
        Mockito.when((Object)mappingManager.getAllCommittersForUser(Mockito.anyString())).thenReturn((Object)brendansMappings);
        stars.add(new UserStar(this.makeStarKey("brendan", "", "atlassian-user"), null));
        stars.add(new UserStar(this.makeStarKey("no-one", "", "atlassian-user"), null));
        StarKey blank = new StarKey();
        blank.setItemType("atlassian-comment");
        blank.setIntKey1(Integer.valueOf(1));
        stars.add(new CommentStar(blank, null));
        RepositoryConstraintBuilder list = new RepositoryConstraintBuilder(mappingManager);
        list.addStars(stars);
        RepositoryConstraints params = list.getActivityItemParams();
        Set reps = params.getReps();
        Assert.assertEquals((int)2, (int)reps.size());
        Assert.assertTrue((boolean)reps.contains("cvs"));
        Assert.assertTrue((boolean)reps.contains("cvs2"));
        RepositoryConstraints.RepositoryConstraint cvs = params.getConstraintsForRep("cvs");
        RepositoryConstraints.RepositoryConstraint cvs2 = params.getConstraintsForRep("cvs2");
        Assert.assertTrue((boolean)cvs2.isIncludeWholeRepository());
        Assert.assertTrue((boolean)cvs2.getCommitters().isEmpty());
        Assert.assertTrue((boolean)cvs2.getPaths().isEmpty());
        Assert.assertFalse((boolean)cvs.isIncludeWholeRepository());
        Assert.assertFalse((boolean)cvs.getCommitters().isEmpty());
        Assert.assertFalse((boolean)cvs.getPaths().isEmpty());
        Set committers = cvs.getCommitters();
        Assert.assertTrue((boolean)committers.contains("matt"));
        Assert.assertTrue((boolean)committers.contains("brendan"));
        Assert.assertTrue((boolean)committers.contains("anthony"));
        Assert.assertEquals((int)3, (int)committers.size());
        Set paths = cvs.getPaths();
        this.assertPath("/a.txt", paths);
        this.assertPath("/b.txt", paths);
        this.assertPath("/blah", paths);
        Assert.assertEquals((int)3, (int)paths.size());
    }

    private void assertPath(String pathString, Set<Path> paths) {
        Path path = new Path((CharSequence)pathString);
        Assert.assertTrue((boolean)paths.contains(path));
    }

    private StarKey makeStarKey(String a, String b, String type) {
        StarKey starKey = new StarKey();
        starKey.setStringKey1(a);
        if (!Strings.isNullOrEmpty((String)b)) {
            starKey.setStringKey2(b);
        }
        starKey.setItemType(type);
        return starKey;
    }

    static {
        LegacyRepositoryManagerRootConfig.resetConfig();
    }
}

