/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemComparators;
import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivityItemSearchUtil;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.ActivityStreamHandler;
import com.atlassian.fisheye.activity.BaseActivityItem;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.util.SortedList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ActivityStreamHandlerTest {
    private DummyActivityItemManager manager = new DummyActivityItemManager();
    private List<ActivityItem> items = new ArrayList<ActivityItem>();
    private Date now;

    @Before
    public void setUp() {
        this.now = new Date(System.currentTimeMillis());
        while (System.currentTimeMillis() < this.now.getTime() + 10L) {
        }
        this.now = new Date(System.currentTimeMillis());
        this.items.add((ActivityItem)DummyActivityItem.makeChangelogDummy(this.now, ":11345"));
        this.items.add((ActivityItem)DummyActivityItem.makeChangelogDummy(this.now, ":1"));
        this.items.add((ActivityItem)DummyActivityItem.makeChangelogDummy(this.now, ":11343"));
        this.items.add((ActivityItem)DummyActivityItem.makeChangelogDummy(this.now, ":12341"));
        this.items.add((ActivityItem)DummyActivityItem.makeChangelogDummy(this.now, ":3"));
        this.items.add((ActivityItem)DummyActivityItem.makeChangelogDummy(this.now, ":111"));
        this.items.add((ActivityItem)DummyActivityItem.makeStateChangeDummy(this.now, ":3:45"));
        this.items.add((ActivityItem)DummyActivityItem.makeStateChangeDummy(this.now, ":3:44"));
        this.items.add((ActivityItem)DummyActivityItem.makeStateChangeDummy(this.now, ":3:42"));
        this.items.add((ActivityItem)DummyActivityItem.makeStateChangeDummy(this.now, ":3:41"));
        this.items.add((ActivityItem)DummyActivityItem.makeStateChangeDummy(this.now, ":3:31"));
        this.items.add((ActivityItem)DummyActivityItem.makeStateChangeDummy(this.now, ":3:21"));
        this.items.add((ActivityItem)DummyActivityItem.makeCommentDummy(this.now, ":3:45"));
        this.items.add((ActivityItem)DummyActivityItem.makeCommentDummy(this.now, ":3:44"));
        this.items.add((ActivityItem)DummyActivityItem.makeCommentDummy(this.now, ":3:42"));
        this.items.add((ActivityItem)DummyActivityItem.makeCommentDummy(this.now, ":3:41"));
        this.items.add((ActivityItem)DummyActivityItem.makeCommentDummy(this.now, ":3:31"));
        this.items.add((ActivityItem)DummyActivityItem.makeCompletionDummy(this.now, ":7:1:dog"));
        this.items.add((ActivityItem)DummyActivityItem.makeCompletionDummy(this.now, ":3:23:cat:dog"));
        this.items.add((ActivityItem)DummyActivityItem.makeCompletionDummy(this.now, ":2:1:dog:cat"));
        this.items.add((ActivityItem)DummyActivityItem.makeCompletionDummy(this.now, ":2:1:fish"));
        this.items.add((ActivityItem)DummyActivityItem.makeCompletionDummy(this.now, ":3:31:turtle:tuttle"));
        this.items.add((ActivityItem)DummyActivityItem.makeCompletionDummy(this.now, ":3:21:p"));
        this.items.add((ActivityItem)DummyActivityItem.makeJiraDummy(this.now, ":FE-121"));
        this.items.add((ActivityItem)DummyActivityItem.makeJiraDummy(this.now, ":CRU-546"));
        this.items.add((ActivityItem)DummyActivityItem.makeJiraDummy(this.now, ":FE-123"));
        this.items.add((ActivityItem)DummyActivityItem.makeJiraDummy(this.now, ":JIRA-2"));
        this.items.add((ActivityItem)DummyActivityItem.makeJiraDummy(this.now, ":JIRA-4"));
        this.items.add((ActivityItem)DummyActivityItem.makeJiraDummy(this.now, ":TEST-3"));
        this.manager.addItems(this.items);
        Collections.sort(this.items);
        Collections.reverse(this.items);
    }

    private ActivityItemSearchParams makeParams(int max) {
        return ActivityItemSearchParams.builder().maxItems(max).searchDirection(SearchSortOrder.TOWARDS_PAST).timeZone((TimeZone)new SimpleTimeZone(0, "GMT")).includeFisheye().build();
    }

    private ActivityItemSearchParams makeMinParams(int max, Date minDate) {
        return ActivityItemSearchParams.builder().searchDirection(SearchSortOrder.TOWARDS_FUTURE).maxItems(max).minDate(minDate).timeZone((TimeZone)new SimpleTimeZone(0, "GMT")).includeFisheye().build();
    }

    private ActivityItemSearchParams makeMaxParams(int max, Date maxDate) {
        return ActivityItemSearchParams.builder().searchDirection(SearchSortOrder.TOWARDS_PAST).maxItems(max).maxDate(maxDate).timeZone((TimeZone)new SimpleTimeZone(0, "GMT")).includeFisheye().build();
    }

    @Test
    public void testActivityStreamHandler() throws Exception {
        int i = 0;
        for (ActivityItem item : this.manager.findActivityItems(this.makeParams(this.items.size()), null, new ActivitySearchMonitor()).getItems()) {
            Assert.assertEquals((Object)item, (Object)this.items.get(i));
            ++i;
        }
        String anchor = this.items.get(0).getOpaqueId();
        for (int j = 1; j < 24; j += 4) {
            anchor = this.testBackwardSector(j, anchor);
        }
        List resultingItems = ActivityStreamHandler.getEnoughItemsForPast((ActivityItemSearchParams)this.makeMaxParams(4, this.now), (ActivityItemManager)this.manager, (String)this.items.get(27).getOpaqueId(), null, (int)4, (ActivitySearchMonitor)new ActivitySearchMonitor()).getItems();
        Assert.assertEquals((int)1, (int)resultingItems.size());
        Assert.assertEquals((Object)this.items.get(28), resultingItems.get(0));
        anchor = this.items.get(28).getOpaqueId();
        for (int j = 27; j > 0; j -= 4) {
            anchor = this.testForwardSector(j, anchor);
        }
    }

    private String testForwardSector(int start, String anchor) {
        ArrayList<ActivityItem> resultingItems = new ArrayList<ActivityItem>(ActivityStreamHandler.getEnoughItemsForFuture((ActivityItemSearchParams)this.makeMinParams(4, this.now), (ActivityItemManager)this.manager, (String)anchor, null, (int)4, (ActivitySearchMonitor)new ActivitySearchMonitor()).getItems());
        this.check4Items(start, resultingItems);
        return ((ActivityItem)resultingItems.get(0)).getOpaqueId();
    }

    private String testBackwardSector(int start, String anchor) {
        ArrayList<ActivityItem> resultingItems = new ArrayList<ActivityItem>(ActivityStreamHandler.getEnoughItemsForPast((ActivityItemSearchParams)this.makeMaxParams(4, this.now), (ActivityItemManager)this.manager, (String)anchor, null, (int)4, (ActivitySearchMonitor)new ActivitySearchMonitor()).getItems());
        this.check4ItemsBack(start, resultingItems);
        return ((ActivityItem)resultingItems.get(3)).getOpaqueId();
    }

    private void check4ItemsBack(int start, List<ActivityItem> toCheck) {
        Assert.assertEquals((int)4, (int)toCheck.size());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)this.items.get(start + i), (Object)toCheck.get(i));
        }
    }

    private void check4Items(int start, List<ActivityItem> toCheck) {
        Assert.assertEquals((int)4, (int)toCheck.size());
        for (int i = 0; i < 4; ++i) {
            Assert.assertEquals((Object)this.items.get(start - i), (Object)toCheck.get(3 - i));
        }
    }

    @After
    public void tearDown() {
        this.manager = null;
        this.items = null;
        this.now = null;
    }

    private static class DummyActivityItem
    extends BaseActivityItem {
        private final Date date;
        private final String type;
        private final String keysuffix;

        private DummyActivityItem(Date date, String type, String keysuffix) {
            this.date = date;
            this.type = type;
            this.keysuffix = keysuffix;
        }

        public Date getDate() {
            return this.date;
        }

        public String getType() {
            return this.type;
        }

        public String getOpaqueId() {
            return this.type + this.keysuffix;
        }

        public static DummyActivityItem makeStateChangeDummy(Date date, String opaqueId) {
            return new DummyActivityItem(date, "review-stateChange", opaqueId);
        }

        public static DummyActivityItem makeCompletionDummy(Date date, String opaqueId) {
            return new DummyActivityItem(date, "review-completion", opaqueId);
        }

        public static DummyActivityItem makeCommentDummy(Date date, String opaqueId) {
            return new DummyActivityItem(date, "review-comment", opaqueId);
        }

        public static DummyActivityItem makeJiraDummy(Date date, String opaqueId) {
            return new DummyActivityItem(date, "streams-plugin-item", opaqueId);
        }

        public static DummyActivityItem makeChangelogDummy(Date date, String opaqueId) {
            return new DummyActivityItem(date, "changeset", opaqueId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            DummyActivityItem that = (DummyActivityItem)((Object)o);
            return this.date.equals(that.date) && this.keysuffix.equals(that.keysuffix) && this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.date != null ? this.date.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.keysuffix != null ? this.keysuffix.hashCode() : 0);
            return result;
        }
    }

    private class DummyActivityItemManager
    implements ActivityItemManager {
        private SortedList<ActivityItem> items = new SortedList(ActivityItemComparators.desc());

        private DummyActivityItemManager() {
        }

        public ActivityItemList findActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
            SortedList results = new SortedList(params.getSearchDirection() == SearchSortOrder.TOWARDS_PAST ? ActivityItemComparators.desc() : ActivityItemComparators.asc());
            results.addAll(this.items);
            ActivityItemSearchUtil.trimToSize((SortedList)results, (int)params.getMaxItems());
            return new ActivityItemList((Collection)results);
        }

        public void addItems(List<ActivityItem> items) {
            this.items.addAll(items);
        }
    }
}

