/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fisheye.activity;

import com.atlassian.fisheye.activity.ActivityItem;
import com.atlassian.fisheye.activity.ActivityItemComparators;
import java.util.Date;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ActivityItemComparatorsTest {
    Date earlier;
    Date later;

    @Before
    public void setUp() throws Exception {
        this.earlier = new Date();
        this.later = new Date(this.earlier.getTime() + 1000L);
    }

    private ActivityItem mockActivityItem(Date date, String opaqueId) {
        ActivityItem activityItemMock = (ActivityItem)Mockito.mock(ActivityItem.class);
        Mockito.when((Object)activityItemMock.getDate()).thenReturn((Object)date);
        Mockito.when((Object)activityItemMock.getOpaqueId()).thenReturn((Object)opaqueId);
        return activityItemMock;
    }

    @Test
    public void testAsc() throws Exception {
        Assert.assertThat((String)"same changesets are equal according to compareTo", (Object)ActivityItemComparators.asc().compare(this.mockActivityItem(this.earlier, "cs:123"), this.mockActivityItem(this.earlier, "cs:123")), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)"later changeset is greater regardless of opaqueId", (Object)ActivityItemComparators.asc().compare(this.mockActivityItem(this.later, "cs:999"), this.mockActivityItem(this.earlier, "cs:111")), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((String)"earlier changeset is smaller regardless of opaqueId", (Object)ActivityItemComparators.asc().compare(this.mockActivityItem(this.earlier, "cs:222"), this.mockActivityItem(this.later, "cs:222")), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((String)"changesets with identical timestamp are ordered by opaqueId", (Object)ActivityItemComparators.asc().compare(this.mockActivityItem(this.earlier, "cs:222"), this.mockActivityItem(this.earlier, "cs:221")), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((String)"changesets with identical timestamp are ordered by opaqueId", (Object)ActivityItemComparators.asc().compare(this.mockActivityItem(this.earlier, "cs:222"), this.mockActivityItem(this.earlier, "cs:223")), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
    }

    @Test
    public void testDesc() throws Exception {
        Assert.assertThat((String)"same changesets are equal according to compareTo", (Object)ActivityItemComparators.desc().compare(this.mockActivityItem(this.earlier, "cs:123"), this.mockActivityItem(this.earlier, "cs:123")), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((String)"later changeset is smaller regardless of opaqueId", (Object)ActivityItemComparators.desc().compare(this.mockActivityItem(this.later, "cs:999"), this.mockActivityItem(this.earlier, "cs:111")), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((String)"earlier changeset is greater regardless of opaqueId", (Object)ActivityItemComparators.desc().compare(this.mockActivityItem(this.earlier, "cs:222"), this.mockActivityItem(this.later, "cs:222")), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((String)"changesets with identical timestamp are ordered by opaqueId", (Object)ActivityItemComparators.desc().compare(this.mockActivityItem(this.earlier, "cs:222"), this.mockActivityItem(this.earlier, "cs:221")), (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((String)"changesets with identical timestamp are ordered by opaqueId", (Object)ActivityItemComparators.desc().compare(this.mockActivityItem(this.earlier, "cs:222"), this.mockActivityItem(this.earlier, "cs:223")), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }
}

