/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.utils;

import com.atlassian.fecru.utils.FileTypesByExtension;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class FileTypesByExtensionTest {
    FileTypesByExtension ftbe;

    @Before
    public void setUp() throws Exception {
        this.ftbe = new FileTypesByExtension();
    }

    @Test
    public void testGetFileType() throws Exception {
        MatcherAssert.assertThat((String)"valid extension recognised - IMAGE", (Object)this.ftbe.getFileType("png"), (Matcher)Matchers.is((Object)FileTypesByExtension.Type.IMAGE));
        MatcherAssert.assertThat((String)"valid extension recognised - ARCHIVE", (Object)this.ftbe.getFileType("zip"), (Matcher)Matchers.is((Object)FileTypesByExtension.Type.ARCHIVE));
        MatcherAssert.assertThat((String)"valid extension recognised - CODE", (Object)this.ftbe.getFileType("java"), (Matcher)Matchers.is((Object)FileTypesByExtension.Type.CODE));
        MatcherAssert.assertThat((String)"valid extension recognised - TEXT", (Object)this.ftbe.getFileType("txt"), (Matcher)Matchers.is((Object)FileTypesByExtension.Type.TEXT));
        MatcherAssert.assertThat((String)"extensions are case insensitive", (Object)this.ftbe.getFileType("ZiP"), (Matcher)Matchers.is((Object)FileTypesByExtension.Type.ARCHIVE));
        MatcherAssert.assertThat((String)"null for unrecognised extension", (Object)this.ftbe.getFileType("xyz"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)"null for null extension", (Object)this.ftbe.getFileType(null), (Matcher)Matchers.nullValue());
    }
}

