/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util.functional;

import com.atlassian.fecru.util.functional.LazyIterable;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class LazyIterableTest {
    @Mock
    private Supplier<Iterable<String>> supplierMock;
    private Collection<String> someStringCollection = ImmutableList.of((Object)"first", (Object)"second");

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.supplierMock.get()).thenReturn(this.someStringCollection);
    }

    @Test
    public void testLazyIterable() throws Exception {
        Iterable lazyIterable = LazyIterable.lazyIterable(this.supplierMock);
        ((Supplier)Mockito.verify(this.supplierMock, (VerificationMode)Mockito.never())).get();
        Assert.assertThat((Object)Lists.newArrayList(lazyIterable.iterator()), (Matcher)Matchers.contains((Object[])new String[]{"first", "second"}));
        ((Supplier)Mockito.verify(this.supplierMock, (VerificationMode)Mockito.times((int)1))).get();
        Assert.assertThat((Object)Lists.newArrayList(lazyIterable.iterator()), (Matcher)Matchers.contains((Object[])new String[]{"first", "second"}));
        ((Supplier)Mockito.verify(this.supplierMock, (VerificationMode)Mockito.times((int)2))).get();
    }

    @Test
    public void testLazyMemoizedIterable() throws Exception {
        Iterable lazyIterable = LazyIterable.lazyMemoizedIterable(this.supplierMock);
        ((Supplier)Mockito.verify(this.supplierMock, (VerificationMode)Mockito.never())).get();
        Assert.assertThat((Object)Lists.newArrayList(lazyIterable.iterator()), (Matcher)Matchers.contains((Object[])new String[]{"first", "second"}));
        ((Supplier)Mockito.verify(this.supplierMock, (VerificationMode)Mockito.times((int)1))).get();
        Assert.assertThat((Object)Lists.newArrayList(lazyIterable.iterator()), (Matcher)Matchers.contains((Object[])new String[]{"first", "second"}));
        ((Supplier)Mockito.verify(this.supplierMock, (VerificationMode)Mockito.times((int)1))).get();
    }
}

