/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util;

import com.atlassian.fecru.util.SafeSAXXMLReaderFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SafeSAXXMLReaderFactoryTest {
    @Test
    public void testOneBillionLols() throws SAXException, ParserConfigurationException, IOException, ParsingException {
        String BILLION_LAUGHS = "<?xml version=\"1.0\"?>\n<!DOCTYPE lolz [\n  <!ENTITY lol \"lol\">\n  <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\n  <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\">\n  <!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\n  <!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\n  <!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\n  <!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\n  <!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\n  <!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\n  <!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">]><x>&lol9;</x>";
        try {
            XMLReader safeReader = new SafeSAXXMLReaderFactory().newSafeXMLReader();
            Document doc = this.parseDocWithReader("<?xml version=\"1.0\"?>\n<!DOCTYPE lolz [\n  <!ENTITY lol \"lol\">\n  <!ENTITY lol1 \"&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;&lol;\">\n  <!ENTITY lol2 \"&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;&lol1;\">\n  <!ENTITY lol3 \"&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;&lol2;\">\n  <!ENTITY lol4 \"&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;&lol3;\">\n  <!ENTITY lol5 \"&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;&lol4;\">\n  <!ENTITY lol6 \"&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;&lol5;\">\n  <!ENTITY lol7 \"&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;&lol6;\">\n  <!ENTITY lol8 \"&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;&lol7;\">\n  <!ENTITY lol9 \"&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;&lol8;\">]><x>&lol9;</x>", safeReader);
            Assert.fail((String)"Should fail after hitting entity expansion limit");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNewSafeXMLReader() throws SAXException, ParserConfigurationException, IOException, ParsingException {
        File secretFile = File.createTempFile(this.getClass().getCanonicalName(), "txt");
        secretFile.deleteOnExit();
        IOUtils.write((String)"TOP SECRET", (OutputStream)new FileOutputStream(secretFile));
        String xml = "<!DOCTYPE soapenv:Envelope [<!ENTITY readme SYSTEM \"file:///" + secretFile.getAbsolutePath() + "\">]>" + "<config>&readme;</config>";
        this.assertBadXMLisBad(xml, "TOP SECRET");
        this.assertSafeSAXIsSafe(xml, "");
    }

    private void assertSafeSAXIsSafe(String xml, String expectedRootValue) throws SAXException, ParserConfigurationException, ParsingException, IOException {
        XMLReader safeReader = new SafeSAXXMLReaderFactory().newSafeXMLReader();
        Document doc = this.parseDocWithReader(xml, safeReader);
        Assert.assertEquals((Object)expectedRootValue, (Object)doc.getRootElement().getValue());
    }

    private void assertBadXMLisBad(String xml, String expectedRootValue) throws SAXException, ParserConfigurationException, ParsingException, IOException {
        XMLReader badReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        Document doc2 = this.parseDocWithReader(xml, badReader);
        Assert.assertEquals((Object)expectedRootValue, (Object)doc2.getRootElement().getValue());
    }

    private Document parseDocWithReader(String xml, XMLReader safeReader) throws ParsingException, IOException {
        Builder builder = new Builder(safeReader);
        return builder.build((InputStream)new ByteArrayInputStream(xml.getBytes()), "file:///");
    }
}

