/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util;

import com.atlassian.fecru.util.PreGeneratedPoolSupplier;
import com.google.common.base.Supplier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PreGeneratedPoolSupplierTest {
    private ExecutorService executorService;

    @Before
    public void setUp() throws Exception {
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @After
    public void tearDown() throws Exception {
        this.executorService.shutdown();
    }

    @Test(timeout=2000L)
    public void testGetFromPool() throws Exception {
        IntSupplier supplier = this.createSpiedSupplier(201);
        PreGeneratedPoolSupplier<Integer> pool = this.createPool(supplier, 3);
        ((IntSupplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.timeout((long)1000L).atLeast(3))).get();
        Assert.assertThat((Object)pool.get(), (Matcher)Matchers.is((Object)201));
        Assert.assertThat((Object)pool.get(), (Matcher)Matchers.is((Object)202));
        Assert.assertThat((Object)pool.get(), (Matcher)Matchers.is((Object)203));
        Assert.assertThat((Object)pool.get(), (Matcher)Matchers.is((Object)204));
        Assert.assertThat((Object)pool.get(), (Matcher)Matchers.is((Object)205));
        ((IntSupplier)Mockito.verify((Object)supplier, (VerificationMode)Mockito.atLeast((int)5))).get();
    }

    private IntSupplier createSpiedSupplier(int from) {
        return (IntSupplier)Mockito.spy((Object)new IntSupplier(from));
    }

    private <T> PreGeneratedPoolSupplier<T> createPool(Supplier<T> supplier, int poolSize) {
        PreGeneratedPoolSupplier pool = new PreGeneratedPoolSupplier(supplier, poolSize, 10, this.executorService);
        pool.triggerRefill();
        return pool;
    }

    static class IntSupplier
    implements Supplier<Integer> {
        private final AtomicInteger value;

        IntSupplier(int from) {
            this.value = new AtomicInteger(from);
        }

        public Integer get() {
            return this.value.getAndIncrement();
        }
    }
}

