/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util;

import com.atlassian.fecru.util.Patterns;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class PatternsTest {
    Pattern abPattern = Pattern.compile("[ab]");
    Pattern bcPattern = Pattern.compile("[bc]");

    @Test
    public void testCombinedAbMatchesANotC() throws Exception {
        Pattern combined = Patterns.combine((Pattern[])new Pattern[]{this.abPattern});
        this.assertMatches(combined, "a", true);
        this.assertMatches(combined, "c", false);
    }

    @Test
    public void testCombinedAbAndBcMatchesAAndC() throws Exception {
        Pattern combined = Patterns.combine((Pattern[])new Pattern[]{this.abPattern, this.bcPattern});
        this.assertMatches(combined, "a", true);
        this.assertMatches(combined, "c", true);
    }

    @Test
    public void testEmbeddedFlags() throws Exception {
        MatcherAssert.assertThat((Object)Patterns.embeddedFlags((int)0), (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((Object)Patterns.embeddedFlags((int)111), (Matcher)Matchers.is((Object)"(?idmsux)"));
    }

    private void assertMatches(Pattern combined, String sequence, boolean found) {
        MatcherAssert.assertThat((Object)combined.matcher(sequence).find(), (Matcher)Matchers.is((Object)found));
    }
}

