/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util;

import com.atlassian.fecru.util.EggTimer;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.junit.Test;

public class EggTimerTest {
    private void testStartViaCtor(long timeAllowed, TimeUnit timeUnit, boolean shouldBeInitiallyExpired, long nanosToElase, boolean shouldExpire) {
        long time = 0L;
        TestableEggTimer testable = new TestableEggTimer(timeAllowed, timeUnit, time);
        Assert.assertEquals((String)String.format("EggTimer should have%s time left", shouldBeInitiallyExpired ? " no" : ""), (boolean)shouldBeInitiallyExpired, (boolean)testable.isTimeExpired());
        testable.setCurrentTime(time += nanosToElase);
        Assert.assertEquals((String)String.format("EggTimer should have%s time left", shouldExpire ? " no" : ""), (boolean)shouldExpire, (boolean)testable.isTimeExpired());
    }

    @Test
    public void testNegativeAllowedTimeViaCtor() {
        this.testStartViaCtor(-1L, TimeUnit.NANOSECONDS, true, 1L, true);
    }

    @Test
    public void testZeroAllowedTimeViaCtor() {
        this.testStartViaCtor(0L, TimeUnit.NANOSECONDS, true, 1L, true);
    }

    @Test
    public void testPositiveAllowedTimeViaCtor() {
        this.testStartViaCtor(1L, TimeUnit.NANOSECONDS, false, 1L, true);
    }

    @Test
    public void testLargePositiveAllowedTimeViaCtor() {
        this.testStartViaCtor(20000000L, TimeUnit.NANOSECONDS, false, 1L, false);
    }

    @Test
    public void testWithLargeTimeUnits() {
        this.testStartViaCtor(2L, TimeUnit.SECONDS, false, TimeUnit.SECONDS.toNanos(2L) - 1L, false);
        this.testStartViaCtor(2L, TimeUnit.SECONDS, false, TimeUnit.SECONDS.toNanos(2L) + 1L, true);
    }

    @Test
    public void testCallsToIsTimeExpiredAreIdempotent() {
        long timeAllowed = 1L;
        long time = 0L;
        TestableEggTimer testable = new TestableEggTimer(timeAllowed, TimeUnit.NANOSECONDS, time);
        Assert.assertEquals((String)"EggTimer should have time left", (boolean)false, (boolean)testable.isTimeExpired());
        Assert.assertEquals((String)"EggTimer should still have time left", (boolean)false, (boolean)testable.isTimeExpired());
        testable.setCurrentTime(time += timeAllowed);
        Assert.assertEquals((String)"EggTimer should have no time left", (boolean)true, (boolean)testable.isTimeExpired());
        Assert.assertEquals((String)"EggTimer should still have no time left", (boolean)true, (boolean)testable.isTimeExpired());
    }

    private class TestableEggTimer
    extends EggTimer {
        public long currentTime;

        TestableEggTimer(long timeAmount, TimeUnit timeUnit, long currentTime) {
            super(timeAmount, timeUnit);
            this.currentTime = currentTime;
        }

        protected long getCurrentNanoTime() {
            return this.currentTime;
        }

        public void setCurrentTime(long nanos) {
            this.currentTime = nanos;
        }
    }
}

