/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.util;

import com.atlassian.fecru.util.CapturingLog4jAppender;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.rules.ExternalResource;

public class CaptureLog4jLogsRule
extends ExternalResource {
    private final CapturingLog4jAppender appender = new CapturingLog4jAppender();
    @Nullable
    private final Level requestedLevel;
    @Nullable
    private Level previousRootLevel;
    @Nullable
    private Priority previousConsoleAppenderLevel;

    public CaptureLog4jLogsRule(@Nullable Level level) {
        this.requestedLevel = level;
    }

    public CaptureLog4jLogsRule() {
        this(null);
    }

    protected void before() throws Throwable {
        if (this.requestedLevel != null) {
            this.previousRootLevel = Logger.getRootLogger().getLevel();
            Logger.getRootLogger().setLevel(this.requestedLevel);
            this.previousConsoleAppenderLevel = this.getConsoleAppender().getThreshold();
            this.getConsoleAppender().setThreshold((Priority)this.requestedLevel);
        }
        Logger.getRootLogger().addAppender((Appender)this.appender);
    }

    private AppenderSkeleton getConsoleAppender() {
        return (AppenderSkeleton)Logger.getRootLogger().getAppender("A1");
    }

    protected void after() {
        if (this.previousRootLevel != null) {
            Logger.getRootLogger().setLevel(this.previousRootLevel);
        }
        if (this.previousConsoleAppenderLevel != null) {
            this.getConsoleAppender().setThreshold(this.previousConsoleAppenderLevel);
        }
        Logger.getRootLogger().removeAppender((Appender)this.appender);
    }

    public List<LoggingEvent> getEvents() {
        return this.appender.getEvents();
    }

    public static class LogWithMessage
    extends TypeSafeMatcher<LoggingEvent> {
        private final Matcher<String> matcher;

        public LogWithMessage(String message) {
            this.matcher = Matchers.equalTo((Object)message);
        }

        public LogWithMessage(Matcher<String> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(LoggingEvent event) {
            return this.matcher.matches(event.getMessage());
        }

        public void describeTo(Description description) {
            description.appendText("event with message ").appendValue(this.matcher);
        }
    }

    public static class LogWithLevel
    extends TypeSafeMatcher<LoggingEvent> {
        private final Level level;

        public LogWithLevel(Level level) {
            this.level = level;
        }

        protected boolean matchesSafely(LoggingEvent event) {
            return this.level.equals((Object)event.getLevel());
        }

        public void describeTo(Description description) {
            description.appendText("event with level ").appendValue((Object)this.level);
        }
    }
}

