/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.usersettings;

import com.atlassian.fecru.user.EffectiveUserProviderImpl;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.usersettings.UserSettingsManagerImpl;
import com.atlassian.fisheye.spi.TxTemplate;
import com.atlassian.fisheye.spi.impl.DefaultTxTemplate;
import com.atlassian.fugue.Option;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.google.common.base.Strings;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserSettingsManagerImplTest {
    private UserSettingsManagerImpl userSettingsManager;
    private FecruUser fred;
    private FecruUser jim;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.loadSanity1();
        this.userSettingsManager = new UserSettingsManagerImpl((TxTemplate)new DefaultTxTemplate(new EffectiveUserProviderImpl()));
        this.fred = ModelUtils.makeAndSaveUser("fred");
        this.jim = ModelUtils.makeAndSaveUser("jim");
    }

    @After
    public void tearDown() throws Exception {
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testNoSettings() {
        Assert.assertTrue((boolean)this.userSettingsManager.getKeys(this.fred).isEmpty());
    }

    @Test
    public void testCreateSettings() {
        this.userSettingsManager.putBoolean(this.fred, "foo-true", true);
        this.userSettingsManager.putBoolean(this.fred, "foo-false", false);
        this.userSettingsManager.putString(this.fred, "bar", "barvalue");
        this.userSettingsManager.putLong(this.fred, "baz", 1234L);
        Assert.assertTrue((boolean)this.userSettingsManager.getSettings(this.jim).isEmpty());
        Assert.assertEquals((long)4L, (long)this.userSettingsManager.getKeys(this.fred).size());
        Map settings = this.userSettingsManager.getSettings(this.fred);
        Assert.assertEquals((long)4L, (long)settings.size());
        Assert.assertTrue((boolean)((Boolean)this.userSettingsManager.getBoolean(this.fred, "foo-true").get()));
        junit.framework.Assert.assertFalse((boolean)((Boolean)this.userSettingsManager.getBoolean(this.fred, "foo-false").get()));
        Assert.assertEquals((Object)"barvalue", (Object)this.userSettingsManager.getString(this.fred, "bar").get());
        Assert.assertEquals((long)1234L, (long)((Long)this.userSettingsManager.getLong(this.fred, "baz").get()));
        try {
            this.userSettingsManager.getString(this.fred, "foo-true");
            Assert.fail((String)"exception expected");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((Object)Option.none(), (Object)this.userSettingsManager.getBoolean(this.jim, "foo-true"));
    }

    @Test
    public void testUpdateSettings() {
        this.userSettingsManager.putString(this.jim, "bar", "barvalue");
        Assert.assertEquals((Object)"barvalue", (Object)this.userSettingsManager.getString(this.jim, "bar").get());
        this.userSettingsManager.putBoolean(this.jim, "bar", true);
        try {
            this.userSettingsManager.getString(this.jim, "bar");
            Assert.fail((String)"exception expected");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        Assert.assertEquals((Object)true, (Object)this.userSettingsManager.getBoolean(this.jim, "bar").get());
    }

    @Test
    public void testRemoveSettings() {
        this.userSettingsManager.putString(this.jim, "bar", "barvalue");
        Assert.assertEquals((Object)"barvalue", (Object)this.userSettingsManager.getString(this.jim, "bar").get());
        this.userSettingsManager.remove(this.jim, "bar");
        Assert.assertEquals((Object)Option.none(), (Object)this.userSettingsManager.getString(this.jim, "bar"));
    }

    @Test
    public void testLongKey() {
        String cc = Strings.repeat((String)"x", (int)200);
        this.userSettingsManager.putString(this.jim, cc, "test1");
        Assert.assertEquals((Object)"test1", (Object)this.userSettingsManager.getString(this.jim, cc).get());
        try {
            this.userSettingsManager.putString(this.jim, cc + "a", "test2");
            Assert.fail((String)"Exception expected");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testNulls() {
        try {
            this.userSettingsManager.putString(this.jim, "key", null);
            Assert.fail((String)"Exception expected -- null value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.userSettingsManager.putString(this.jim, null, "x");
            Assert.fail((String)"Exception expected -- null key");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

