/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user.crowd.dao;

import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.ImmutableDirectory;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.UserProfile;
import com.atlassian.fecru.user.crowd.batch.CrowdUserBatchProcessor;
import com.atlassian.fecru.user.crowd.batch.HibernateUtilBatchProcessor;
import com.atlassian.fecru.user.crowd.dao.CrowdUserDao;
import com.atlassian.fecru.util.CaptureLog4jLogsRule;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.fisheye.user.UserRenamer;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.log4j.Level;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@ContextConfiguration(value={"classpath:/tests-db-spring-context-crowd.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class CrowdUserDaoIntegrationTest {
    @Rule
    public CaptureLog4jLogsRule logs = new CaptureLog4jLogsRule();
    @Autowired
    DirectoryManager directoryManager;
    @Autowired
    FecruUserDAO userDAO;
    @Autowired
    UserRenamer userRenamer;
    @Autowired
    CurrentSessionProvider currentSessionProvider;
    @Autowired
    ApplicationContext context;
    @Autowired
    HibernateUtilBatchProcessor batchProcessor;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired
    PlatformTransactionManager txManager;
    CrowdUserDao crowdUserDao;

    @Before
    public void setUp() throws Exception {
        this.userRenamer = (UserRenamer)Mockito.spy((Object)this.userRenamer);
        this.crowdUserDao = new CrowdUserDao(this.userDAO, this.userRenamer);
        this.context.getAutowireCapableBeanFactory().autowireBeanProperties((Object)this.crowdUserDao, 2, true);
        this.crowdUserDao.setBatchProcessor((BatchProcessor)new CrowdUserBatchProcessor((BatchProcessor)this.batchProcessor, this.userDAO));
    }

    @BeforeTransaction
    public void createDirs() throws Exception {
        this.addDirectory(1L);
        this.addDirectory(2L);
    }

    @Test
    public void testAdd() throws Exception {
        this.crowdUserDao.add((User)new UserTemplate("user1", 1L), PasswordCredential.encrypted((String)"foo"));
        FecruUser fecruUser = this.userDAO.getByUsername("user1");
        Assert.assertNotNull((Object)fecruUser);
        Assert.assertThat((Object)fecruUser.isCrowdBacked(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAddAll() throws Exception {
        Set<UserTemplateWithCredentialAndAttributes> users = this.prepareUsers(10, 1);
        BatchResult result = this.withSeparateTransaction(tx -> this.crowdUserDao.addAll(users));
        List fecruUser = this.withSession(s -> s.createCriteria(FecruUser.class).list());
        List userProfile = this.withSession(s -> s.createCriteria(UserProfile.class).list());
        Assert.assertThat((Object)result.getTotalSuccessful(), (Matcher)Matchers.equalTo((Object)10));
        Assert.assertThat((Object)fecruUser, (Matcher)Matchers.hasSize((int)10));
        Assert.assertThat((Object)userProfile, (Matcher)Matchers.hasSize((int)10));
    }

    @Test
    public void testAddAll_shouldHandleDuplicates() throws Exception {
        this.withSeparateTransaction(tx -> {
            this.crowdUserDao.addAll(this.prepareUsers(15, 1));
            this.crowdUserDao.addAll(this.prepareUsers(20, 2));
            return null;
        });
        List fecruUser = this.withSession(s -> s.createCriteria(FecruUser.class).list());
        Assert.assertThat((Object)fecruUser, (Matcher)Matchers.hasSize((int)20));
    }

    @Test
    public void testRename() throws Exception {
        this.crowdUserDao.add((User)new UserTemplate("user1", 1L), PasswordCredential.encrypted((String)"foo"));
        this.crowdUserDao.rename((User)this.crowdUserDao.findByName(1L, "user1"), "user1024");
        FecruUser oldFecruUser = this.userDAO.getByUsername("user1");
        FecruUser renamedFecruUser = this.userDAO.getByUsername("user1024");
        Assert.assertThat((Object)oldFecruUser, (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)renamedFecruUser, (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)renamedFecruUser.getUsername(), (Matcher)Matchers.equalTo((Object)"user1024"));
    }

    @Test
    public void testRename_notCalledWhenCaseOnlyChange() throws Exception {
        this.crowdUserDao.add((User)new UserTemplate("user1", 1L), PasswordCredential.encrypted((String)"foo"));
        this.crowdUserDao.rename((User)this.crowdUserDao.findByName(1L, "user1"), "USER1");
        ((UserRenamer)Mockito.verify((Object)this.userRenamer, (VerificationMode)Mockito.never())).rename((String)Mockito.any(), (String)Mockito.any());
    }

    @Test
    public void testRename_shouldWarnWhenShadowsUser() throws Exception {
        UserTemplate user1 = new UserTemplate("user1", 1L);
        this.crowdUserDao.add((User)user1, PasswordCredential.encrypted((String)"foo"));
        this.crowdUserDao.remove((User)user1);
        this.crowdUserDao.add((User)new UserTemplate("user2", 1L), PasswordCredential.encrypted((String)"foo"));
        this.crowdUserDao.rename((User)this.crowdUserDao.findByName(1L, "user2"), "user1");
        ((UserRenamer)Mockito.verify((Object)this.userRenamer, (VerificationMode)Mockito.never())).rename((String)Mockito.any(), (String)Mockito.any());
        Assert.assertThat(this.logs.getEvents(), (Matcher)Matchers.hasItem((Matcher)Matchers.allOf((Matcher)new CaptureLog4jLogsRule.LogWithLevel(Level.WARN), (Matcher)new CaptureLog4jLogsRule.LogWithMessage((Matcher<String>)Matchers.allOf((Matcher)Matchers.containsString((String)"user1"), (Matcher)Matchers.containsString((String)"already exists"))))));
    }

    private void addDirectory(long directoryId) throws Exception {
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
        builder.setId(Long.valueOf(directoryId));
        builder.setName("dir" + directoryId);
        builder.setType(DirectoryType.INTERNAL);
        builder.setImplementationClass(InternalDirectory.class.getCanonicalName());
        this.directoryManager.addDirectory(builder.toDirectory());
    }

    private Set<UserTemplateWithCredentialAndAttributes> prepareUsers(int count, int directoryId) {
        return IntStream.rangeClosed(1, count).mapToObj(i -> new UserTemplateWithCredentialAndAttributes("user" + i, (long)directoryId, PasswordCredential.encrypted((String)"foobar"))).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withSession(Function<Session, T> sessionEffect) {
        try (Session session = this.sessionFactory.openSession();){
            T t = sessionEffect.apply(session);
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withSeparateTransaction(Function<TransactionStatus, T> txEffect) {
        TransactionStatus transaction = this.txManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(3));
        try {
            T t = txEffect.apply(transaction);
            return t;
        }
        finally {
            this.txManager.commit(transaction);
        }
    }
}

