/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user.crowd.dao;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.HibernateOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.TransactionGroup;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4.operation.DeleteOperation;
import com.atlassian.crowd.util.persistence.hibernate.batch.hibernate4.operation.MergeOperation;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.crowd.batch.CrowdUserBatchProcessor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CrowdUserBatchProcessorTest {
    @Mock
    FecruUserDAO userDAO;
    @Mock
    BatchProcessor<Session> batchProcessor;
    @InjectMocks
    CrowdUserBatchProcessor userBatchProcessor;
    @Captor
    ArgumentCaptor<Collection<Serializable>> argumentCaptor;

    @Test
    public void testExecute_returnsCleanedResults() throws Exception {
        TransactionGroup<InternalUser, InternalUserAttribute> user1 = this.createUserTransationGroup("user1");
        TransactionGroup<InternalUser, InternalUserAttribute> user2 = this.createUserTransationGroup("user2");
        ImmutableList users = ImmutableList.of(user1, user2);
        BatchResult batchResult = new BatchResult(2);
        batchResult.addSuccess(user1);
        batchResult.addFailure(user2);
        Mockito.when((Object)this.batchProcessor.execute((HibernateOperation)org.mockito.Matchers.any(), (Collection)org.mockito.Matchers.any())).thenAnswer(invocation -> {
            Collection objects = (Collection)invocation.getArguments()[1];
            BatchResult result = new BatchResult(2);
            result.addSuccess(Iterables.get((Iterable)objects, (int)0));
            result.addFailure(Iterables.get((Iterable)objects, (int)1));
            return result;
        });
        BatchResult wrapperResult = this.userBatchProcessor.execute((HibernateOperation)new MergeOperation(), (Collection)users);
        Assert.assertThat((String)"Should pass the results", (Object)wrapperResult.getFailedEntities(), (Matcher)Matchers.contains((Object[])new TransactionGroup[]{user2}));
        Assert.assertThat((String)"Shouldn't return additional FecruUser objects", (Object)((TransactionGroup)wrapperResult.getFailedEntities().get(0)).getDependantObjects(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(InternalUserAttribute.class)));
        Assert.assertThat((String)"Should pass the results", (Object)wrapperResult.getSuccessfulEntities(), (Matcher)Matchers.contains((Object[])new TransactionGroup[]{user1}));
        Assert.assertThat((String)"Shouldn't return additional FecruUser objects", (Object)((TransactionGroup)wrapperResult.getSuccessfulEntities().get(0)).getDependantObjects(), (Matcher)Matchers.contains((Matcher)Matchers.instanceOf(InternalUserAttribute.class)));
    }

    @Test
    public void testExecute_shouldAddFecruUserToDelegateCall() throws Exception {
        TransactionGroup<InternalUser, InternalUserAttribute> group = this.createUserTransationGroup("user1");
        ImmutableList users = ImmutableList.of(group);
        Mockito.when((Object)this.batchProcessor.execute((HibernateOperation)org.mockito.Matchers.any(), (Collection)org.mockito.Matchers.any())).thenReturn((Object)new BatchResult(0));
        this.userBatchProcessor.execute((HibernateOperation)new MergeOperation(), (Collection)users);
        ((BatchProcessor)Mockito.verify(this.batchProcessor)).execute((HibernateOperation)org.mockito.Matchers.argThat((Matcher)Matchers.instanceOf(MergeOperation.class)), (Collection)this.argumentCaptor.capture());
        FecruUser expectedUser = new FecruUser(((InternalUser)group.getPrimaryObject()).getName());
        Assert.assertThat((String)"Should add FecruUsers to InternalUsers", (Object)this.argumentCaptor.getValue(), (Matcher)Matchers.contains((Matcher)Matchers.hasProperty((String)"dependantObjects", (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.sameInstance((Object)Iterables.getOnlyElement((Iterable)group.getDependantObjects())), Matchers.allOf((Matcher)Matchers.equalTo((Object)expectedUser), (Matcher)Matchers.hasProperty((String)"userProfile", (Matcher)Matchers.hasProperty((String)"user", (Matcher)Matchers.equalTo((Object)expectedUser))))}))));
    }

    @Test
    public void testExecute_shouldNotModifyNonUserCalls() throws Exception {
        ImmutableList nonUserObjects = ImmutableList.of((Object)"foobar");
        Mockito.when((Object)this.batchProcessor.execute((HibernateOperation)org.mockito.Matchers.any(), (Collection)org.mockito.Matchers.any())).thenReturn((Object)new BatchResult(0));
        this.userBatchProcessor.execute((HibernateOperation)new MergeOperation(), (Collection)nonUserObjects);
        ((BatchProcessor)Mockito.verify(this.batchProcessor)).execute((HibernateOperation)org.mockito.Matchers.argThat((Matcher)Matchers.instanceOf(MergeOperation.class)), (Collection)org.mockito.Matchers.eq((Object)nonUserObjects));
    }

    @Test
    public void testExecute_shouldNotModifyNonMergeCalls() throws Exception {
        ImmutableList users = ImmutableList.of(this.createUserTransationGroup("user1"));
        this.userBatchProcessor.execute((HibernateOperation)new DeleteOperation(), (Collection)users);
        ((BatchProcessor)Mockito.verify(this.batchProcessor)).execute((HibernateOperation)org.mockito.Matchers.argThat((Matcher)Matchers.instanceOf(DeleteOperation.class)), (Collection)this.argumentCaptor.capture());
        Assert.assertThat((String)"Should not add FecruUsers to InternalUsers for non merge operations", (Object)this.argumentCaptor.getValue(), (Matcher)Matchers.contains((Matcher)Matchers.hasProperty((String)"dependantObjects", (Matcher)Matchers.everyItem((Matcher)Matchers.instanceOf(InternalUserAttribute.class)))));
    }

    private TransactionGroup<InternalUser, InternalUserAttribute> createUserTransationGroup(String username) {
        InternalUser user = this.mockInternalUser(username);
        return new TransactionGroup((Serializable)user, (Collection)ImmutableList.of((Object)new InternalUserAttribute(user, "key", "value")));
    }

    private InternalUser mockInternalUser(String username) {
        InternalUser user = (InternalUser)Mockito.mock(InternalUser.class);
        Mockito.when((Object)user.getName()).thenReturn((Object)username);
        Directory directory = (Directory)Mockito.mock(Directory.class);
        Mockito.when((Object)user.getDirectory()).thenReturn((Object)directory);
        Mockito.when((Object)user.getLowerName()).thenReturn((Object)IdentifierUtils.toLowerCase((String)username));
        return user;
    }
}

