/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.hibernate.CrowdAwareUserLoadListener;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EventType;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.junit.rules.ExternalResource;
import org.springframework.beans.factory.annotation.Autowired;

public class UserTestRule
extends ExternalResource {
    @Autowired
    SessionFactoryImplementor sessionFactory;
    @Autowired
    CurrentSessionProvider sessionProvider;
    @Autowired
    TxTemplate txTemplate;
    @Autowired
    FecruUserDAO userDAO;
    boolean addedListeners;

    public List<Integer> addUsersAndFlush(FecruUser ... users) {
        ImmutableList.Builder ids = ImmutableList.builder();
        this.txTemplate.execute(status -> {
            Arrays.stream(users).forEach(user -> {
                this.userDAO.create(user);
                ids.add((Object)user.getId());
            });
            return null;
        });
        this.sessionProvider.currentSession().flush();
        this.sessionProvider.currentSession().clear();
        return ids.build();
    }

    protected void after() {
        if (this.addedListeners && !this.sessionFactory.isClosed()) {
            this.cleanupListeners(this.getListenerRegistry());
        }
    }

    public void setupFecruUserListener(CrowdService crowdService) {
        this.setupFecruUserListener((String username) -> crowdService.getUser(username));
    }

    public void setupFecruUserListener(final Function<String, User> userLoader) {
        CrowdAwareUserLoadListener userLoadListener = new CrowdAwareUserLoadListener(){

            protected User getCrowdUser(String username) {
                return (User)userLoader.apply(username);
            }
        };
        EventListenerRegistry eventListenerRegistry = this.getListenerRegistry();
        eventListenerRegistry.getEventListenerGroup(EventType.POST_LOAD).appendListener((Object)userLoadListener);
        eventListenerRegistry.getEventListenerGroup(EventType.LOAD).appendListener((Object)userLoadListener);
        this.addedListeners = true;
    }

    private EventListenerRegistry getListenerRegistry() {
        ServiceRegistryImplementor serviceRegistry = this.sessionFactory.getServiceRegistry();
        return (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
    }

    private void cleanupListeners(EventListenerRegistry eventListenerRegistry) {
        Iterables.removeIf((Iterable)eventListenerRegistry.getEventListenerGroup(EventType.POST_LOAD).listeners(), (Predicate)Predicates.instanceOf(CrowdAwareUserLoadListener.class));
        Iterables.removeIf((Iterable)eventListenerRegistry.getEventListenerGroup(EventType.LOAD).listeners(), (Predicate)Predicates.instanceOf(CrowdAwareUserLoadListener.class));
    }
}

