/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fisheye.user.permissions.GlobalPermissionManager;
import com.atlassian.fisheye.user.permissions.GlobalPermissionType;
import com.atlassian.fisheye.user.permissions.cache.GlobalPermissionCache;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.user.GroupMembershipManager;
import com.cenqua.fisheye.user.UserManager;
import com.google.common.base.Preconditions;
import org.junit.rules.ExternalResource;
import org.springframework.beans.factory.annotation.Autowired;

public class UserPermissionsTestRule
extends ExternalResource {
    private static final String FE_GROUP = "fe";
    private static final String FECRU_GROUP = "crc";
    @Autowired
    UserManager userManager;
    @Autowired
    private final GlobalPermissionCache globalPermissionCache;
    @Autowired
    GroupMembershipManager groupMembershipManager;
    @Autowired
    GlobalPermissionManager globalPermissionManager;

    @Autowired
    public UserPermissionsTestRule(GlobalPermissionManager globalPermissionManager, GlobalPermissionCache globalPermissionCache, GroupMembershipManager groupMembershipManager, UserManager userManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.globalPermissionCache = globalPermissionCache;
        this.groupMembershipManager = groupMembershipManager;
        this.userManager = userManager;
    }

    public void before() throws Exception {
        this.userManager.addGroup(FE_GROUP);
        this.userManager.addGroup(FECRU_GROUP);
        this.globalPermissionManager.setPermissionsForGroup(FECRU_GROUP, GlobalPermissionType.FISHEYE_AND_CRUCIBLE);
        this.globalPermissionManager.setPermissionsForGroup(FE_GROUP, GlobalPermissionType.FISHEYE_USER);
    }

    public void after() {
        this.globalPermissionManager.removeAllPermissionsForGroup(FECRU_GROUP);
        this.globalPermissionManager.removeAllPermissionsForGroup(FE_GROUP);
        this.userManager.deleteGroup(FE_GROUP);
        this.userManager.deleteGroup(FECRU_GROUP);
    }

    public FecruUser addFecruUser(String username) throws LicensePolicyException {
        return this.addFecruUser(username, username, username);
    }

    public FecruUser addFecruUser(String username, String displayName, String email) throws LicensePolicyException {
        return this.addUser(username, displayName, email, FECRU_GROUP);
    }

    public FecruUser addFisheyeUser(String username) throws LicensePolicyException {
        return this.addFisheyeUser(username, username, username);
    }

    public FecruUser addFisheyeUser(String username, String displayName, String email) throws LicensePolicyException {
        return this.addUser(username, displayName, email, FE_GROUP);
    }

    private FecruUser addUser(String username, String displayName, String email, String groupMember) throws LicensePolicyException {
        if (!this.userManager.existsLicensedUser(username)) {
            this.userManager.addUser(username, displayName, email, username, false);
        }
        this.groupMembershipManager.addUserToGroup(groupMember, username);
        this.globalPermissionCache.invalidateAll();
        return (FecruUser)Preconditions.checkNotNull((Object)this.userManager.getLicensedUser(username), (Object)("Failed to create user " + username));
    }
}

