/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.UserMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class UserMatcherTest {
    @Test
    public void testMatchesSafely() {
        FecruUser joe = new FecruUser(Integer.valueOf(10), "joe");
        FecruUser bob = new FecruUser(Integer.valueOf(23), "Bob");
        UserMatcher usernameJoeMatcher = new UserMatcher.Builder().withUserName("joe").build();
        UserMatcher key23Matcher = new UserMatcher.Builder().withKey(23).build();
        UserMatcher usernameJoeKey23Matcher = new UserMatcher.Builder().withUserName("joe").withKey(23).build();
        UserMatcher usernameJoeKey10Matcher = new UserMatcher.Builder().withUserName("joe").withKey(10).build();
        Assert.assertThat((String)"joe has username joe", (Object)joe, (Matcher)usernameJoeMatcher);
        Assert.assertThat((String)"bob doesn't have username joe", (Object)bob, (Matcher)Matchers.not((Matcher)usernameJoeMatcher));
        Assert.assertThat((String)"joe doesn't have key 23", (Object)joe, (Matcher)Matchers.not((Matcher)key23Matcher));
        Assert.assertThat((String)"bob has key 23", (Object)bob, (Matcher)key23Matcher);
        Assert.assertThat((String)"joe has username joe but key is not 23", (Object)joe, (Matcher)Matchers.not((Matcher)usernameJoeKey23Matcher));
        Assert.assertThat((String)"bob has they key of 23, but username is not joe", (Object)bob, (Matcher)Matchers.not((Matcher)usernameJoeKey23Matcher));
        Assert.assertThat((String)"joe has username joe and key 10", (Object)joe, (Matcher)usernameJoeKey10Matcher);
        Assert.assertThat((String)"bob's username is not joe and key is not 10", (Object)bob, (Matcher)Matchers.not((Matcher)usernameJoeKey10Matcher));
    }
}

