/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.fecru.user.FecruUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class UserMatcher
extends TypeSafeMatcher<FecruUser> {
    private final Matcher<String> userNameMatcher;
    private final Matcher<Integer> keyMatcher;

    private UserMatcher(@Nonnull Matcher<String> userNameMatcher, @Nonnull Matcher<Integer> keyMatcher) {
        super(FecruUser.class);
        this.userNameMatcher = userNameMatcher;
        this.keyMatcher = keyMatcher;
    }

    protected boolean matchesSafely(FecruUser user) {
        return this.userNameMatcher.matches((Object)user.getUsername()) && this.keyMatcher.matches((Object)user.getKey());
    }

    public void describeTo(Description description) {
        description.appendText("expected username: ");
        this.userNameMatcher.describeTo(description);
        description.appendText(", key: ");
        this.keyMatcher.describeTo(description);
    }

    public static class Builder {
        private Matcher<String> userNameMatcher = Matchers.any(String.class);
        private Matcher<Integer> keyMatcher = Matchers.any(Integer.class);

        public Builder withUserName(@Nonnull Matcher<String> userNameMatcher) {
            this.userNameMatcher = (Matcher)Preconditions.checkNotNull(userNameMatcher);
            return this;
        }

        public Builder withUserName(@Nonnull String userName) {
            return this.withUserName((Matcher<String>)Matchers.equalTo((Object)Preconditions.checkNotNull((Object)userName)));
        }

        public Builder withKey(@Nonnull Matcher<Integer> keyMatcher) {
            this.keyMatcher = (Matcher)Preconditions.checkNotNull(keyMatcher);
            return this;
        }

        public Builder withKey(@Nonnull Integer key) {
            return this.withKey((Matcher<Integer>)Matchers.equalTo((Object)Preconditions.checkNotNull((Object)key)));
        }

        public UserMatcher build() {
            return new UserMatcher(this.userNameMatcher, this.keyMatcher);
        }
    }
}

