/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.HibernateLoginCookieDAO;
import com.cenqua.fisheye.user.LoginCookie;
import java.util.Random;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level2-dao.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class HibernateLoginCookieDAOTest {
    @Autowired
    private HibernateLoginCookieDAO loginCookieDAO;
    @Autowired
    private FecruUserDAO userDAO;
    @Autowired
    private SessionFactory sessionFactory;
    private final Random rnd = new Random();

    @Test
    public void testAddCookie() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        LoginCookie loginCookie1 = this.generateRememberMeCookie(user);
        LoginCookie loginCookie2 = this.generatePreCookedUrlCookie(user);
        MatcherAssert.assertThat((Object)loginCookie1.getLoginId(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)loginCookie2.getLoginId(), (Matcher)Matchers.nullValue());
        this.loginCookieDAO.addCookie(loginCookie1);
        this.loginCookieDAO.addCookie(loginCookie2);
        MatcherAssert.assertThat((Object)loginCookie1.getLoginId(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)loginCookie2.getLoginId(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void testAddCookieAndValidate() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        LoginCookie loginCookie = this.generateRememberMeCookie(user);
        this.loginCookieDAO.addCookie(loginCookie);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        LoginCookie loginCookieReRead = this.loginCookieDAO.findCookie(loginCookie.getLoginId());
        MatcherAssert.assertThat((Object)loginCookieReRead, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)loginCookie)));
        MatcherAssert.assertThat((Object)loginCookieReRead.getLoginId(), (Matcher)CoreMatchers.equalTo((Object)loginCookie.getLoginId()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getCreateDate(), (Matcher)CoreMatchers.equalTo((Object)loginCookie.getCreateDate()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getLoginCookieToken(), (Matcher)CoreMatchers.equalTo((Object)loginCookie.getLoginCookieToken()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getRnd(), (Matcher)CoreMatchers.equalTo((Object)loginCookie.getRnd()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getType(), (Matcher)CoreMatchers.equalTo((Object)loginCookie.getType()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getUrl(), (Matcher)CoreMatchers.equalTo((Object)loginCookie.getUrl()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getUser(), (Matcher)CoreMatchers.equalTo((Object)loginCookie.getUser()));
    }

    @Test(expected=Exception.class)
    public void testAddCookieForNonExistingUserFails() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        LoginCookie loginCookie = this.generateRememberMeCookie(user);
        this.loginCookieDAO.addCookie(loginCookie);
        this.sessionFactory.getCurrentSession().flush();
        Assert.fail((String)"created login cookie for non-existing user");
    }

    @Test
    public void testFindCookie() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        LoginCookie loginCookie1 = this.generateRememberMeCookie(user);
        LoginCookie loginCookie2 = this.generatePreCookedUrlCookie(user);
        this.loginCookieDAO.addCookie(loginCookie1);
        this.loginCookieDAO.addCookie(loginCookie2);
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookie(loginCookie1.getLoginId()), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookie(loginCookie2.getLoginId()), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookie(Long.valueOf(this.rnd.nextLong())), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testFindCookieWith() throws Exception {
        FecruUser user1 = new FecruUser(this.generateUserName());
        FecruUser user2 = new FecruUser(this.generateUserName());
        FecruUser user3 = new FecruUser(this.generateUserName());
        this.userDAO.create(user1);
        this.userDAO.create(user2);
        this.userDAO.create(user3);
        LoginCookie loginCookie1 = this.generatePreCookedUrlCookie(user1);
        LoginCookie loginCookie2 = this.generatePreCookedUrlCookie(user1);
        LoginCookie loginCookie3 = this.generateRememberMeCookie(user1);
        LoginCookie loginCookie4 = this.generateRememberMeCookie(user2);
        this.loginCookieDAO.addCookie(loginCookie1);
        this.loginCookieDAO.addCookie(loginCookie2);
        this.loginCookieDAO.addCookie(loginCookie3);
        this.loginCookieDAO.addCookie(loginCookie4);
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookies(user1, null, null, null, null), (Matcher)Matchers.containsInAnyOrder((Object[])new LoginCookie[]{loginCookie1, loginCookie2, loginCookie3}));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookies(user1, null, null, null, null), (Matcher)CoreMatchers.not((Matcher)Matchers.containsInAnyOrder((Object[])new LoginCookie[]{loginCookie4})));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookies(user3, null, null, null, null), (Matcher)Matchers.hasSize((int)0));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookies(user1, loginCookie3.getRnd(), null, null, null), (Matcher)Matchers.containsInAnyOrder((Object[])new LoginCookie[]{loginCookie3}));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookies(user1, null, Integer.valueOf(2), null, null), (Matcher)Matchers.containsInAnyOrder((Object[])new LoginCookie[]{loginCookie1, loginCookie2}));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookies(user1, null, null, loginCookie2.getUrl(), null), (Matcher)Matchers.containsInAnyOrder((Object[])new LoginCookie[]{loginCookie2}));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookies(user1, null, null, loginCookie2.getUrl(), Boolean.valueOf(loginCookie2.isRecursiveUrl())), (Matcher)Matchers.containsInAnyOrder((Object[])new LoginCookie[]{loginCookie2}));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookies(user1, null, null, loginCookie2.getUrl(), Boolean.valueOf(loginCookie2.isRecursiveUrl())), (Matcher)Matchers.containsInAnyOrder((Object[])new LoginCookie[]{loginCookie2}));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookies(user2, null, null, loginCookie1.getUrl(), Boolean.valueOf(loginCookie1.isRecursiveUrl())), (Matcher)Matchers.hasSize((int)0));
    }

    @Test(expected=Exception.class)
    public void testFindCookieWithNoUser() throws Exception {
        FecruUser user1 = new FecruUser(this.generateUserName());
        FecruUser user2 = new FecruUser(this.generateUserName());
        this.userDAO.create(user1);
        this.userDAO.create(user2);
        LoginCookie loginCookie1 = this.generatePreCookedUrlCookie(user1);
        LoginCookie loginCookie2 = this.generatePreCookedUrlCookie(user1);
        this.loginCookieDAO.addCookie(loginCookie1);
        this.loginCookieDAO.addCookie(loginCookie2);
        MatcherAssert.assertThat((Object)this.loginCookieDAO.findCookies(user1, null, null, null, null), (Matcher)Matchers.containsInAnyOrder((Object[])new LoginCookie[]{loginCookie1, loginCookie2}));
        this.loginCookieDAO.findCookies(null, loginCookie1.getRnd(), null, null, null);
        Assert.fail((String)"searching for cookies with user not specified");
    }

    @Test
    public void testUpdateCookie() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        LoginCookie loginCookie = this.generateRememberMeCookie(user);
        this.loginCookieDAO.addCookie(loginCookie);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().evict((Object)loginCookie);
        LoginCookie loginCookieModified = this.generateRememberMeCookie(user);
        loginCookieModified.setLoginId(loginCookie.getLoginId());
        loginCookieModified.setUser(loginCookie.getUser());
        this.loginCookieDAO.updateCookie(loginCookieModified);
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        LoginCookie loginCookieReRead = this.loginCookieDAO.findCookie(loginCookie.getLoginId());
        MatcherAssert.assertThat((Object)loginCookieReRead, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance((Object)loginCookieModified)));
        MatcherAssert.assertThat((Object)loginCookieReRead.getLoginId(), (Matcher)CoreMatchers.equalTo((Object)loginCookieModified.getLoginId()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getCreateDate(), (Matcher)CoreMatchers.equalTo((Object)loginCookieModified.getCreateDate()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getLoginCookieToken(), (Matcher)CoreMatchers.equalTo((Object)loginCookieModified.getLoginCookieToken()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getRnd(), (Matcher)CoreMatchers.equalTo((Object)loginCookieModified.getRnd()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getType(), (Matcher)CoreMatchers.equalTo((Object)loginCookieModified.getType()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getUrl(), (Matcher)CoreMatchers.equalTo((Object)loginCookieModified.getUrl()));
        MatcherAssert.assertThat((Object)loginCookieReRead.getUser(), (Matcher)CoreMatchers.equalTo((Object)loginCookieModified.getUser()));
    }

    @Test
    public void testDeleteCookie() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        LoginCookie loginCookie1 = this.generateRememberMeCookie(user);
        LoginCookie loginCookie2 = this.generateRememberMeCookie(user);
        this.loginCookieDAO.addCookie(loginCookie1);
        this.loginCookieDAO.addCookie(loginCookie2);
        MatcherAssert.assertThat((Object)this.loginCookieDAO.listCookies(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.deleteCookie(loginCookie1.getUser(), loginCookie1.getLoginId()), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.listCookies(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    public void testDeleteCookies() throws Exception {
        FecruUser user = new FecruUser(this.generateUserName());
        this.userDAO.create(user);
        LoginCookie loginCookie1 = this.generateRememberMeCookie(user);
        loginCookie1.setType(2);
        LoginCookie loginCookie2 = this.generateRememberMeCookie(user);
        loginCookie2.setType(2);
        LoginCookie loginCookie3 = this.generateRememberMeCookie(user);
        loginCookie3.setType(1);
        this.loginCookieDAO.addCookie(loginCookie1);
        this.loginCookieDAO.addCookie(loginCookie2);
        this.loginCookieDAO.addCookie(loginCookie3);
        MatcherAssert.assertThat((Object)this.loginCookieDAO.listCookies(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.deleteCookies(loginCookie1.getUser(), loginCookie1.getType()), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.loginCookieDAO.listCookies(), (Matcher)Matchers.hasSize((int)1));
    }

    private LoginCookie generatePreCookedUrlCookie(FecruUser user) {
        String random = this.generateRnd();
        String url = this.generateUrl();
        boolean recursiveUrl = this.rnd.nextBoolean();
        return LoginCookie.createPreCookedUrlCookie((FecruUser)user, (String)random, (String)url, (boolean)recursiveUrl);
    }

    private LoginCookie generateRememberMeCookie(FecruUser user) {
        String random = this.generateRnd();
        return LoginCookie.createRememberMeCookie((FecruUser)user, (String)random);
    }

    private String generateUrl() {
        return "/test/logincookie/url/" + this.rnd.nextInt(Integer.MAX_VALUE);
    }

    private String generateRnd() {
        return "test_logincookie_random_" + this.rnd.nextInt(Integer.MAX_VALUE);
    }

    private String generateUserName() {
        return "test_logincookie_user_" + this.rnd.nextInt(Integer.MAX_VALUE);
    }
}

