/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.fecru.user.FecruUser;
import com.atlassian.fecru.user.FecruUserDAO;
import com.atlassian.fecru.user.UserTestRule;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.SessionFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.transaction.TransactionConfiguration;
import org.springframework.transaction.annotation.Transactional;

@TransactionConfiguration(defaultRollback=true)
@ContextConfiguration(value={"classpath:/tests-db-spring-context-level2-dao.xml"})
@Transactional
@RunWith(value=SpringJUnit4ClassRunner.class)
@DirtiesContext
public class FecruUserDAOImplTest {
    @Autowired
    FecruUserDAO userDAO;
    @Autowired
    SessionFactory sessionFactory;
    @Autowired
    CurrentSessionProvider sessionProvider;
    @Autowired
    TxTemplate txTemplate;
    @Autowired
    @Rule
    public UserTestRule userTestRule;

    @Test
    public void testLoadUsers_shouldOmitNullUsers() throws Exception {
        FecruUser tom = new FecruUser("tom");
        FecruUser don = new FecruUser("Don");
        this.userTestRule.addUsersAndFlush(tom, don);
        Iterable fecruUsers = this.userDAO.loadUsers((Iterable)ImmutableList.of((Object)ImmutableUser.newUser().name("don").toUser(), (Object)ImmutableUser.newUser().name("Fred").toUser(), (Object)ImmutableUser.newUser().name("TOM").toUser()));
        Assert.assertThat((Object)fecruUsers, (Matcher)Matchers.contains((Object[])new FecruUser[]{don, tom}));
    }

    @Test
    @DirtiesContext
    public void testLoadUsers_shouldntTriggerLoadingFecruUser() throws Exception {
        this.userTestRule.addUsersAndFlush(new FecruUser("tom"));
        this.userTestRule.setupFecruUserListener(username -> {
            throw new AssertionError((Object)"Shouldn't trigger loading");
        });
        Iterable users = this.userDAO.loadUsers((Iterable)ImmutableList.of((Object)ImmutableUser.newUser().name("tom").toUser()));
        Assert.assertThat((Object)((FecruUser)Iterables.getOnlyElement((Iterable)users)).getUsername(), (Matcher)Matchers.equalTo((Object)"tom"));
    }

    @Test
    public void testLoadUsers_shouldFillAllFecruUserFields() throws Exception {
        FecruUser tom = new FecruUser("tom");
        tom.setFailedLoginAttempts(1L);
        tom.setPasswordResetSRnd("srnd");
        tom.setPasswordResetTimeStamp(2L);
        this.userTestRule.addUsersAndFlush(tom);
        Iterable users = this.userDAO.loadUsers((Iterable)ImmutableList.of((Object)ImmutableUser.newUser().name("Tom").displayName("Display Tom").emailAddress("tom@tom").toUser()));
        FecruUser loadedDirectly = this.userDAO.getByUsername("tom");
        FecruUser loaded = (FecruUser)Iterables.getOnlyElement((Iterable)users);
        Assert.assertThat((Object)loaded.getUsername(), (Matcher)Matchers.equalTo((Object)"Tom"));
        Assert.assertThat((Object)loaded.getDisplayName(), (Matcher)Matchers.equalTo((Object)"Display Tom"));
        Assert.assertThat((Object)loaded.getEmail(), (Matcher)Matchers.equalTo((Object)"tom@tom"));
        Assert.assertThat((Object)loaded.getUserProfile(), (Matcher)Matchers.notNullValue());
        Assert.assertTrue((String)"Other fields should be equal", (boolean)EqualsBuilder.reflectionEquals((Object)loaded, (Object)loadedDirectly, (String[])new String[0]));
    }
}

