/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.user;

import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.directory.ImmutableDirectory;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.fisheye.spi.TxTemplate;
import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.Map;
import org.junit.rules.ExternalResource;
import org.springframework.beans.factory.annotation.Autowired;

public class CrowdTestRule
extends ExternalResource {
    public static final String APPLICATION_NAME = "crowd-embedded";
    public static final String INTERNAL_DIRECTORY = "Internal Directory";
    @Autowired
    DirectoryDao directoryDao;
    @Autowired
    ApplicationManager applicationManager;
    @Autowired
    TxTemplate txTemplate;
    @Autowired
    ApplicationDAO applicationDao;
    Application application;

    protected void before() throws Throwable {
        this.txTemplate.execute(transactionStatus -> {
            this.application = this.applicationManager.add((Application)ImmutableApplication.builder((String)APPLICATION_NAME, (ApplicationType)ApplicationType.CROWD).setActive(true).setPasswordCredential(PasswordCredential.NONE).build());
            return null;
        });
    }

    public Directory createInternalDirectory() throws ApplicationNotFoundException, DirectoryNotFoundException {
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder();
        builder.setName(INTERNAL_DIRECTORY);
        builder.setType(DirectoryType.INTERNAL);
        builder.setImplementationClass(InternalDirectory.class.getName());
        builder.setAttributes((Map)ImmutableMap.of((Object)"user_encryption_method", (Object)"atlassian-security"));
        Directory dir = builder.toDirectory();
        return this.addDirectory(dir);
    }

    public Directory addDirectory(Directory dir) throws ApplicationNotFoundException, DirectoryNotFoundException {
        ImmutableDirectory.Builder builder = ImmutableDirectory.newBuilder((Directory)dir);
        builder.setAllowedOperations(EnumSet.allOf(OperationType.class));
        Directory directory = this.directoryDao.add(builder.toDirectory());
        this.applicationManager.addDirectoryMapping(this.application, directory, true, OperationType.values());
        return directory;
    }

    protected void after() {
        this.txTemplate.execute(transactionStatus -> {
            this.applicationDao.remove(this.application);
            return null;
        });
    }
}

