/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.upgrade;

import com.atlassian.fecru.upgrade.ManagedRepoConversionUpgradeTask;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.GitRepType;
import com.cenqua.fisheye.config1.RepositoryType;
import com.google.common.base.Preconditions;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ManagedRepoConversionUpgradeTaskTest {
    private ManagedRepoConversionUpgradeTask task;
    private String origManagedRepoConvertProperty;
    private RepositoryType repoANotManaged;
    private RepositoryType repoBManagedEnabled;
    private RepositoryType repoCManagedDisabled;
    private RootConfig rootConfigABC;
    private RootConfig rootConfigCBA;
    private RootConfig rootConfigA;

    @Before
    public void setUp() throws Exception {
        this.task = new ManagedRepoConversionUpgradeTask();
        this.origManagedRepoConvertProperty = System.getProperty("fisheye.managed.repos.convert");
        this.repoANotManaged = new RepositoryTypeBuilder("aaa").managed(false).build();
        this.repoBManagedEnabled = new RepositoryTypeBuilder("bbb").managed(true).enabled(true).build();
        this.repoCManagedDisabled = new RepositoryTypeBuilder("ccc").managed(true).enabled(false).build();
        this.rootConfigABC = this.makeRootConfig(this.repoANotManaged, this.repoBManagedEnabled, this.repoCManagedDisabled);
        this.rootConfigCBA = this.makeRootConfig(this.repoCManagedDisabled, this.repoBManagedEnabled, this.repoANotManaged);
        this.rootConfigA = this.makeRootConfig(this.repoANotManaged);
    }

    @After
    public void tearDown() throws Exception {
        this.setManagedRepoConvertProperty(this.origManagedRepoConvertProperty);
    }

    @Test
    public void testGetManagedRepos() throws Exception {
        Assert.assertThat((String)"only managed repositories returned, ordered alphabetically", (Object)this.task.getManagedRepos(this.rootConfigABC), (Matcher)Matchers.contains((Matcher[])new Matcher[]{RepositoryTypeMatcher.isRepo(this.repoBManagedEnabled), RepositoryTypeMatcher.isRepo(this.repoCManagedDisabled)}));
        Assert.assertThat((String)"only managed repositories returned, ordered alphabetically", (Object)this.task.getManagedRepos(this.rootConfigCBA), (Matcher)Matchers.contains((Matcher[])new Matcher[]{RepositoryTypeMatcher.isRepo(this.repoBManagedEnabled), RepositoryTypeMatcher.isRepo(this.repoCManagedDisabled)}));
        Assert.assertThat((String)"only managed repositories returned or empty collection if none", (Object)this.task.getManagedRepos(this.rootConfigA), (Matcher)Matchers.empty());
    }

    @Test
    public void testPreUpgradeCheck() throws Exception {
        Assert.assertThat((String)"no managed repos - upgrade allowed", (Object)this.task.preUpgradeCheck(this.rootConfigA), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"found managed repos - upgrade disallowed", (Object)this.task.preUpgradeCheck(this.rootConfigABC), (Matcher)CoreMatchers.is((Object)false));
        this.setManagedRepoConvertProperty("true");
        Assert.assertThat((String)"found managed repos but upgrade forced - upgrade allowed", (Object)this.task.preUpgradeCheck(this.rootConfigABC), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
    }

    @Test
    public void testUpgradeConfig_NoManagedReposNoRepoManagement() throws Exception {
        RootConfig rootConfig = this.makeRootConfig(this.repoANotManaged);
        Assert.assertThat((Object)rootConfig.getConfig().isSetRepositoryManagement(), (Matcher)CoreMatchers.is((Object)false));
        this.task.upgradeConfig(rootConfig);
        Assert.assertThat((String)"still no <repositoryManagement> in the config", (Object)rootConfig.getConfig().isSetRepositoryManagement(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testUpgradeConfig_NoManagedRepoWithRepoManagement() throws Exception {
        RootConfig rootConfig = this.makeRootConfig(this.repoANotManaged);
        rootConfig.getConfig().addNewRepositoryManagement().setRepositoriesRoot("/some/folder");
        this.task.upgradeConfig(rootConfig);
        Assert.assertThat((String)"<repositoryManagement> removed from the config", (Object)rootConfig.getConfig().isSetRepositoryManagement(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testUpgradeConfig_WithManagedRepos() throws Exception {
        RootConfig rootConfig = this.makeRootConfig(this.repoANotManaged, this.repoBManagedEnabled, this.repoCManagedDisabled);
        rootConfig.getConfig().addNewRepositoryManagement().setRepositoriesRoot("/some/other/folder");
        this.task.upgradeConfig(rootConfig);
        Assert.assertThat((String)"<repositoryManagement> removed from the config", (Object)rootConfig.getConfig().isSetRepositoryManagement(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testConvertManagedRepoToStandard_NonGit() throws Exception {
        RepositoryType repo = new RepositoryTypeBuilder("nonGit").managed(true).enabled(true).gitType(false).build();
        this.task.convertManagedRepoToStandard(repo);
        Assert.assertThat((String)"This is managed repo no more", (Object)repo, (Matcher)new RepositoryTypeMatcher.Builder().name("nonGit").enabled(true).managed(false).build());
    }

    @Test
    public void testConvertManagedRepoToStandard_pollingOff() throws Exception {
        RepositoryType repo = new RepositoryTypeBuilder("pollingNever").managed(true).enabled(true).gitType(true).pollPeriod("never").build();
        this.task.convertManagedRepoToStandard(repo);
        Assert.assertThat((String)"This is managed repo no more", (Object)repo, (Matcher)new RepositoryTypeMatcher.Builder().name("pollingNever").enabled(true).managed(false).build());
        Assert.assertThat((String)"Updater removed to use default polling - managed repositories had polling off", (Object)repo.getGit().isSetUpdater(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testConvertManagedRepoToStandard_pollingWasSet() throws Exception {
        RepositoryType repo = new RepositoryTypeBuilder("pollingSet").managed(true).enabled(false).gitType(true).pollPeriod("5m").build();
        this.task.convertManagedRepoToStandard(repo);
        Assert.assertThat((String)"This is managed repo no more", (Object)repo, (Matcher)new RepositoryTypeMatcher.Builder().name("pollingSet").enabled(false).managed(false).build());
        Assert.assertThat((String)"Non default polling was set, so it was not removed", (Object)repo.getGit().isSetUpdater(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Non default polling was set, its value stay intact", (Object)repo.getGit().getUpdater().getPollPeriod(), (Matcher)CoreMatchers.is((Object)"5m"));
    }

    private RootConfig makeRootConfig(RepositoryType ... repos) {
        ConfigDocument configDocument = ConfigDocument.Factory.newInstance();
        ConfigDocument.Config config = configDocument.addNewConfig();
        config.setRepositoryArray(repos);
        config.addNewRepositoryDefaults();
        config.addNewWebServer();
        RootConfig rootConfig = new RootConfig();
        rootConfig.setConfig(configDocument);
        return rootConfig;
    }

    private void setManagedRepoConvertProperty(String value) {
        if (null == value) {
            System.clearProperty("fisheye.managed.repos.convert");
        } else {
            System.setProperty("fisheye.managed.repos.convert", value);
        }
    }

    private static class RepositoryTypeMatcher
    extends TypeSafeMatcher<RepositoryType> {
        private final Matcher<String> nameMatcher;
        private final Matcher<Boolean> enabledMatcher;
        private final Matcher<Boolean> managedMatcher;

        private RepositoryTypeMatcher(Matcher<String> nameMatcher, Matcher<Boolean> enabledMatcher, Matcher<Boolean> managedMatcher) {
            this.nameMatcher = (Matcher)Preconditions.checkNotNull(nameMatcher);
            this.enabledMatcher = (Matcher)Preconditions.checkNotNull(enabledMatcher);
            this.managedMatcher = (Matcher)Preconditions.checkNotNull(managedMatcher);
        }

        public static RepositoryTypeMatcher isRepo(RepositoryType repo) {
            return new Builder().name(repo.getName()).enabled(repo.getEnabled()).managed(repo.getManaged()).build();
        }

        protected boolean matchesSafely(RepositoryType repo) {
            return this.nameMatcher.matches((Object)repo.getName()) && this.enabledMatcher.matches((Object)repo.getEnabled()) && this.managedMatcher.matches((Object)repo.getManaged());
        }

        public void describeTo(Description description) {
            description.appendText("expected name: ");
            this.nameMatcher.describeTo(description);
            description.appendText(" and enabled: ");
            this.enabledMatcher.describeTo(description);
            description.appendText(" and managed: ");
            this.managedMatcher.describeTo(description);
        }

        public static class Builder {
            private Matcher<String> nameMatcher = CoreMatchers.any(String.class);
            private Matcher<Boolean> enabledMatcher = CoreMatchers.any(Boolean.class);
            private Matcher<Boolean> managedMatcher = CoreMatchers.any(Boolean.class);

            public Builder name(String name) {
                this.nameMatcher = CoreMatchers.equalTo((Object)name);
                return this;
            }

            public Builder enabled(boolean enabled) {
                this.enabledMatcher = CoreMatchers.equalTo((Object)enabled);
                return this;
            }

            public Builder managed(boolean managed) {
                this.managedMatcher = CoreMatchers.equalTo((Object)managed);
                return this;
            }

            public RepositoryTypeMatcher build() {
                return new RepositoryTypeMatcher(this.nameMatcher, this.enabledMatcher, this.managedMatcher);
            }
        }
    }

    private static class RepositoryTypeBuilder {
        private final String name;
        private Boolean managed;
        private Boolean enabled;
        private boolean gitType = true;
        private String pollPeriod;

        private RepositoryTypeBuilder(String name) {
            this.name = name;
        }

        public RepositoryTypeBuilder managed(Boolean managed) {
            this.managed = managed;
            return this;
        }

        public RepositoryTypeBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public RepositoryTypeBuilder gitType(boolean gitType) {
            this.gitType = gitType;
            return this;
        }

        public RepositoryTypeBuilder pollPeriod(String pollPeriod) {
            this.pollPeriod = pollPeriod;
            return this;
        }

        public RepositoryType build() {
            RepositoryType repo = RepositoryType.Factory.newInstance();
            repo.setName(this.name);
            if (null != this.managed) {
                repo.setManaged(this.managed.booleanValue());
            }
            if (null != this.enabled) {
                repo.setEnabled(this.enabled.booleanValue());
            }
            if (this.gitType) {
                GitRepType git = repo.addNewGit();
                if (null != this.pollPeriod) {
                    git.addNewUpdater().setPollPeriod(this.pollPeriod);
                }
            }
            return repo;
        }
    }
}

