/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.upgrade;

import com.atlassian.fecru.upgrade.ExcludeKnownVulnerableProtocolsUpgradeTask;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.ConfigDocument;
import com.cenqua.fisheye.config1.WebServerType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ExcludeKnownVulnerableProtocolsUpgradeTaskTest {
    ExcludeKnownVulnerableProtocolsUpgradeTask task = new ExcludeKnownVulnerableProtocolsUpgradeTask();
    RootConfig rootConfig = (RootConfig)Mockito.mock(RootConfig.class);
    private ConfigDocument config;
    private WebServerType webServer;

    @Before
    public void setUp() throws Exception {
        this.config = ConfigDocument.Factory.newInstance();
        Mockito.when((Object)this.rootConfig.getConfigDocument()).thenReturn((Object)this.config);
        this.webServer = this.config.addNewConfig().addNewWebServer();
    }

    @Test
    public void shouldAddSSL3ToExcludedIfNoExcludedOrIncluded() throws Exception {
        this.webServer.addNewSsl();
        this.task.upgradeConfig(this.rootConfig);
        Assert.assertThat((Object)this.config.getConfig().getWebServer().getSsl().getExcludeProtocols().getProtocolArray(), (Matcher)Matchers.array((Matcher[])new Matcher[]{Matchers.equalTo((Object)"SSLv3")}));
        ((RootConfig)Mockito.verify((Object)this.rootConfig)).saveConfig();
    }

    @Test
    public void shouldntAddSSL3ToExcludedIfAlreadyExcluded() throws Exception {
        this.webServer.addNewSsl().addNewExcludeProtocols().addProtocol("SSLv3");
        this.task.upgradeConfig(this.rootConfig);
        Assert.assertThat((Object)this.config.getConfig().getWebServer().getSsl().getExcludeProtocols().getProtocolArray(), (Matcher)Matchers.array((Matcher[])new Matcher[]{Matchers.equalTo((Object)"SSLv3")}));
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.never())).saveConfig();
    }

    @Test
    public void shouldntAddSSL3ToExcludedIfIncludedExplicitly() throws Exception {
        this.webServer.addNewSsl().addNewIncludeProtocols().addProtocol("SSLv3");
        this.task.upgradeConfig(this.rootConfig);
        Assert.assertThat((Object)this.config.getConfig().getWebServer().getSsl().getIncludeProtocols().getProtocolArray(), (Matcher)Matchers.array((Matcher[])new Matcher[]{Matchers.equalTo((Object)"SSLv3")}));
        Assert.assertThat((Object)this.config.getConfig().getWebServer().getSsl().isSetExcludeProtocols(), (Matcher)Matchers.is((Object)false));
        ((RootConfig)Mockito.verify((Object)this.rootConfig, (VerificationMode)Mockito.never())).saveConfig();
    }
}

