/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fecru.upgrade;

import com.atlassian.fecru.upgrade.DefaultUpgradeManager;
import com.cenqua.fisheye.ScmType;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultUpgradeManagerTest {
    DefaultUpgradeManager upgradeManager = DefaultUpgradeManager.instance;

    @Test
    public void testScmCacheVersionMatchesUpgradeTasks() throws Exception {
        ImmutableMap currentSchemaVersions = ImmutableMap.of((Object)ScmType.CVS, (Object)21, (Object)ScmType.SVN, (Object)33, (Object)ScmType.P4, (Object)12, (Object)ScmType.HG, (Object)12, (Object)ScmType.GIT, (Object)22);
        for (Map.Entry entry : currentSchemaVersions.entrySet()) {
            this.assertNoUpgradeTask((ScmType)entry.getKey(), (Integer)entry.getValue(), 100);
        }
    }

    private void assertNoUpgradeTask(ScmType scmType, int cacheVersion, int versionsAhead) {
        for (int i = 0; i < versionsAhead; ++i) {
            List upgradePath = this.upgradeManager.getUpgradePath(scmType, cacheVersion + i, cacheVersion + i + 1);
            Assert.assertThat((String)(" Scm " + scmType + " is at version " + cacheVersion + " but there is an upgrade path from version " + (cacheVersion + i) + " to " + (cacheVersion + i + 1)), (Object)upgradePath, (Matcher)Matchers.empty());
        }
    }
}

